<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ForetakSokResponse StructType
 * @subpackage Structs
 */
class ForetakSokResponse extends AbstractStructBase
{
    /**
     * The ForetakData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ForetakData[]
     */
    public $ForetakData;
    /**
     * The Meldinger
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Meldinger[]
     */
    public $Meldinger;
    /**
     * Constructor method for ForetakSokResponse
     * @uses ForetakSokResponse::setForetakData()
     * @uses ForetakSokResponse::setMeldinger()
     * @param \StructType\ForetakData[] $foretakData
     * @param \StructType\Meldinger[] $meldinger
     */
    public function __construct(array $foretakData = array(), array $meldinger = array())
    {
        $this
            ->setForetakData($foretakData)
            ->setMeldinger($meldinger);
    }
    /**
     * Get ForetakData value
     * @return \StructType\ForetakData[]|null
     */
    public function getForetakData()
    {
        return $this->ForetakData;
    }
    /**
     * Set ForetakData value
     * @throws \InvalidArgumentException
     * @param \StructType\ForetakData[] $foretakData
     * @return \StructType\ForetakSokResponse
     */
    public function setForetakData(array $foretakData = array())
    {
        foreach ($foretakData as $foretakSokResponseForetakDataItem) {
            // validation for constraint: itemType
            if (!$foretakSokResponseForetakDataItem instanceof \StructType\ForetakData) {
                throw new \InvalidArgumentException(sprintf('The ForetakData property can only contain items of \StructType\ForetakData, "%s" given', is_object($foretakSokResponseForetakDataItem) ? get_class($foretakSokResponseForetakDataItem) : gettype($foretakSokResponseForetakDataItem)), __LINE__);
            }
        }
        $this->ForetakData = $foretakData;
        return $this;
    }
    /**
     * Add item to ForetakData value
     * @throws \InvalidArgumentException
     * @param \StructType\ForetakData $item
     * @return \StructType\ForetakSokResponse
     */
    public function addToForetakData(\StructType\ForetakData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ForetakData) {
            throw new \InvalidArgumentException(sprintf('The ForetakData property can only contain items of \StructType\ForetakData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ForetakData[] = $item;
        return $this;
    }
    /**
     * Get Meldinger value
     * @return \StructType\Meldinger[]|null
     */
    public function getMeldinger()
    {
        return $this->Meldinger;
    }
    /**
     * Set Meldinger value
     * @throws \InvalidArgumentException
     * @param \StructType\Meldinger[] $meldinger
     * @return \StructType\ForetakSokResponse
     */
    public function setMeldinger(array $meldinger = array())
    {
        foreach ($meldinger as $foretakSokResponseMeldingerItem) {
            // validation for constraint: itemType
            if (!$foretakSokResponseMeldingerItem instanceof \StructType\Meldinger) {
                throw new \InvalidArgumentException(sprintf('The Meldinger property can only contain items of \StructType\Meldinger, "%s" given', is_object($foretakSokResponseMeldingerItem) ? get_class($foretakSokResponseMeldingerItem) : gettype($foretakSokResponseMeldingerItem)), __LINE__);
            }
        }
        $this->Meldinger = $meldinger;
        return $this;
    }
    /**
     * Add item to Meldinger value
     * @throws \InvalidArgumentException
     * @param \StructType\Meldinger $item
     * @return \StructType\ForetakSokResponse
     */
    public function addToMeldinger(\StructType\Meldinger $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Meldinger) {
            throw new \InvalidArgumentException(sprintf('The Meldinger property can only contain items of \StructType\Meldinger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Meldinger[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ForetakSokResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
