<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ForetakSok StructType
 * @subpackage Structs
 */
class ForetakSok extends AbstractStructBase
{
    /**
     * The Dunsnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Dunsnr;
    /**
     * The Orgnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Orgnr;
    /**
     * The Navn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Navn;
    /**
     * The Adresse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adresse;
    /**
     * The Postnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Postnr;
    /**
     * The Poststed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Poststed;
    /**
     * The Telefon
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Telefon;
    /**
     * The SokType
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SokType;
    /**
     * Constructor method for ForetakSok
     * @uses ForetakSok::setDunsnr()
     * @uses ForetakSok::setOrgnr()
     * @uses ForetakSok::setNavn()
     * @uses ForetakSok::setAdresse()
     * @uses ForetakSok::setPostnr()
     * @uses ForetakSok::setPoststed()
     * @uses ForetakSok::setTelefon()
     * @uses ForetakSok::setSokType()
     * @param int $dunsnr
     * @param int $orgnr
     * @param string $navn
     * @param string $adresse
     * @param int $postnr
     * @param string $poststed
     * @param string $telefon
     * @param string $sokType
     */
    public function __construct($dunsnr = 0, $orgnr = 0, $navn = null, $adresse = null, $postnr = 0, $poststed = null, $telefon = '0', $sokType = null)
    {
        $this
            ->setDunsnr($dunsnr)
            ->setOrgnr($orgnr)
            ->setNavn($navn)
            ->setAdresse($adresse)
            ->setPostnr($postnr)
            ->setPoststed($poststed)
            ->setTelefon($telefon)
            ->setSokType($sokType);
    }
    /**
     * Get Dunsnr value
     * @return int|null
     */
    public function getDunsnr()
    {
        return $this->Dunsnr;
    }
    /**
     * Set Dunsnr value
     * @param int $dunsnr
     * @return \StructType\ForetakSok
     */
    public function setDunsnr($dunsnr = 0)
    {
        // validation for constraint: int
        if (!is_null($dunsnr) && !is_numeric($dunsnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dunsnr)), __LINE__);
        }
        $this->Dunsnr = $dunsnr;
        return $this;
    }
    /**
     * Get Orgnr value
     * @return int|null
     */
    public function getOrgnr()
    {
        return $this->Orgnr;
    }
    /**
     * Set Orgnr value
     * @param int $orgnr
     * @return \StructType\ForetakSok
     */
    public function setOrgnr($orgnr = 0)
    {
        // validation for constraint: int
        if (!is_null($orgnr) && !is_numeric($orgnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgnr)), __LINE__);
        }
        $this->Orgnr = $orgnr;
        return $this;
    }
    /**
     * Get Navn value
     * @return string|null
     */
    public function getNavn()
    {
        return $this->Navn;
    }
    /**
     * Set Navn value
     * @param string $navn
     * @return \StructType\ForetakSok
     */
    public function setNavn($navn = null)
    {
        // validation for constraint: string
        if (!is_null($navn) && !is_string($navn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($navn)), __LINE__);
        }
        $this->Navn = $navn;
        return $this;
    }
    /**
     * Get Adresse value
     * @return string|null
     */
    public function getAdresse()
    {
        return $this->Adresse;
    }
    /**
     * Set Adresse value
     * @param string $adresse
     * @return \StructType\ForetakSok
     */
    public function setAdresse($adresse = null)
    {
        // validation for constraint: string
        if (!is_null($adresse) && !is_string($adresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adresse)), __LINE__);
        }
        $this->Adresse = $adresse;
        return $this;
    }
    /**
     * Get Postnr value
     * @return int|null
     */
    public function getPostnr()
    {
        return $this->Postnr;
    }
    /**
     * Set Postnr value
     * @param int $postnr
     * @return \StructType\ForetakSok
     */
    public function setPostnr($postnr = 0)
    {
        // validation for constraint: int
        if (!is_null($postnr) && !is_numeric($postnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($postnr)), __LINE__);
        }
        $this->Postnr = $postnr;
        return $this;
    }
    /**
     * Get Poststed value
     * @return string|null
     */
    public function getPoststed()
    {
        return $this->Poststed;
    }
    /**
     * Set Poststed value
     * @param string $poststed
     * @return \StructType\ForetakSok
     */
    public function setPoststed($poststed = null)
    {
        // validation for constraint: string
        if (!is_null($poststed) && !is_string($poststed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($poststed)), __LINE__);
        }
        $this->Poststed = $poststed;
        return $this;
    }
    /**
     * Get Telefon value
     * @return string|null
     */
    public function getTelefon()
    {
        return $this->Telefon;
    }
    /**
     * Set Telefon value
     * @param string $telefon
     * @return \StructType\ForetakSok
     */
    public function setTelefon($telefon = '0')
    {
        // validation for constraint: string
        if (!is_null($telefon) && !is_string($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telefon)), __LINE__);
        }
        $this->Telefon = $telefon;
        return $this;
    }
    /**
     * Get SokType value
     * @return string|null
     */
    public function getSokType()
    {
        return $this->SokType;
    }
    /**
     * Set SokType value
     * @uses \EnumType\SokTypeVerdier::valueIsValid()
     * @uses \EnumType\SokTypeVerdier::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sokType
     * @return \StructType\ForetakSok
     */
    public function setSokType($sokType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SokTypeVerdier::valueIsValid($sokType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sokType, implode(', ', \EnumType\SokTypeVerdier::getValidValues())), __LINE__);
        }
        $this->SokType = $sokType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ForetakSok
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
