<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ForetakData StructType
 * @subpackage Structs
 */
class ForetakData extends AbstractStructBase
{
    /**
     * The Dunsnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Dunsnr;
    /**
     * The Orgnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Orgnr;
    /**
     * The KodeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KodeType;
    /**
     * The KodeTekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KodeTekst;
    /**
     * The Selskapsform
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Selskapsform;
    /**
     * The Navn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Navn;
    /**
     * The Adresse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Adresse;
    /**
     * The Postnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Postnr;
    /**
     * The Poststed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Poststed;
    /**
     * The PostAdresse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostAdresse;
    /**
     * The PostPostnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PostPostnr;
    /**
     * The PostPoststed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostPoststed;
    /**
     * The JurAdresse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JurAdresse;
    /**
     * The JurPostnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $JurPostnr;
    /**
     * The JurPoststed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JurPoststed;
    /**
     * The Telefon
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Telefon;
    /**
     * The SisteRegnskapsAr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SisteRegnskapsAr;
    /**
     * The SisteRegnskapsMnd
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SisteRegnskapsMnd;
    /**
     * The BransjeData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BransjeData[]
     */
    public $BransjeData;
    /**
     * The SektorKode
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SektorKode;
    /**
     * The SektorTekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SektorTekst;
    /**
     * The EtablertDato
     * Meta informations extracted from the WSDL
     * - default: 0001-01-01
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EtablertDato;
    /**
     * The GjenpartsIndikator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GjenpartsIndikator;
    /**
     * Constructor method for ForetakData
     * @uses ForetakData::setDunsnr()
     * @uses ForetakData::setOrgnr()
     * @uses ForetakData::setKodeType()
     * @uses ForetakData::setKodeTekst()
     * @uses ForetakData::setSelskapsform()
     * @uses ForetakData::setNavn()
     * @uses ForetakData::setAdresse()
     * @uses ForetakData::setPostnr()
     * @uses ForetakData::setPoststed()
     * @uses ForetakData::setPostAdresse()
     * @uses ForetakData::setPostPostnr()
     * @uses ForetakData::setPostPoststed()
     * @uses ForetakData::setJurAdresse()
     * @uses ForetakData::setJurPostnr()
     * @uses ForetakData::setJurPoststed()
     * @uses ForetakData::setTelefon()
     * @uses ForetakData::setSisteRegnskapsAr()
     * @uses ForetakData::setSisteRegnskapsMnd()
     * @uses ForetakData::setBransjeData()
     * @uses ForetakData::setSektorKode()
     * @uses ForetakData::setSektorTekst()
     * @uses ForetakData::setEtablertDato()
     * @uses ForetakData::setGjenpartsIndikator()
     * @param int $dunsnr
     * @param int $orgnr
     * @param string $kodeType
     * @param string $kodeTekst
     * @param string $selskapsform
     * @param string $navn
     * @param string $adresse
     * @param int $postnr
     * @param string $poststed
     * @param string $postAdresse
     * @param int $postPostnr
     * @param string $postPoststed
     * @param string $jurAdresse
     * @param int $jurPostnr
     * @param string $jurPoststed
     * @param string $telefon
     * @param int $sisteRegnskapsAr
     * @param int $sisteRegnskapsMnd
     * @param \StructType\BransjeData[] $bransjeData
     * @param int $sektorKode
     * @param string $sektorTekst
     * @param string $etablertDato
     * @param string $gjenpartsIndikator
     */
    public function __construct($dunsnr = 0, $orgnr = 0, $kodeType = null, $kodeTekst = null, $selskapsform = null, $navn = null, $adresse = null, $postnr = 0, $poststed = null, $postAdresse = null, $postPostnr = 0, $postPoststed = null, $jurAdresse = null, $jurPostnr = 0, $jurPoststed = null, $telefon = null, $sisteRegnskapsAr = 0, $sisteRegnskapsMnd = 0, array $bransjeData = array(), $sektorKode = 0, $sektorTekst = null, $etablertDato = '0001-01-01', $gjenpartsIndikator = null)
    {
        $this
            ->setDunsnr($dunsnr)
            ->setOrgnr($orgnr)
            ->setKodeType($kodeType)
            ->setKodeTekst($kodeTekst)
            ->setSelskapsform($selskapsform)
            ->setNavn($navn)
            ->setAdresse($adresse)
            ->setPostnr($postnr)
            ->setPoststed($poststed)
            ->setPostAdresse($postAdresse)
            ->setPostPostnr($postPostnr)
            ->setPostPoststed($postPoststed)
            ->setJurAdresse($jurAdresse)
            ->setJurPostnr($jurPostnr)
            ->setJurPoststed($jurPoststed)
            ->setTelefon($telefon)
            ->setSisteRegnskapsAr($sisteRegnskapsAr)
            ->setSisteRegnskapsMnd($sisteRegnskapsMnd)
            ->setBransjeData($bransjeData)
            ->setSektorKode($sektorKode)
            ->setSektorTekst($sektorTekst)
            ->setEtablertDato($etablertDato)
            ->setGjenpartsIndikator($gjenpartsIndikator);
    }
    /**
     * Get Dunsnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDunsnr()
    {
        return isset($this->Dunsnr) ? $this->Dunsnr : null;
    }
    /**
     * Set Dunsnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $dunsnr
     * @return \StructType\ForetakData
     */
    public function setDunsnr($dunsnr = 0)
    {
        // validation for constraint: int
        if (!is_null($dunsnr) && !is_numeric($dunsnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dunsnr)), __LINE__);
        }
        if (is_null($dunsnr) || (is_array($dunsnr) && empty($dunsnr))) {
            unset($this->Dunsnr);
        } else {
            $this->Dunsnr = $dunsnr;
        }
        return $this;
    }
    /**
     * Get Orgnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrgnr()
    {
        return isset($this->Orgnr) ? $this->Orgnr : null;
    }
    /**
     * Set Orgnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $orgnr
     * @return \StructType\ForetakData
     */
    public function setOrgnr($orgnr = 0)
    {
        // validation for constraint: int
        if (!is_null($orgnr) && !is_numeric($orgnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgnr)), __LINE__);
        }
        if (is_null($orgnr) || (is_array($orgnr) && empty($orgnr))) {
            unset($this->Orgnr);
        } else {
            $this->Orgnr = $orgnr;
        }
        return $this;
    }
    /**
     * Get KodeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKodeType()
    {
        return isset($this->KodeType) ? $this->KodeType : null;
    }
    /**
     * Set KodeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kodeType
     * @return \StructType\ForetakData
     */
    public function setKodeType($kodeType = null)
    {
        // validation for constraint: string
        if (!is_null($kodeType) && !is_string($kodeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kodeType)), __LINE__);
        }
        if (is_null($kodeType) || (is_array($kodeType) && empty($kodeType))) {
            unset($this->KodeType);
        } else {
            $this->KodeType = $kodeType;
        }
        return $this;
    }
    /**
     * Get KodeTekst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKodeTekst()
    {
        return isset($this->KodeTekst) ? $this->KodeTekst : null;
    }
    /**
     * Set KodeTekst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kodeTekst
     * @return \StructType\ForetakData
     */
    public function setKodeTekst($kodeTekst = null)
    {
        // validation for constraint: string
        if (!is_null($kodeTekst) && !is_string($kodeTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kodeTekst)), __LINE__);
        }
        if (is_null($kodeTekst) || (is_array($kodeTekst) && empty($kodeTekst))) {
            unset($this->KodeTekst);
        } else {
            $this->KodeTekst = $kodeTekst;
        }
        return $this;
    }
    /**
     * Get Selskapsform value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelskapsform()
    {
        return isset($this->Selskapsform) ? $this->Selskapsform : null;
    }
    /**
     * Set Selskapsform value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selskapsform
     * @return \StructType\ForetakData
     */
    public function setSelskapsform($selskapsform = null)
    {
        // validation for constraint: string
        if (!is_null($selskapsform) && !is_string($selskapsform)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($selskapsform)), __LINE__);
        }
        if (is_null($selskapsform) || (is_array($selskapsform) && empty($selskapsform))) {
            unset($this->Selskapsform);
        } else {
            $this->Selskapsform = $selskapsform;
        }
        return $this;
    }
    /**
     * Get Navn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNavn()
    {
        return isset($this->Navn) ? $this->Navn : null;
    }
    /**
     * Set Navn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $navn
     * @return \StructType\ForetakData
     */
    public function setNavn($navn = null)
    {
        // validation for constraint: string
        if (!is_null($navn) && !is_string($navn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($navn)), __LINE__);
        }
        if (is_null($navn) || (is_array($navn) && empty($navn))) {
            unset($this->Navn);
        } else {
            $this->Navn = $navn;
        }
        return $this;
    }
    /**
     * Get Adresse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdresse()
    {
        return isset($this->Adresse) ? $this->Adresse : null;
    }
    /**
     * Set Adresse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adresse
     * @return \StructType\ForetakData
     */
    public function setAdresse($adresse = null)
    {
        // validation for constraint: string
        if (!is_null($adresse) && !is_string($adresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adresse)), __LINE__);
        }
        if (is_null($adresse) || (is_array($adresse) && empty($adresse))) {
            unset($this->Adresse);
        } else {
            $this->Adresse = $adresse;
        }
        return $this;
    }
    /**
     * Get Postnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPostnr()
    {
        return isset($this->Postnr) ? $this->Postnr : null;
    }
    /**
     * Set Postnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $postnr
     * @return \StructType\ForetakData
     */
    public function setPostnr($postnr = 0)
    {
        // validation for constraint: int
        if (!is_null($postnr) && !is_numeric($postnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($postnr)), __LINE__);
        }
        if (is_null($postnr) || (is_array($postnr) && empty($postnr))) {
            unset($this->Postnr);
        } else {
            $this->Postnr = $postnr;
        }
        return $this;
    }
    /**
     * Get Poststed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPoststed()
    {
        return isset($this->Poststed) ? $this->Poststed : null;
    }
    /**
     * Set Poststed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $poststed
     * @return \StructType\ForetakData
     */
    public function setPoststed($poststed = null)
    {
        // validation for constraint: string
        if (!is_null($poststed) && !is_string($poststed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($poststed)), __LINE__);
        }
        if (is_null($poststed) || (is_array($poststed) && empty($poststed))) {
            unset($this->Poststed);
        } else {
            $this->Poststed = $poststed;
        }
        return $this;
    }
    /**
     * Get PostAdresse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostAdresse()
    {
        return isset($this->PostAdresse) ? $this->PostAdresse : null;
    }
    /**
     * Set PostAdresse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postAdresse
     * @return \StructType\ForetakData
     */
    public function setPostAdresse($postAdresse = null)
    {
        // validation for constraint: string
        if (!is_null($postAdresse) && !is_string($postAdresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postAdresse)), __LINE__);
        }
        if (is_null($postAdresse) || (is_array($postAdresse) && empty($postAdresse))) {
            unset($this->PostAdresse);
        } else {
            $this->PostAdresse = $postAdresse;
        }
        return $this;
    }
    /**
     * Get PostPostnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPostPostnr()
    {
        return isset($this->PostPostnr) ? $this->PostPostnr : null;
    }
    /**
     * Set PostPostnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $postPostnr
     * @return \StructType\ForetakData
     */
    public function setPostPostnr($postPostnr = 0)
    {
        // validation for constraint: int
        if (!is_null($postPostnr) && !is_numeric($postPostnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($postPostnr)), __LINE__);
        }
        if (is_null($postPostnr) || (is_array($postPostnr) && empty($postPostnr))) {
            unset($this->PostPostnr);
        } else {
            $this->PostPostnr = $postPostnr;
        }
        return $this;
    }
    /**
     * Get PostPoststed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostPoststed()
    {
        return isset($this->PostPoststed) ? $this->PostPoststed : null;
    }
    /**
     * Set PostPoststed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postPoststed
     * @return \StructType\ForetakData
     */
    public function setPostPoststed($postPoststed = null)
    {
        // validation for constraint: string
        if (!is_null($postPoststed) && !is_string($postPoststed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postPoststed)), __LINE__);
        }
        if (is_null($postPoststed) || (is_array($postPoststed) && empty($postPoststed))) {
            unset($this->PostPoststed);
        } else {
            $this->PostPoststed = $postPoststed;
        }
        return $this;
    }
    /**
     * Get JurAdresse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJurAdresse()
    {
        return isset($this->JurAdresse) ? $this->JurAdresse : null;
    }
    /**
     * Set JurAdresse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jurAdresse
     * @return \StructType\ForetakData
     */
    public function setJurAdresse($jurAdresse = null)
    {
        // validation for constraint: string
        if (!is_null($jurAdresse) && !is_string($jurAdresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jurAdresse)), __LINE__);
        }
        if (is_null($jurAdresse) || (is_array($jurAdresse) && empty($jurAdresse))) {
            unset($this->JurAdresse);
        } else {
            $this->JurAdresse = $jurAdresse;
        }
        return $this;
    }
    /**
     * Get JurPostnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getJurPostnr()
    {
        return isset($this->JurPostnr) ? $this->JurPostnr : null;
    }
    /**
     * Set JurPostnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $jurPostnr
     * @return \StructType\ForetakData
     */
    public function setJurPostnr($jurPostnr = 0)
    {
        // validation for constraint: int
        if (!is_null($jurPostnr) && !is_numeric($jurPostnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($jurPostnr)), __LINE__);
        }
        if (is_null($jurPostnr) || (is_array($jurPostnr) && empty($jurPostnr))) {
            unset($this->JurPostnr);
        } else {
            $this->JurPostnr = $jurPostnr;
        }
        return $this;
    }
    /**
     * Get JurPoststed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJurPoststed()
    {
        return isset($this->JurPoststed) ? $this->JurPoststed : null;
    }
    /**
     * Set JurPoststed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jurPoststed
     * @return \StructType\ForetakData
     */
    public function setJurPoststed($jurPoststed = null)
    {
        // validation for constraint: string
        if (!is_null($jurPoststed) && !is_string($jurPoststed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jurPoststed)), __LINE__);
        }
        if (is_null($jurPoststed) || (is_array($jurPoststed) && empty($jurPoststed))) {
            unset($this->JurPoststed);
        } else {
            $this->JurPoststed = $jurPoststed;
        }
        return $this;
    }
    /**
     * Get Telefon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefon()
    {
        return isset($this->Telefon) ? $this->Telefon : null;
    }
    /**
     * Set Telefon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefon
     * @return \StructType\ForetakData
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: string
        if (!is_null($telefon) && !is_string($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telefon)), __LINE__);
        }
        if (is_null($telefon) || (is_array($telefon) && empty($telefon))) {
            unset($this->Telefon);
        } else {
            $this->Telefon = $telefon;
        }
        return $this;
    }
    /**
     * Get SisteRegnskapsAr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSisteRegnskapsAr()
    {
        return isset($this->SisteRegnskapsAr) ? $this->SisteRegnskapsAr : null;
    }
    /**
     * Set SisteRegnskapsAr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sisteRegnskapsAr
     * @return \StructType\ForetakData
     */
    public function setSisteRegnskapsAr($sisteRegnskapsAr = 0)
    {
        // validation for constraint: int
        if (!is_null($sisteRegnskapsAr) && !is_numeric($sisteRegnskapsAr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sisteRegnskapsAr)), __LINE__);
        }
        if (is_null($sisteRegnskapsAr) || (is_array($sisteRegnskapsAr) && empty($sisteRegnskapsAr))) {
            unset($this->SisteRegnskapsAr);
        } else {
            $this->SisteRegnskapsAr = $sisteRegnskapsAr;
        }
        return $this;
    }
    /**
     * Get SisteRegnskapsMnd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSisteRegnskapsMnd()
    {
        return isset($this->SisteRegnskapsMnd) ? $this->SisteRegnskapsMnd : null;
    }
    /**
     * Set SisteRegnskapsMnd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sisteRegnskapsMnd
     * @return \StructType\ForetakData
     */
    public function setSisteRegnskapsMnd($sisteRegnskapsMnd = 0)
    {
        // validation for constraint: int
        if (!is_null($sisteRegnskapsMnd) && !is_numeric($sisteRegnskapsMnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sisteRegnskapsMnd)), __LINE__);
        }
        if (is_null($sisteRegnskapsMnd) || (is_array($sisteRegnskapsMnd) && empty($sisteRegnskapsMnd))) {
            unset($this->SisteRegnskapsMnd);
        } else {
            $this->SisteRegnskapsMnd = $sisteRegnskapsMnd;
        }
        return $this;
    }
    /**
     * Get BransjeData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BransjeData[]|null
     */
    public function getBransjeData()
    {
        return isset($this->BransjeData) ? $this->BransjeData : null;
    }
    /**
     * Set BransjeData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BransjeData[] $bransjeData
     * @return \StructType\ForetakData
     */
    public function setBransjeData(array $bransjeData = array())
    {
        foreach ($bransjeData as $foretakDataBransjeDataItem) {
            // validation for constraint: itemType
            if (!$foretakDataBransjeDataItem instanceof \StructType\BransjeData) {
                throw new \InvalidArgumentException(sprintf('The BransjeData property can only contain items of \StructType\BransjeData, "%s" given', is_object($foretakDataBransjeDataItem) ? get_class($foretakDataBransjeDataItem) : gettype($foretakDataBransjeDataItem)), __LINE__);
            }
        }
        if (is_null($bransjeData) || (is_array($bransjeData) && empty($bransjeData))) {
            unset($this->BransjeData);
        } else {
            $this->BransjeData = $bransjeData;
        }
        return $this;
    }
    /**
     * Add item to BransjeData value
     * @throws \InvalidArgumentException
     * @param \StructType\BransjeData $item
     * @return \StructType\ForetakData
     */
    public function addToBransjeData(\StructType\BransjeData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BransjeData) {
            throw new \InvalidArgumentException(sprintf('The BransjeData property can only contain items of \StructType\BransjeData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BransjeData[] = $item;
        return $this;
    }
    /**
     * Get SektorKode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSektorKode()
    {
        return isset($this->SektorKode) ? $this->SektorKode : null;
    }
    /**
     * Set SektorKode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sektorKode
     * @return \StructType\ForetakData
     */
    public function setSektorKode($sektorKode = 0)
    {
        // validation for constraint: int
        if (!is_null($sektorKode) && !is_numeric($sektorKode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sektorKode)), __LINE__);
        }
        if (is_null($sektorKode) || (is_array($sektorKode) && empty($sektorKode))) {
            unset($this->SektorKode);
        } else {
            $this->SektorKode = $sektorKode;
        }
        return $this;
    }
    /**
     * Get SektorTekst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSektorTekst()
    {
        return isset($this->SektorTekst) ? $this->SektorTekst : null;
    }
    /**
     * Set SektorTekst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sektorTekst
     * @return \StructType\ForetakData
     */
    public function setSektorTekst($sektorTekst = null)
    {
        // validation for constraint: string
        if (!is_null($sektorTekst) && !is_string($sektorTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sektorTekst)), __LINE__);
        }
        if (is_null($sektorTekst) || (is_array($sektorTekst) && empty($sektorTekst))) {
            unset($this->SektorTekst);
        } else {
            $this->SektorTekst = $sektorTekst;
        }
        return $this;
    }
    /**
     * Get EtablertDato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEtablertDato()
    {
        return isset($this->EtablertDato) ? $this->EtablertDato : null;
    }
    /**
     * Set EtablertDato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $etablertDato
     * @return \StructType\ForetakData
     */
    public function setEtablertDato($etablertDato = '0001-01-01')
    {
        // validation for constraint: string
        if (!is_null($etablertDato) && !is_string($etablertDato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($etablertDato)), __LINE__);
        }
        if (is_null($etablertDato) || (is_array($etablertDato) && empty($etablertDato))) {
            unset($this->EtablertDato);
        } else {
            $this->EtablertDato = $etablertDato;
        }
        return $this;
    }
    /**
     * Get GjenpartsIndikator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGjenpartsIndikator()
    {
        return isset($this->GjenpartsIndikator) ? $this->GjenpartsIndikator : null;
    }
    /**
     * Set GjenpartsIndikator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gjenpartsIndikator
     * @return \StructType\ForetakData
     */
    public function setGjenpartsIndikator($gjenpartsIndikator = null)
    {
        // validation for constraint: string
        if (!is_null($gjenpartsIndikator) && !is_string($gjenpartsIndikator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gjenpartsIndikator)), __LINE__);
        }
        if (is_null($gjenpartsIndikator) || (is_array($gjenpartsIndikator) && empty($gjenpartsIndikator))) {
            unset($this->GjenpartsIndikator);
        } else {
            $this->GjenpartsIndikator = $gjenpartsIndikator;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ForetakData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
