<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EiendomNorgeListe StructType
 * @subpackage Structs
 */
class EiendomNorgeListe extends AbstractStructBase
{
    /**
     * The Kommunenr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Kommunenr;
    /**
     * The KommuneNavn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KommuneNavn;
    /**
     * The Gardnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Gardnr;
    /**
     * The Bruksnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Bruksnr;
    /**
     * The Festenr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Festenr;
    /**
     * The Seksjonsnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Seksjonsnr;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The Andel
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Andel;
    /**
     * Constructor method for EiendomNorgeListe
     * @uses EiendomNorgeListe::setKommunenr()
     * @uses EiendomNorgeListe::setKommuneNavn()
     * @uses EiendomNorgeListe::setGardnr()
     * @uses EiendomNorgeListe::setBruksnr()
     * @uses EiendomNorgeListe::setFestenr()
     * @uses EiendomNorgeListe::setSeksjonsnr()
     * @uses EiendomNorgeListe::setType()
     * @uses EiendomNorgeListe::setAndel()
     * @param int $kommunenr
     * @param string $kommuneNavn
     * @param int $gardnr
     * @param int $bruksnr
     * @param int $festenr
     * @param int $seksjonsnr
     * @param string $type
     * @param string $andel
     */
    public function __construct($kommunenr = 0, $kommuneNavn = null, $gardnr = 0, $bruksnr = 0, $festenr = 0, $seksjonsnr = 0, $type = '0', $andel = '0')
    {
        $this
            ->setKommunenr($kommunenr)
            ->setKommuneNavn($kommuneNavn)
            ->setGardnr($gardnr)
            ->setBruksnr($bruksnr)
            ->setFestenr($festenr)
            ->setSeksjonsnr($seksjonsnr)
            ->setType($type)
            ->setAndel($andel);
    }
    /**
     * Get Kommunenr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKommunenr()
    {
        return isset($this->Kommunenr) ? $this->Kommunenr : null;
    }
    /**
     * Set Kommunenr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $kommunenr
     * @return \StructType\EiendomNorgeListe
     */
    public function setKommunenr($kommunenr = 0)
    {
        // validation for constraint: int
        if (!is_null($kommunenr) && !is_numeric($kommunenr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kommunenr)), __LINE__);
        }
        if (is_null($kommunenr) || (is_array($kommunenr) && empty($kommunenr))) {
            unset($this->Kommunenr);
        } else {
            $this->Kommunenr = $kommunenr;
        }
        return $this;
    }
    /**
     * Get KommuneNavn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKommuneNavn()
    {
        return isset($this->KommuneNavn) ? $this->KommuneNavn : null;
    }
    /**
     * Set KommuneNavn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kommuneNavn
     * @return \StructType\EiendomNorgeListe
     */
    public function setKommuneNavn($kommuneNavn = null)
    {
        // validation for constraint: string
        if (!is_null($kommuneNavn) && !is_string($kommuneNavn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kommuneNavn)), __LINE__);
        }
        if (is_null($kommuneNavn) || (is_array($kommuneNavn) && empty($kommuneNavn))) {
            unset($this->KommuneNavn);
        } else {
            $this->KommuneNavn = $kommuneNavn;
        }
        return $this;
    }
    /**
     * Get Gardnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGardnr()
    {
        return isset($this->Gardnr) ? $this->Gardnr : null;
    }
    /**
     * Set Gardnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $gardnr
     * @return \StructType\EiendomNorgeListe
     */
    public function setGardnr($gardnr = 0)
    {
        // validation for constraint: int
        if (!is_null($gardnr) && !is_numeric($gardnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($gardnr)), __LINE__);
        }
        if (is_null($gardnr) || (is_array($gardnr) && empty($gardnr))) {
            unset($this->Gardnr);
        } else {
            $this->Gardnr = $gardnr;
        }
        return $this;
    }
    /**
     * Get Bruksnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBruksnr()
    {
        return isset($this->Bruksnr) ? $this->Bruksnr : null;
    }
    /**
     * Set Bruksnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bruksnr
     * @return \StructType\EiendomNorgeListe
     */
    public function setBruksnr($bruksnr = 0)
    {
        // validation for constraint: int
        if (!is_null($bruksnr) && !is_numeric($bruksnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bruksnr)), __LINE__);
        }
        if (is_null($bruksnr) || (is_array($bruksnr) && empty($bruksnr))) {
            unset($this->Bruksnr);
        } else {
            $this->Bruksnr = $bruksnr;
        }
        return $this;
    }
    /**
     * Get Festenr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFestenr()
    {
        return isset($this->Festenr) ? $this->Festenr : null;
    }
    /**
     * Set Festenr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $festenr
     * @return \StructType\EiendomNorgeListe
     */
    public function setFestenr($festenr = 0)
    {
        // validation for constraint: int
        if (!is_null($festenr) && !is_numeric($festenr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($festenr)), __LINE__);
        }
        if (is_null($festenr) || (is_array($festenr) && empty($festenr))) {
            unset($this->Festenr);
        } else {
            $this->Festenr = $festenr;
        }
        return $this;
    }
    /**
     * Get Seksjonsnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeksjonsnr()
    {
        return isset($this->Seksjonsnr) ? $this->Seksjonsnr : null;
    }
    /**
     * Set Seksjonsnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seksjonsnr
     * @return \StructType\EiendomNorgeListe
     */
    public function setSeksjonsnr($seksjonsnr = 0)
    {
        // validation for constraint: int
        if (!is_null($seksjonsnr) && !is_numeric($seksjonsnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seksjonsnr)), __LINE__);
        }
        if (is_null($seksjonsnr) || (is_array($seksjonsnr) && empty($seksjonsnr))) {
            unset($this->Seksjonsnr);
        } else {
            $this->Seksjonsnr = $seksjonsnr;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \StructType\EiendomNorgeListe
     */
    public function setType($type = '0')
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get Andel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAndel()
    {
        return isset($this->Andel) ? $this->Andel : null;
    }
    /**
     * Set Andel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $andel
     * @return \StructType\EiendomNorgeListe
     */
    public function setAndel($andel = '0')
    {
        // validation for constraint: string
        if (!is_null($andel) && !is_string($andel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($andel)), __LINE__);
        }
        if (is_null($andel) || (is_array($andel) && empty($andel))) {
            unset($this->Andel);
        } else {
            $this->Andel = $andel;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EiendomNorgeListe
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
