<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArsaksData StructType
 * @subpackage Structs
 */
class ArsaksData extends AbstractStructBase
{
    /**
     * The ArsaksKode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArsaksKode;
    /**
     * The ArsaksTekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArsaksTekst;
    /**
     * Constructor method for ArsaksData
     * @uses ArsaksData::setArsaksKode()
     * @uses ArsaksData::setArsaksTekst()
     * @param string $arsaksKode
     * @param string $arsaksTekst
     */
    public function __construct($arsaksKode = null, $arsaksTekst = null)
    {
        $this
            ->setArsaksKode($arsaksKode)
            ->setArsaksTekst($arsaksTekst);
    }
    /**
     * Get ArsaksKode value
     * @return string|null
     */
    public function getArsaksKode()
    {
        return $this->ArsaksKode;
    }
    /**
     * Set ArsaksKode value
     * @param string $arsaksKode
     * @return \StructType\ArsaksData
     */
    public function setArsaksKode($arsaksKode = null)
    {
        // validation for constraint: string
        if (!is_null($arsaksKode) && !is_string($arsaksKode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arsaksKode)), __LINE__);
        }
        $this->ArsaksKode = $arsaksKode;
        return $this;
    }
    /**
     * Get ArsaksTekst value
     * @return string|null
     */
    public function getArsaksTekst()
    {
        return $this->ArsaksTekst;
    }
    /**
     * Set ArsaksTekst value
     * @param string $arsaksTekst
     * @return \StructType\ArsaksData
     */
    public function setArsaksTekst($arsaksTekst = null)
    {
        // validation for constraint: string
        if (!is_null($arsaksTekst) && !is_string($arsaksTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arsaksTekst)), __LINE__);
        }
        $this->ArsaksTekst = $arsaksTekst;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArsaksData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
