<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Aksjonar StructType
 * @subpackage Structs
 */
class Aksjonar extends AbstractStructBase
{
    /**
     * The Orgnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Orgnr;
    /**
     * The InternRef
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InternRef;
    /**
     * The FodtDato
     * Meta informations extracted from the WSDL
     * - default: 0001-01-01
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FodtDato;
    /**
     * The Navn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Navn;
    /**
     * The Postnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Postnr;
    /**
     * The Poststed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Poststed;
    /**
     * The Eierandel
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Eierandel;
    /**
     * Constructor method for Aksjonar
     * @uses Aksjonar::setOrgnr()
     * @uses Aksjonar::setInternRef()
     * @uses Aksjonar::setFodtDato()
     * @uses Aksjonar::setNavn()
     * @uses Aksjonar::setPostnr()
     * @uses Aksjonar::setPoststed()
     * @uses Aksjonar::setEierandel()
     * @param int $orgnr
     * @param int $internRef
     * @param string $fodtDato
     * @param string $navn
     * @param int $postnr
     * @param string $poststed
     * @param float $eierandel
     */
    public function __construct($orgnr = 0, $internRef = 0, $fodtDato = '0001-01-01', $navn = null, $postnr = 0, $poststed = null, $eierandel = 0)
    {
        $this
            ->setOrgnr($orgnr)
            ->setInternRef($internRef)
            ->setFodtDato($fodtDato)
            ->setNavn($navn)
            ->setPostnr($postnr)
            ->setPoststed($poststed)
            ->setEierandel($eierandel);
    }
    /**
     * Get Orgnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrgnr()
    {
        return isset($this->Orgnr) ? $this->Orgnr : null;
    }
    /**
     * Set Orgnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $orgnr
     * @return \StructType\Aksjonar
     */
    public function setOrgnr($orgnr = 0)
    {
        // validation for constraint: int
        if (!is_null($orgnr) && !is_numeric($orgnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgnr)), __LINE__);
        }
        if (is_null($orgnr) || (is_array($orgnr) && empty($orgnr))) {
            unset($this->Orgnr);
        } else {
            $this->Orgnr = $orgnr;
        }
        return $this;
    }
    /**
     * Get InternRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInternRef()
    {
        return isset($this->InternRef) ? $this->InternRef : null;
    }
    /**
     * Set InternRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $internRef
     * @return \StructType\Aksjonar
     */
    public function setInternRef($internRef = 0)
    {
        // validation for constraint: int
        if (!is_null($internRef) && !is_numeric($internRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internRef)), __LINE__);
        }
        if (is_null($internRef) || (is_array($internRef) && empty($internRef))) {
            unset($this->InternRef);
        } else {
            $this->InternRef = $internRef;
        }
        return $this;
    }
    /**
     * Get FodtDato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFodtDato()
    {
        return isset($this->FodtDato) ? $this->FodtDato : null;
    }
    /**
     * Set FodtDato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fodtDato
     * @return \StructType\Aksjonar
     */
    public function setFodtDato($fodtDato = '0001-01-01')
    {
        // validation for constraint: string
        if (!is_null($fodtDato) && !is_string($fodtDato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fodtDato)), __LINE__);
        }
        if (is_null($fodtDato) || (is_array($fodtDato) && empty($fodtDato))) {
            unset($this->FodtDato);
        } else {
            $this->FodtDato = $fodtDato;
        }
        return $this;
    }
    /**
     * Get Navn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNavn()
    {
        return isset($this->Navn) ? $this->Navn : null;
    }
    /**
     * Set Navn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $navn
     * @return \StructType\Aksjonar
     */
    public function setNavn($navn = null)
    {
        // validation for constraint: string
        if (!is_null($navn) && !is_string($navn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($navn)), __LINE__);
        }
        if (is_null($navn) || (is_array($navn) && empty($navn))) {
            unset($this->Navn);
        } else {
            $this->Navn = $navn;
        }
        return $this;
    }
    /**
     * Get Postnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPostnr()
    {
        return isset($this->Postnr) ? $this->Postnr : null;
    }
    /**
     * Set Postnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $postnr
     * @return \StructType\Aksjonar
     */
    public function setPostnr($postnr = 0)
    {
        // validation for constraint: int
        if (!is_null($postnr) && !is_numeric($postnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($postnr)), __LINE__);
        }
        if (is_null($postnr) || (is_array($postnr) && empty($postnr))) {
            unset($this->Postnr);
        } else {
            $this->Postnr = $postnr;
        }
        return $this;
    }
    /**
     * Get Poststed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPoststed()
    {
        return isset($this->Poststed) ? $this->Poststed : null;
    }
    /**
     * Set Poststed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $poststed
     * @return \StructType\Aksjonar
     */
    public function setPoststed($poststed = null)
    {
        // validation for constraint: string
        if (!is_null($poststed) && !is_string($poststed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($poststed)), __LINE__);
        }
        if (is_null($poststed) || (is_array($poststed) && empty($poststed))) {
            unset($this->Poststed);
        } else {
            $this->Poststed = $poststed;
        }
        return $this;
    }
    /**
     * Get Eierandel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getEierandel()
    {
        return isset($this->Eierandel) ? $this->Eierandel : null;
    }
    /**
     * Set Eierandel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $eierandel
     * @return \StructType\Aksjonar
     */
    public function setEierandel($eierandel = 0)
    {
        if (is_null($eierandel) || (is_array($eierandel) && empty($eierandel))) {
            unset($this->Eierandel);
        } else {
            $this->Eierandel = $eierandel;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Aksjonar
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
