<?php

namespace EnumType;

/**
 * This class stands for ProduserElektroniskGjenpartVerdier EnumType
 * @subpackage Enumerations
 */
class ProduserElektroniskGjenpartVerdier
{
    /**
     * Constant for value 'Kunde'
     * @return string 'Kunde'
     */
    const VALUE_KUNDE = 'Kunde';
    /**
     * Constant for value 'Standard'
     * @return string 'Standard'
     */
    const VALUE_STANDARD = 'Standard';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KUNDE
     * @uses self::VALUE_STANDARD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KUNDE,
            self::VALUE_STANDARD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
