<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Verv StructType
 * @subpackage Structs
 */
class Verv extends AbstractStructBase
{
    /**
     * The InternRef
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InternRef;
    /**
     * The FodtDato
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FodtDato;
    /**
     * The Navn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Navn;
    /**
     * The Fornavn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fornavn;
    /**
     * The Mellomnavn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mellomnavn;
    /**
     * The Etternavn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Etternavn;
    /**
     * The Telefon
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Telefon;
    /**
     * The Adresse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Adresse;
    /**
     * The Postnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Postnr;
    /**
     * The Poststed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Poststed;
    /**
     * The VervKode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VervKode;
    /**
     * The VervTekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VervTekst;
    /**
     * The Landkode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Landkode;
    /**
     * Constructor method for Verv
     * @uses Verv::setInternRef()
     * @uses Verv::setFodtDato()
     * @uses Verv::setNavn()
     * @uses Verv::setFornavn()
     * @uses Verv::setMellomnavn()
     * @uses Verv::setEtternavn()
     * @uses Verv::setTelefon()
     * @uses Verv::setAdresse()
     * @uses Verv::setPostnr()
     * @uses Verv::setPoststed()
     * @uses Verv::setVervKode()
     * @uses Verv::setVervTekst()
     * @uses Verv::setLandkode()
     * @param int $internRef
     * @param string $fodtDato
     * @param string $navn
     * @param string $fornavn
     * @param string $mellomnavn
     * @param string $etternavn
     * @param string[] $telefon
     * @param string $adresse
     * @param int $postnr
     * @param string $poststed
     * @param string $vervKode
     * @param string $vervTekst
     * @param string $landkode
     */
    public function __construct($internRef = 0, $fodtDato = null, $navn = null, $fornavn = null, $mellomnavn = null, $etternavn = null, array $telefon = array(), $adresse = null, $postnr = 0, $poststed = null, $vervKode = null, $vervTekst = null, $landkode = null)
    {
        $this
            ->setInternRef($internRef)
            ->setFodtDato($fodtDato)
            ->setNavn($navn)
            ->setFornavn($fornavn)
            ->setMellomnavn($mellomnavn)
            ->setEtternavn($etternavn)
            ->setTelefon($telefon)
            ->setAdresse($adresse)
            ->setPostnr($postnr)
            ->setPoststed($poststed)
            ->setVervKode($vervKode)
            ->setVervTekst($vervTekst)
            ->setLandkode($landkode);
    }
    /**
     * Get InternRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInternRef()
    {
        return isset($this->InternRef) ? $this->InternRef : null;
    }
    /**
     * Set InternRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $internRef
     * @return \StructType\Verv
     */
    public function setInternRef($internRef = 0)
    {
        // validation for constraint: int
        if (!is_null($internRef) && !is_numeric($internRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internRef)), __LINE__);
        }
        if (is_null($internRef) || (is_array($internRef) && empty($internRef))) {
            unset($this->InternRef);
        } else {
            $this->InternRef = $internRef;
        }
        return $this;
    }
    /**
     * Get FodtDato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFodtDato()
    {
        return isset($this->FodtDato) ? $this->FodtDato : null;
    }
    /**
     * Set FodtDato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fodtDato
     * @return \StructType\Verv
     */
    public function setFodtDato($fodtDato = null)
    {
        // validation for constraint: string
        if (!is_null($fodtDato) && !is_string($fodtDato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fodtDato)), __LINE__);
        }
        if (is_null($fodtDato) || (is_array($fodtDato) && empty($fodtDato))) {
            unset($this->FodtDato);
        } else {
            $this->FodtDato = $fodtDato;
        }
        return $this;
    }
    /**
     * Get Navn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNavn()
    {
        return isset($this->Navn) ? $this->Navn : null;
    }
    /**
     * Set Navn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $navn
     * @return \StructType\Verv
     */
    public function setNavn($navn = null)
    {
        // validation for constraint: string
        if (!is_null($navn) && !is_string($navn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($navn)), __LINE__);
        }
        if (is_null($navn) || (is_array($navn) && empty($navn))) {
            unset($this->Navn);
        } else {
            $this->Navn = $navn;
        }
        return $this;
    }
    /**
     * Get Fornavn value
     * @return string|null
     */
    public function getFornavn()
    {
        return $this->Fornavn;
    }
    /**
     * Set Fornavn value
     * @param string $fornavn
     * @return \StructType\Verv
     */
    public function setFornavn($fornavn = null)
    {
        // validation for constraint: string
        if (!is_null($fornavn) && !is_string($fornavn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fornavn)), __LINE__);
        }
        $this->Fornavn = $fornavn;
        return $this;
    }
    /**
     * Get Mellomnavn value
     * @return string|null
     */
    public function getMellomnavn()
    {
        return $this->Mellomnavn;
    }
    /**
     * Set Mellomnavn value
     * @param string $mellomnavn
     * @return \StructType\Verv
     */
    public function setMellomnavn($mellomnavn = null)
    {
        // validation for constraint: string
        if (!is_null($mellomnavn) && !is_string($mellomnavn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mellomnavn)), __LINE__);
        }
        $this->Mellomnavn = $mellomnavn;
        return $this;
    }
    /**
     * Get Etternavn value
     * @return string|null
     */
    public function getEtternavn()
    {
        return $this->Etternavn;
    }
    /**
     * Set Etternavn value
     * @param string $etternavn
     * @return \StructType\Verv
     */
    public function setEtternavn($etternavn = null)
    {
        // validation for constraint: string
        if (!is_null($etternavn) && !is_string($etternavn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($etternavn)), __LINE__);
        }
        $this->Etternavn = $etternavn;
        return $this;
    }
    /**
     * Get Telefon value
     * @return string[]|null
     */
    public function getTelefon()
    {
        return $this->Telefon;
    }
    /**
     * Set Telefon value
     * @throws \InvalidArgumentException
     * @param string[] $telefon
     * @return \StructType\Verv
     */
    public function setTelefon(array $telefon = array())
    {
        foreach ($telefon as $vervTelefonItem) {
            // validation for constraint: itemType
            if (!is_string($vervTelefonItem)) {
                throw new \InvalidArgumentException(sprintf('The Telefon property can only contain items of string, "%s" given', is_object($vervTelefonItem) ? get_class($vervTelefonItem) : gettype($vervTelefonItem)), __LINE__);
            }
        }
        $this->Telefon = $telefon;
        return $this;
    }
    /**
     * Add item to Telefon value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Verv
     */
    public function addToTelefon($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Telefon property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Telefon[] = $item;
        return $this;
    }
    /**
     * Get Adresse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdresse()
    {
        return isset($this->Adresse) ? $this->Adresse : null;
    }
    /**
     * Set Adresse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adresse
     * @return \StructType\Verv
     */
    public function setAdresse($adresse = null)
    {
        // validation for constraint: string
        if (!is_null($adresse) && !is_string($adresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adresse)), __LINE__);
        }
        if (is_null($adresse) || (is_array($adresse) && empty($adresse))) {
            unset($this->Adresse);
        } else {
            $this->Adresse = $adresse;
        }
        return $this;
    }
    /**
     * Get Postnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPostnr()
    {
        return isset($this->Postnr) ? $this->Postnr : null;
    }
    /**
     * Set Postnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $postnr
     * @return \StructType\Verv
     */
    public function setPostnr($postnr = 0)
    {
        // validation for constraint: int
        if (!is_null($postnr) && !is_numeric($postnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($postnr)), __LINE__);
        }
        if (is_null($postnr) || (is_array($postnr) && empty($postnr))) {
            unset($this->Postnr);
        } else {
            $this->Postnr = $postnr;
        }
        return $this;
    }
    /**
     * Get Poststed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPoststed()
    {
        return isset($this->Poststed) ? $this->Poststed : null;
    }
    /**
     * Set Poststed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $poststed
     * @return \StructType\Verv
     */
    public function setPoststed($poststed = null)
    {
        // validation for constraint: string
        if (!is_null($poststed) && !is_string($poststed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($poststed)), __LINE__);
        }
        if (is_null($poststed) || (is_array($poststed) && empty($poststed))) {
            unset($this->Poststed);
        } else {
            $this->Poststed = $poststed;
        }
        return $this;
    }
    /**
     * Get VervKode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVervKode()
    {
        return isset($this->VervKode) ? $this->VervKode : null;
    }
    /**
     * Set VervKode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vervKode
     * @return \StructType\Verv
     */
    public function setVervKode($vervKode = null)
    {
        // validation for constraint: string
        if (!is_null($vervKode) && !is_string($vervKode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vervKode)), __LINE__);
        }
        if (is_null($vervKode) || (is_array($vervKode) && empty($vervKode))) {
            unset($this->VervKode);
        } else {
            $this->VervKode = $vervKode;
        }
        return $this;
    }
    /**
     * Get VervTekst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVervTekst()
    {
        return isset($this->VervTekst) ? $this->VervTekst : null;
    }
    /**
     * Set VervTekst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vervTekst
     * @return \StructType\Verv
     */
    public function setVervTekst($vervTekst = null)
    {
        // validation for constraint: string
        if (!is_null($vervTekst) && !is_string($vervTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vervTekst)), __LINE__);
        }
        if (is_null($vervTekst) || (is_array($vervTekst) && empty($vervTekst))) {
            unset($this->VervTekst);
        } else {
            $this->VervTekst = $vervTekst;
        }
        return $this;
    }
    /**
     * Get Landkode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLandkode()
    {
        return isset($this->Landkode) ? $this->Landkode : null;
    }
    /**
     * Set Landkode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $landkode
     * @return \StructType\Verv
     */
    public function setLandkode($landkode = null)
    {
        // validation for constraint: string
        if (!is_null($landkode) && !is_string($landkode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($landkode)), __LINE__);
        }
        if (is_null($landkode) || (is_array($landkode) && empty($landkode))) {
            unset($this->Landkode);
        } else {
            $this->Landkode = $landkode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Verv
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
