<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Revisoranmerkning StructType
 * @subpackage Structs
 */
class Revisoranmerkning extends AbstractStructBase
{
    /**
     * The RegnskapsAvAr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RegnskapsAvAr;
    /**
     * The RegnskapsAvMnd
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RegnskapsAvMnd;
    /**
     * The AnmerkningsKode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AnmerkningsKode;
    /**
     * The AnmerkningsTekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AnmerkningsTekst;
    /**
     * Constructor method for Revisoranmerkning
     * @uses Revisoranmerkning::setRegnskapsAvAr()
     * @uses Revisoranmerkning::setRegnskapsAvMnd()
     * @uses Revisoranmerkning::setAnmerkningsKode()
     * @uses Revisoranmerkning::setAnmerkningsTekst()
     * @param int $regnskapsAvAr
     * @param int $regnskapsAvMnd
     * @param string $anmerkningsKode
     * @param string $anmerkningsTekst
     */
    public function __construct($regnskapsAvAr = 0, $regnskapsAvMnd = 0, $anmerkningsKode = null, $anmerkningsTekst = null)
    {
        $this
            ->setRegnskapsAvAr($regnskapsAvAr)
            ->setRegnskapsAvMnd($regnskapsAvMnd)
            ->setAnmerkningsKode($anmerkningsKode)
            ->setAnmerkningsTekst($anmerkningsTekst);
    }
    /**
     * Get RegnskapsAvAr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRegnskapsAvAr()
    {
        return isset($this->RegnskapsAvAr) ? $this->RegnskapsAvAr : null;
    }
    /**
     * Set RegnskapsAvAr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $regnskapsAvAr
     * @return \StructType\Revisoranmerkning
     */
    public function setRegnskapsAvAr($regnskapsAvAr = 0)
    {
        // validation for constraint: int
        if (!is_null($regnskapsAvAr) && !is_numeric($regnskapsAvAr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($regnskapsAvAr)), __LINE__);
        }
        if (is_null($regnskapsAvAr) || (is_array($regnskapsAvAr) && empty($regnskapsAvAr))) {
            unset($this->RegnskapsAvAr);
        } else {
            $this->RegnskapsAvAr = $regnskapsAvAr;
        }
        return $this;
    }
    /**
     * Get RegnskapsAvMnd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRegnskapsAvMnd()
    {
        return isset($this->RegnskapsAvMnd) ? $this->RegnskapsAvMnd : null;
    }
    /**
     * Set RegnskapsAvMnd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $regnskapsAvMnd
     * @return \StructType\Revisoranmerkning
     */
    public function setRegnskapsAvMnd($regnskapsAvMnd = 0)
    {
        // validation for constraint: int
        if (!is_null($regnskapsAvMnd) && !is_numeric($regnskapsAvMnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($regnskapsAvMnd)), __LINE__);
        }
        if (is_null($regnskapsAvMnd) || (is_array($regnskapsAvMnd) && empty($regnskapsAvMnd))) {
            unset($this->RegnskapsAvMnd);
        } else {
            $this->RegnskapsAvMnd = $regnskapsAvMnd;
        }
        return $this;
    }
    /**
     * Get AnmerkningsKode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnmerkningsKode()
    {
        return isset($this->AnmerkningsKode) ? $this->AnmerkningsKode : null;
    }
    /**
     * Set AnmerkningsKode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $anmerkningsKode
     * @return \StructType\Revisoranmerkning
     */
    public function setAnmerkningsKode($anmerkningsKode = null)
    {
        // validation for constraint: string
        if (!is_null($anmerkningsKode) && !is_string($anmerkningsKode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($anmerkningsKode)), __LINE__);
        }
        if (is_null($anmerkningsKode) || (is_array($anmerkningsKode) && empty($anmerkningsKode))) {
            unset($this->AnmerkningsKode);
        } else {
            $this->AnmerkningsKode = $anmerkningsKode;
        }
        return $this;
    }
    /**
     * Get AnmerkningsTekst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnmerkningsTekst()
    {
        return isset($this->AnmerkningsTekst) ? $this->AnmerkningsTekst : null;
    }
    /**
     * Set AnmerkningsTekst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $anmerkningsTekst
     * @return \StructType\Revisoranmerkning
     */
    public function setAnmerkningsTekst($anmerkningsTekst = null)
    {
        // validation for constraint: string
        if (!is_null($anmerkningsTekst) && !is_string($anmerkningsTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($anmerkningsTekst)), __LINE__);
        }
        if (is_null($anmerkningsTekst) || (is_array($anmerkningsTekst) && empty($anmerkningsTekst))) {
            unset($this->AnmerkningsTekst);
        } else {
            $this->AnmerkningsTekst = $anmerkningsTekst;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Revisoranmerkning
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
