<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Regnskapsar StructType
 * @subpackage Structs
 */
class Regnskapsar extends AbstractStructBase
{
    /**
     * The Ar
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var int[]
     */
    public $Ar;
    /**
     * Constructor method for Regnskapsar
     * @uses Regnskapsar::setAr()
     * @param int[] $ar
     */
    public function __construct(array $ar = array())
    {
        $this
            ->setAr($ar);
    }
    /**
     * Get Ar value
     * @return int[]
     */
    public function getAr()
    {
        return $this->Ar;
    }
    /**
     * Set Ar value
     * @throws \InvalidArgumentException
     * @param int[] $ar
     * @return \StructType\Regnskapsar
     */
    public function setAr(array $ar = array())
    {
        foreach ($ar as $regnskapsarArItem) {
            // validation for constraint: itemType
            if (!is_numeric($regnskapsarArItem)) {
                throw new \InvalidArgumentException(sprintf('The Ar property can only contain items of int, "%s" given', is_object($regnskapsarArItem) ? get_class($regnskapsarArItem) : gettype($regnskapsarArItem)), __LINE__);
            }
        }
        $this->Ar = $ar;
        return $this;
    }
    /**
     * Add item to Ar value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Regnskapsar
     */
    public function addToAr($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The Ar property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Ar[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Regnskapsar
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
