<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OvervakningEndringer StructType
 * @subpackage Structs
 */
class OvervakningEndringer extends AbstractStructBase
{
    /**
     * The Orgnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Orgnr;
    /**
     * The Kunderef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kunderef;
    /**
     * The Avdnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Avdnr;
    /**
     * The Endringskode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Endringskode;
    /**
     * The Endringstekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Endringstekst;
    /**
     * The Tilleggsinfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Tilleggsinfo[]
     */
    public $Tilleggsinfo;
    /**
     * Constructor method for OvervakningEndringer
     * @uses OvervakningEndringer::setOrgnr()
     * @uses OvervakningEndringer::setKunderef()
     * @uses OvervakningEndringer::setAvdnr()
     * @uses OvervakningEndringer::setEndringskode()
     * @uses OvervakningEndringer::setEndringstekst()
     * @uses OvervakningEndringer::setTilleggsinfo()
     * @param int $orgnr
     * @param string $kunderef
     * @param string $avdnr
     * @param string $endringskode
     * @param string $endringstekst
     * @param \StructType\Tilleggsinfo[] $tilleggsinfo
     */
    public function __construct($orgnr = 0, $kunderef = null, $avdnr = '0', $endringskode = null, $endringstekst = null, array $tilleggsinfo = array())
    {
        $this
            ->setOrgnr($orgnr)
            ->setKunderef($kunderef)
            ->setAvdnr($avdnr)
            ->setEndringskode($endringskode)
            ->setEndringstekst($endringstekst)
            ->setTilleggsinfo($tilleggsinfo);
    }
    /**
     * Get Orgnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrgnr()
    {
        return isset($this->Orgnr) ? $this->Orgnr : null;
    }
    /**
     * Set Orgnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $orgnr
     * @return \StructType\OvervakningEndringer
     */
    public function setOrgnr($orgnr = 0)
    {
        // validation for constraint: int
        if (!is_null($orgnr) && !is_numeric($orgnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgnr)), __LINE__);
        }
        if (is_null($orgnr) || (is_array($orgnr) && empty($orgnr))) {
            unset($this->Orgnr);
        } else {
            $this->Orgnr = $orgnr;
        }
        return $this;
    }
    /**
     * Get Kunderef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKunderef()
    {
        return isset($this->Kunderef) ? $this->Kunderef : null;
    }
    /**
     * Set Kunderef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kunderef
     * @return \StructType\OvervakningEndringer
     */
    public function setKunderef($kunderef = null)
    {
        // validation for constraint: string
        if (!is_null($kunderef) && !is_string($kunderef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kunderef)), __LINE__);
        }
        if (is_null($kunderef) || (is_array($kunderef) && empty($kunderef))) {
            unset($this->Kunderef);
        } else {
            $this->Kunderef = $kunderef;
        }
        return $this;
    }
    /**
     * Get Avdnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvdnr()
    {
        return isset($this->Avdnr) ? $this->Avdnr : null;
    }
    /**
     * Set Avdnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $avdnr
     * @return \StructType\OvervakningEndringer
     */
    public function setAvdnr($avdnr = '0')
    {
        // validation for constraint: string
        if (!is_null($avdnr) && !is_string($avdnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($avdnr)), __LINE__);
        }
        if (is_null($avdnr) || (is_array($avdnr) && empty($avdnr))) {
            unset($this->Avdnr);
        } else {
            $this->Avdnr = $avdnr;
        }
        return $this;
    }
    /**
     * Get Endringskode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndringskode()
    {
        return isset($this->Endringskode) ? $this->Endringskode : null;
    }
    /**
     * Set Endringskode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endringskode
     * @return \StructType\OvervakningEndringer
     */
    public function setEndringskode($endringskode = null)
    {
        // validation for constraint: string
        if (!is_null($endringskode) && !is_string($endringskode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endringskode)), __LINE__);
        }
        if (is_null($endringskode) || (is_array($endringskode) && empty($endringskode))) {
            unset($this->Endringskode);
        } else {
            $this->Endringskode = $endringskode;
        }
        return $this;
    }
    /**
     * Get Endringstekst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndringstekst()
    {
        return isset($this->Endringstekst) ? $this->Endringstekst : null;
    }
    /**
     * Set Endringstekst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endringstekst
     * @return \StructType\OvervakningEndringer
     */
    public function setEndringstekst($endringstekst = null)
    {
        // validation for constraint: string
        if (!is_null($endringstekst) && !is_string($endringstekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endringstekst)), __LINE__);
        }
        if (is_null($endringstekst) || (is_array($endringstekst) && empty($endringstekst))) {
            unset($this->Endringstekst);
        } else {
            $this->Endringstekst = $endringstekst;
        }
        return $this;
    }
    /**
     * Get Tilleggsinfo value
     * @return \StructType\Tilleggsinfo[]|null
     */
    public function getTilleggsinfo()
    {
        return $this->Tilleggsinfo;
    }
    /**
     * Set Tilleggsinfo value
     * @throws \InvalidArgumentException
     * @param \StructType\Tilleggsinfo[] $tilleggsinfo
     * @return \StructType\OvervakningEndringer
     */
    public function setTilleggsinfo(array $tilleggsinfo = array())
    {
        foreach ($tilleggsinfo as $overvakningEndringerTilleggsinfoItem) {
            // validation for constraint: itemType
            if (!$overvakningEndringerTilleggsinfoItem instanceof \StructType\Tilleggsinfo) {
                throw new \InvalidArgumentException(sprintf('The Tilleggsinfo property can only contain items of \StructType\Tilleggsinfo, "%s" given', is_object($overvakningEndringerTilleggsinfoItem) ? get_class($overvakningEndringerTilleggsinfoItem) : gettype($overvakningEndringerTilleggsinfoItem)), __LINE__);
            }
        }
        $this->Tilleggsinfo = $tilleggsinfo;
        return $this;
    }
    /**
     * Add item to Tilleggsinfo value
     * @throws \InvalidArgumentException
     * @param \StructType\Tilleggsinfo $item
     * @return \StructType\OvervakningEndringer
     */
    public function addToTilleggsinfo(\StructType\Tilleggsinfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tilleggsinfo) {
            throw new \InvalidArgumentException(sprintf('The Tilleggsinfo property can only contain items of \StructType\Tilleggsinfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Tilleggsinfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OvervakningEndringer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
