<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OmspurtData StructType
 * @subpackage Structs
 */
class OmspurtData extends AbstractStructBase
{
    /**
     * The Navn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Navn;
    /**
     * The Adresse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adresse;
    /**
     * The Postnr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Postnr;
    /**
     * The Poststed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Poststed;
    /**
     * Constructor method for OmspurtData
     * @uses OmspurtData::setNavn()
     * @uses OmspurtData::setAdresse()
     * @uses OmspurtData::setPostnr()
     * @uses OmspurtData::setPoststed()
     * @param string $navn
     * @param string $adresse
     * @param string $postnr
     * @param string $poststed
     */
    public function __construct($navn = null, $adresse = null, $postnr = null, $poststed = null)
    {
        $this
            ->setNavn($navn)
            ->setAdresse($adresse)
            ->setPostnr($postnr)
            ->setPoststed($poststed);
    }
    /**
     * Get Navn value
     * @return string|null
     */
    public function getNavn()
    {
        return $this->Navn;
    }
    /**
     * Set Navn value
     * @param string $navn
     * @return \StructType\OmspurtData
     */
    public function setNavn($navn = null)
    {
        // validation for constraint: string
        if (!is_null($navn) && !is_string($navn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($navn)), __LINE__);
        }
        $this->Navn = $navn;
        return $this;
    }
    /**
     * Get Adresse value
     * @return string|null
     */
    public function getAdresse()
    {
        return $this->Adresse;
    }
    /**
     * Set Adresse value
     * @param string $adresse
     * @return \StructType\OmspurtData
     */
    public function setAdresse($adresse = null)
    {
        // validation for constraint: string
        if (!is_null($adresse) && !is_string($adresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adresse)), __LINE__);
        }
        $this->Adresse = $adresse;
        return $this;
    }
    /**
     * Get Postnr value
     * @return string|null
     */
    public function getPostnr()
    {
        return $this->Postnr;
    }
    /**
     * Set Postnr value
     * @param string $postnr
     * @return \StructType\OmspurtData
     */
    public function setPostnr($postnr = null)
    {
        // validation for constraint: string
        if (!is_null($postnr) && !is_string($postnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postnr)), __LINE__);
        }
        $this->Postnr = $postnr;
        return $this;
    }
    /**
     * Get Poststed value
     * @return string|null
     */
    public function getPoststed()
    {
        return $this->Poststed;
    }
    /**
     * Set Poststed value
     * @param string $poststed
     * @return \StructType\OmspurtData
     */
    public function setPoststed($poststed = null)
    {
        // validation for constraint: string
        if (!is_null($poststed) && !is_string($poststed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($poststed)), __LINE__);
        }
        $this->Poststed = $poststed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OmspurtData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
