<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NavnAdresse StructType
 * @subpackage Structs
 */
class NavnAdresse extends AbstractStructBase
{
    /**
     * The KodeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KodeType;
    /**
     * The KodeTekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KodeTekst;
    /**
     * The Navn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Navn;
    /**
     * The Markedsnavn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Markedsnavn;
    /**
     * The HistoriskNavnData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HistoriskNavnData[]
     */
    public $HistoriskNavnData;
    /**
     * The GateAdresse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GateAdresse;
    /**
     * The GatePostboks
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GatePostboks;
    /**
     * The GatePostnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GatePostnr;
    /**
     * The GatePoststed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GatePoststed;
    /**
     * The PostAdresse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostAdresse;
    /**
     * The PostPostboks
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PostPostboks;
    /**
     * The PostPosthus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostPosthus;
    /**
     * The PostPostnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PostPostnr;
    /**
     * The PostPoststed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostPoststed;
    /**
     * The JurAdresse
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JurAdresse;
    /**
     * The JurPostnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $JurPostnr;
    /**
     * The JurPoststed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JurPoststed;
    /**
     * The Telefon
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Telefon;
    /**
     * The Telefax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Telefax;
    /**
     * The Webadresse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Webadresse;
    /**
     * The Epost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Epost;
    /**
     * Constructor method for NavnAdresse
     * @uses NavnAdresse::setKodeType()
     * @uses NavnAdresse::setKodeTekst()
     * @uses NavnAdresse::setNavn()
     * @uses NavnAdresse::setMarkedsnavn()
     * @uses NavnAdresse::setHistoriskNavnData()
     * @uses NavnAdresse::setGateAdresse()
     * @uses NavnAdresse::setGatePostboks()
     * @uses NavnAdresse::setGatePostnr()
     * @uses NavnAdresse::setGatePoststed()
     * @uses NavnAdresse::setPostAdresse()
     * @uses NavnAdresse::setPostPostboks()
     * @uses NavnAdresse::setPostPosthus()
     * @uses NavnAdresse::setPostPostnr()
     * @uses NavnAdresse::setPostPoststed()
     * @uses NavnAdresse::setJurAdresse()
     * @uses NavnAdresse::setJurPostnr()
     * @uses NavnAdresse::setJurPoststed()
     * @uses NavnAdresse::setTelefon()
     * @uses NavnAdresse::setTelefax()
     * @uses NavnAdresse::setWebadresse()
     * @uses NavnAdresse::setEpost()
     * @param string $kodeType
     * @param string $kodeTekst
     * @param string $navn
     * @param string $markedsnavn
     * @param \StructType\HistoriskNavnData[] $historiskNavnData
     * @param string $gateAdresse
     * @param int $gatePostboks
     * @param int $gatePostnr
     * @param string $gatePoststed
     * @param string $postAdresse
     * @param int $postPostboks
     * @param string $postPosthus
     * @param int $postPostnr
     * @param string $postPoststed
     * @param string $jurAdresse
     * @param int $jurPostnr
     * @param string $jurPoststed
     * @param string $telefon
     * @param string $telefax
     * @param string $webadresse
     * @param string $epost
     */
    public function __construct($kodeType = null, $kodeTekst = null, $navn = null, $markedsnavn = null, array $historiskNavnData = array(), $gateAdresse = null, $gatePostboks = 0, $gatePostnr = 0, $gatePoststed = null, $postAdresse = null, $postPostboks = 0, $postPosthus = null, $postPostnr = 0, $postPoststed = null, $jurAdresse = '0', $jurPostnr = 0, $jurPoststed = null, $telefon = null, $telefax = null, $webadresse = null, $epost = null)
    {
        $this
            ->setKodeType($kodeType)
            ->setKodeTekst($kodeTekst)
            ->setNavn($navn)
            ->setMarkedsnavn($markedsnavn)
            ->setHistoriskNavnData($historiskNavnData)
            ->setGateAdresse($gateAdresse)
            ->setGatePostboks($gatePostboks)
            ->setGatePostnr($gatePostnr)
            ->setGatePoststed($gatePoststed)
            ->setPostAdresse($postAdresse)
            ->setPostPostboks($postPostboks)
            ->setPostPosthus($postPosthus)
            ->setPostPostnr($postPostnr)
            ->setPostPoststed($postPoststed)
            ->setJurAdresse($jurAdresse)
            ->setJurPostnr($jurPostnr)
            ->setJurPoststed($jurPoststed)
            ->setTelefon($telefon)
            ->setTelefax($telefax)
            ->setWebadresse($webadresse)
            ->setEpost($epost);
    }
    /**
     * Get KodeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKodeType()
    {
        return isset($this->KodeType) ? $this->KodeType : null;
    }
    /**
     * Set KodeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kodeType
     * @return \StructType\NavnAdresse
     */
    public function setKodeType($kodeType = null)
    {
        // validation for constraint: string
        if (!is_null($kodeType) && !is_string($kodeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kodeType)), __LINE__);
        }
        if (is_null($kodeType) || (is_array($kodeType) && empty($kodeType))) {
            unset($this->KodeType);
        } else {
            $this->KodeType = $kodeType;
        }
        return $this;
    }
    /**
     * Get KodeTekst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKodeTekst()
    {
        return isset($this->KodeTekst) ? $this->KodeTekst : null;
    }
    /**
     * Set KodeTekst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kodeTekst
     * @return \StructType\NavnAdresse
     */
    public function setKodeTekst($kodeTekst = null)
    {
        // validation for constraint: string
        if (!is_null($kodeTekst) && !is_string($kodeTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kodeTekst)), __LINE__);
        }
        if (is_null($kodeTekst) || (is_array($kodeTekst) && empty($kodeTekst))) {
            unset($this->KodeTekst);
        } else {
            $this->KodeTekst = $kodeTekst;
        }
        return $this;
    }
    /**
     * Get Navn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNavn()
    {
        return isset($this->Navn) ? $this->Navn : null;
    }
    /**
     * Set Navn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $navn
     * @return \StructType\NavnAdresse
     */
    public function setNavn($navn = null)
    {
        // validation for constraint: string
        if (!is_null($navn) && !is_string($navn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($navn)), __LINE__);
        }
        if (is_null($navn) || (is_array($navn) && empty($navn))) {
            unset($this->Navn);
        } else {
            $this->Navn = $navn;
        }
        return $this;
    }
    /**
     * Get Markedsnavn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarkedsnavn()
    {
        return isset($this->Markedsnavn) ? $this->Markedsnavn : null;
    }
    /**
     * Set Markedsnavn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $markedsnavn
     * @return \StructType\NavnAdresse
     */
    public function setMarkedsnavn($markedsnavn = null)
    {
        // validation for constraint: string
        if (!is_null($markedsnavn) && !is_string($markedsnavn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($markedsnavn)), __LINE__);
        }
        if (is_null($markedsnavn) || (is_array($markedsnavn) && empty($markedsnavn))) {
            unset($this->Markedsnavn);
        } else {
            $this->Markedsnavn = $markedsnavn;
        }
        return $this;
    }
    /**
     * Get HistoriskNavnData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HistoriskNavnData[]|null
     */
    public function getHistoriskNavnData()
    {
        return isset($this->HistoriskNavnData) ? $this->HistoriskNavnData : null;
    }
    /**
     * Set HistoriskNavnData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\HistoriskNavnData[] $historiskNavnData
     * @return \StructType\NavnAdresse
     */
    public function setHistoriskNavnData(array $historiskNavnData = array())
    {
        foreach ($historiskNavnData as $navnAdresseHistoriskNavnDataItem) {
            // validation for constraint: itemType
            if (!$navnAdresseHistoriskNavnDataItem instanceof \StructType\HistoriskNavnData) {
                throw new \InvalidArgumentException(sprintf('The HistoriskNavnData property can only contain items of \StructType\HistoriskNavnData, "%s" given', is_object($navnAdresseHistoriskNavnDataItem) ? get_class($navnAdresseHistoriskNavnDataItem) : gettype($navnAdresseHistoriskNavnDataItem)), __LINE__);
            }
        }
        if (is_null($historiskNavnData) || (is_array($historiskNavnData) && empty($historiskNavnData))) {
            unset($this->HistoriskNavnData);
        } else {
            $this->HistoriskNavnData = $historiskNavnData;
        }
        return $this;
    }
    /**
     * Add item to HistoriskNavnData value
     * @throws \InvalidArgumentException
     * @param \StructType\HistoriskNavnData $item
     * @return \StructType\NavnAdresse
     */
    public function addToHistoriskNavnData(\StructType\HistoriskNavnData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HistoriskNavnData) {
            throw new \InvalidArgumentException(sprintf('The HistoriskNavnData property can only contain items of \StructType\HistoriskNavnData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->HistoriskNavnData[] = $item;
        return $this;
    }
    /**
     * Get GateAdresse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGateAdresse()
    {
        return isset($this->GateAdresse) ? $this->GateAdresse : null;
    }
    /**
     * Set GateAdresse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gateAdresse
     * @return \StructType\NavnAdresse
     */
    public function setGateAdresse($gateAdresse = null)
    {
        // validation for constraint: string
        if (!is_null($gateAdresse) && !is_string($gateAdresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gateAdresse)), __LINE__);
        }
        if (is_null($gateAdresse) || (is_array($gateAdresse) && empty($gateAdresse))) {
            unset($this->GateAdresse);
        } else {
            $this->GateAdresse = $gateAdresse;
        }
        return $this;
    }
    /**
     * Get GatePostboks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGatePostboks()
    {
        return isset($this->GatePostboks) ? $this->GatePostboks : null;
    }
    /**
     * Set GatePostboks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $gatePostboks
     * @return \StructType\NavnAdresse
     */
    public function setGatePostboks($gatePostboks = 0)
    {
        // validation for constraint: int
        if (!is_null($gatePostboks) && !is_numeric($gatePostboks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($gatePostboks)), __LINE__);
        }
        if (is_null($gatePostboks) || (is_array($gatePostboks) && empty($gatePostboks))) {
            unset($this->GatePostboks);
        } else {
            $this->GatePostboks = $gatePostboks;
        }
        return $this;
    }
    /**
     * Get GatePostnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGatePostnr()
    {
        return isset($this->GatePostnr) ? $this->GatePostnr : null;
    }
    /**
     * Set GatePostnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $gatePostnr
     * @return \StructType\NavnAdresse
     */
    public function setGatePostnr($gatePostnr = 0)
    {
        // validation for constraint: int
        if (!is_null($gatePostnr) && !is_numeric($gatePostnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($gatePostnr)), __LINE__);
        }
        if (is_null($gatePostnr) || (is_array($gatePostnr) && empty($gatePostnr))) {
            unset($this->GatePostnr);
        } else {
            $this->GatePostnr = $gatePostnr;
        }
        return $this;
    }
    /**
     * Get GatePoststed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGatePoststed()
    {
        return isset($this->GatePoststed) ? $this->GatePoststed : null;
    }
    /**
     * Set GatePoststed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gatePoststed
     * @return \StructType\NavnAdresse
     */
    public function setGatePoststed($gatePoststed = null)
    {
        // validation for constraint: string
        if (!is_null($gatePoststed) && !is_string($gatePoststed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gatePoststed)), __LINE__);
        }
        if (is_null($gatePoststed) || (is_array($gatePoststed) && empty($gatePoststed))) {
            unset($this->GatePoststed);
        } else {
            $this->GatePoststed = $gatePoststed;
        }
        return $this;
    }
    /**
     * Get PostAdresse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostAdresse()
    {
        return isset($this->PostAdresse) ? $this->PostAdresse : null;
    }
    /**
     * Set PostAdresse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postAdresse
     * @return \StructType\NavnAdresse
     */
    public function setPostAdresse($postAdresse = null)
    {
        // validation for constraint: string
        if (!is_null($postAdresse) && !is_string($postAdresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postAdresse)), __LINE__);
        }
        if (is_null($postAdresse) || (is_array($postAdresse) && empty($postAdresse))) {
            unset($this->PostAdresse);
        } else {
            $this->PostAdresse = $postAdresse;
        }
        return $this;
    }
    /**
     * Get PostPostboks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPostPostboks()
    {
        return isset($this->PostPostboks) ? $this->PostPostboks : null;
    }
    /**
     * Set PostPostboks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $postPostboks
     * @return \StructType\NavnAdresse
     */
    public function setPostPostboks($postPostboks = 0)
    {
        // validation for constraint: int
        if (!is_null($postPostboks) && !is_numeric($postPostboks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($postPostboks)), __LINE__);
        }
        if (is_null($postPostboks) || (is_array($postPostboks) && empty($postPostboks))) {
            unset($this->PostPostboks);
        } else {
            $this->PostPostboks = $postPostboks;
        }
        return $this;
    }
    /**
     * Get PostPosthus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostPosthus()
    {
        return isset($this->PostPosthus) ? $this->PostPosthus : null;
    }
    /**
     * Set PostPosthus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postPosthus
     * @return \StructType\NavnAdresse
     */
    public function setPostPosthus($postPosthus = null)
    {
        // validation for constraint: string
        if (!is_null($postPosthus) && !is_string($postPosthus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postPosthus)), __LINE__);
        }
        if (is_null($postPosthus) || (is_array($postPosthus) && empty($postPosthus))) {
            unset($this->PostPosthus);
        } else {
            $this->PostPosthus = $postPosthus;
        }
        return $this;
    }
    /**
     * Get PostPostnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPostPostnr()
    {
        return isset($this->PostPostnr) ? $this->PostPostnr : null;
    }
    /**
     * Set PostPostnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $postPostnr
     * @return \StructType\NavnAdresse
     */
    public function setPostPostnr($postPostnr = 0)
    {
        // validation for constraint: int
        if (!is_null($postPostnr) && !is_numeric($postPostnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($postPostnr)), __LINE__);
        }
        if (is_null($postPostnr) || (is_array($postPostnr) && empty($postPostnr))) {
            unset($this->PostPostnr);
        } else {
            $this->PostPostnr = $postPostnr;
        }
        return $this;
    }
    /**
     * Get PostPoststed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostPoststed()
    {
        return isset($this->PostPoststed) ? $this->PostPoststed : null;
    }
    /**
     * Set PostPoststed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postPoststed
     * @return \StructType\NavnAdresse
     */
    public function setPostPoststed($postPoststed = null)
    {
        // validation for constraint: string
        if (!is_null($postPoststed) && !is_string($postPoststed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postPoststed)), __LINE__);
        }
        if (is_null($postPoststed) || (is_array($postPoststed) && empty($postPoststed))) {
            unset($this->PostPoststed);
        } else {
            $this->PostPoststed = $postPoststed;
        }
        return $this;
    }
    /**
     * Get JurAdresse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJurAdresse()
    {
        return isset($this->JurAdresse) ? $this->JurAdresse : null;
    }
    /**
     * Set JurAdresse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jurAdresse
     * @return \StructType\NavnAdresse
     */
    public function setJurAdresse($jurAdresse = '0')
    {
        // validation for constraint: string
        if (!is_null($jurAdresse) && !is_string($jurAdresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jurAdresse)), __LINE__);
        }
        if (is_null($jurAdresse) || (is_array($jurAdresse) && empty($jurAdresse))) {
            unset($this->JurAdresse);
        } else {
            $this->JurAdresse = $jurAdresse;
        }
        return $this;
    }
    /**
     * Get JurPostnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getJurPostnr()
    {
        return isset($this->JurPostnr) ? $this->JurPostnr : null;
    }
    /**
     * Set JurPostnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $jurPostnr
     * @return \StructType\NavnAdresse
     */
    public function setJurPostnr($jurPostnr = 0)
    {
        // validation for constraint: int
        if (!is_null($jurPostnr) && !is_numeric($jurPostnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($jurPostnr)), __LINE__);
        }
        if (is_null($jurPostnr) || (is_array($jurPostnr) && empty($jurPostnr))) {
            unset($this->JurPostnr);
        } else {
            $this->JurPostnr = $jurPostnr;
        }
        return $this;
    }
    /**
     * Get JurPoststed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJurPoststed()
    {
        return isset($this->JurPoststed) ? $this->JurPoststed : null;
    }
    /**
     * Set JurPoststed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jurPoststed
     * @return \StructType\NavnAdresse
     */
    public function setJurPoststed($jurPoststed = null)
    {
        // validation for constraint: string
        if (!is_null($jurPoststed) && !is_string($jurPoststed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jurPoststed)), __LINE__);
        }
        if (is_null($jurPoststed) || (is_array($jurPoststed) && empty($jurPoststed))) {
            unset($this->JurPoststed);
        } else {
            $this->JurPoststed = $jurPoststed;
        }
        return $this;
    }
    /**
     * Get Telefon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefon()
    {
        return isset($this->Telefon) ? $this->Telefon : null;
    }
    /**
     * Set Telefon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefon
     * @return \StructType\NavnAdresse
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: string
        if (!is_null($telefon) && !is_string($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telefon)), __LINE__);
        }
        if (is_null($telefon) || (is_array($telefon) && empty($telefon))) {
            unset($this->Telefon);
        } else {
            $this->Telefon = $telefon;
        }
        return $this;
    }
    /**
     * Get Telefax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefax()
    {
        return isset($this->Telefax) ? $this->Telefax : null;
    }
    /**
     * Set Telefax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefax
     * @return \StructType\NavnAdresse
     */
    public function setTelefax($telefax = null)
    {
        // validation for constraint: string
        if (!is_null($telefax) && !is_string($telefax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telefax)), __LINE__);
        }
        if (is_null($telefax) || (is_array($telefax) && empty($telefax))) {
            unset($this->Telefax);
        } else {
            $this->Telefax = $telefax;
        }
        return $this;
    }
    /**
     * Get Webadresse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebadresse()
    {
        return isset($this->Webadresse) ? $this->Webadresse : null;
    }
    /**
     * Set Webadresse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $webadresse
     * @return \StructType\NavnAdresse
     */
    public function setWebadresse($webadresse = null)
    {
        // validation for constraint: string
        if (!is_null($webadresse) && !is_string($webadresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($webadresse)), __LINE__);
        }
        if (is_null($webadresse) || (is_array($webadresse) && empty($webadresse))) {
            unset($this->Webadresse);
        } else {
            $this->Webadresse = $webadresse;
        }
        return $this;
    }
    /**
     * Get Epost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEpost()
    {
        return isset($this->Epost) ? $this->Epost : null;
    }
    /**
     * Set Epost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $epost
     * @return \StructType\NavnAdresse
     */
    public function setEpost($epost = null)
    {
        // validation for constraint: string
        if (!is_null($epost) && !is_string($epost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($epost)), __LINE__);
        }
        if (is_null($epost) || (is_array($epost) && empty($epost))) {
            unset($this->Epost);
        } else {
            $this->Epost = $epost;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NavnAdresse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
