<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Juridisk StructType
 * @subpackage Structs
 */
class Juridisk extends AbstractStructBase
{
    /**
     * The ProkuraKode
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProkuraKode;
    /**
     * The ProkuraTekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProkuraTekst;
    /**
     * The SignaturKode
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SignaturKode;
    /**
     * The SignaturTekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SignaturTekst;
    /**
     * The EierStrukturKode
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EierStrukturKode;
    /**
     * The EierStrukturTekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EierStrukturTekst;
    /**
     * Constructor method for Juridisk
     * @uses Juridisk::setProkuraKode()
     * @uses Juridisk::setProkuraTekst()
     * @uses Juridisk::setSignaturKode()
     * @uses Juridisk::setSignaturTekst()
     * @uses Juridisk::setEierStrukturKode()
     * @uses Juridisk::setEierStrukturTekst()
     * @param int $prokuraKode
     * @param string $prokuraTekst
     * @param int $signaturKode
     * @param string $signaturTekst
     * @param int $eierStrukturKode
     * @param string $eierStrukturTekst
     */
    public function __construct($prokuraKode = 0, $prokuraTekst = null, $signaturKode = 0, $signaturTekst = null, $eierStrukturKode = 0, $eierStrukturTekst = null)
    {
        $this
            ->setProkuraKode($prokuraKode)
            ->setProkuraTekst($prokuraTekst)
            ->setSignaturKode($signaturKode)
            ->setSignaturTekst($signaturTekst)
            ->setEierStrukturKode($eierStrukturKode)
            ->setEierStrukturTekst($eierStrukturTekst);
    }
    /**
     * Get ProkuraKode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProkuraKode()
    {
        return isset($this->ProkuraKode) ? $this->ProkuraKode : null;
    }
    /**
     * Set ProkuraKode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $prokuraKode
     * @return \StructType\Juridisk
     */
    public function setProkuraKode($prokuraKode = 0)
    {
        // validation for constraint: int
        if (!is_null($prokuraKode) && !is_numeric($prokuraKode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($prokuraKode)), __LINE__);
        }
        if (is_null($prokuraKode) || (is_array($prokuraKode) && empty($prokuraKode))) {
            unset($this->ProkuraKode);
        } else {
            $this->ProkuraKode = $prokuraKode;
        }
        return $this;
    }
    /**
     * Get ProkuraTekst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProkuraTekst()
    {
        return isset($this->ProkuraTekst) ? $this->ProkuraTekst : null;
    }
    /**
     * Set ProkuraTekst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prokuraTekst
     * @return \StructType\Juridisk
     */
    public function setProkuraTekst($prokuraTekst = null)
    {
        // validation for constraint: string
        if (!is_null($prokuraTekst) && !is_string($prokuraTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prokuraTekst)), __LINE__);
        }
        if (is_null($prokuraTekst) || (is_array($prokuraTekst) && empty($prokuraTekst))) {
            unset($this->ProkuraTekst);
        } else {
            $this->ProkuraTekst = $prokuraTekst;
        }
        return $this;
    }
    /**
     * Get SignaturKode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSignaturKode()
    {
        return isset($this->SignaturKode) ? $this->SignaturKode : null;
    }
    /**
     * Set SignaturKode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $signaturKode
     * @return \StructType\Juridisk
     */
    public function setSignaturKode($signaturKode = 0)
    {
        // validation for constraint: int
        if (!is_null($signaturKode) && !is_numeric($signaturKode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($signaturKode)), __LINE__);
        }
        if (is_null($signaturKode) || (is_array($signaturKode) && empty($signaturKode))) {
            unset($this->SignaturKode);
        } else {
            $this->SignaturKode = $signaturKode;
        }
        return $this;
    }
    /**
     * Get SignaturTekst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSignaturTekst()
    {
        return isset($this->SignaturTekst) ? $this->SignaturTekst : null;
    }
    /**
     * Set SignaturTekst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $signaturTekst
     * @return \StructType\Juridisk
     */
    public function setSignaturTekst($signaturTekst = null)
    {
        // validation for constraint: string
        if (!is_null($signaturTekst) && !is_string($signaturTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signaturTekst)), __LINE__);
        }
        if (is_null($signaturTekst) || (is_array($signaturTekst) && empty($signaturTekst))) {
            unset($this->SignaturTekst);
        } else {
            $this->SignaturTekst = $signaturTekst;
        }
        return $this;
    }
    /**
     * Get EierStrukturKode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEierStrukturKode()
    {
        return isset($this->EierStrukturKode) ? $this->EierStrukturKode : null;
    }
    /**
     * Set EierStrukturKode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eierStrukturKode
     * @return \StructType\Juridisk
     */
    public function setEierStrukturKode($eierStrukturKode = 0)
    {
        // validation for constraint: int
        if (!is_null($eierStrukturKode) && !is_numeric($eierStrukturKode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($eierStrukturKode)), __LINE__);
        }
        if (is_null($eierStrukturKode) || (is_array($eierStrukturKode) && empty($eierStrukturKode))) {
            unset($this->EierStrukturKode);
        } else {
            $this->EierStrukturKode = $eierStrukturKode;
        }
        return $this;
    }
    /**
     * Get EierStrukturTekst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEierStrukturTekst()
    {
        return isset($this->EierStrukturTekst) ? $this->EierStrukturTekst : null;
    }
    /**
     * Set EierStrukturTekst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eierStrukturTekst
     * @return \StructType\Juridisk
     */
    public function setEierStrukturTekst($eierStrukturTekst = null)
    {
        // validation for constraint: string
        if (!is_null($eierStrukturTekst) && !is_string($eierStrukturTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eierStrukturTekst)), __LINE__);
        }
        if (is_null($eierStrukturTekst) || (is_array($eierStrukturTekst) && empty($eierStrukturTekst))) {
            unset($this->EierStrukturTekst);
        } else {
            $this->EierStrukturTekst = $eierStrukturTekst;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Juridisk
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
