<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HistoriskNavnData StructType
 * @subpackage Structs
 */
class HistoriskNavnData extends AbstractStructBase
{
    /**
     * The NavnType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NavnType;
    /**
     * The Navn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Navn;
    /**
     * The AktivFra
     * Meta informations extracted from the WSDL
     * - default: 0001-01-01
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AktivFra;
    /**
     * The AktivTil
     * Meta informations extracted from the WSDL
     * - default: 0001-01-01
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AktivTil;
    /**
     * Constructor method for HistoriskNavnData
     * @uses HistoriskNavnData::setNavnType()
     * @uses HistoriskNavnData::setNavn()
     * @uses HistoriskNavnData::setAktivFra()
     * @uses HistoriskNavnData::setAktivTil()
     * @param string $navnType
     * @param string $navn
     * @param string $aktivFra
     * @param string $aktivTil
     */
    public function __construct($navnType = null, $navn = null, $aktivFra = '0001-01-01', $aktivTil = '0001-01-01')
    {
        $this
            ->setNavnType($navnType)
            ->setNavn($navn)
            ->setAktivFra($aktivFra)
            ->setAktivTil($aktivTil);
    }
    /**
     * Get NavnType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNavnType()
    {
        return isset($this->NavnType) ? $this->NavnType : null;
    }
    /**
     * Set NavnType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $navnType
     * @return \StructType\HistoriskNavnData
     */
    public function setNavnType($navnType = null)
    {
        // validation for constraint: string
        if (!is_null($navnType) && !is_string($navnType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($navnType)), __LINE__);
        }
        if (is_null($navnType) || (is_array($navnType) && empty($navnType))) {
            unset($this->NavnType);
        } else {
            $this->NavnType = $navnType;
        }
        return $this;
    }
    /**
     * Get Navn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNavn()
    {
        return isset($this->Navn) ? $this->Navn : null;
    }
    /**
     * Set Navn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $navn
     * @return \StructType\HistoriskNavnData
     */
    public function setNavn($navn = null)
    {
        // validation for constraint: string
        if (!is_null($navn) && !is_string($navn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($navn)), __LINE__);
        }
        if (is_null($navn) || (is_array($navn) && empty($navn))) {
            unset($this->Navn);
        } else {
            $this->Navn = $navn;
        }
        return $this;
    }
    /**
     * Get AktivFra value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAktivFra()
    {
        return isset($this->AktivFra) ? $this->AktivFra : null;
    }
    /**
     * Set AktivFra value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aktivFra
     * @return \StructType\HistoriskNavnData
     */
    public function setAktivFra($aktivFra = '0001-01-01')
    {
        // validation for constraint: string
        if (!is_null($aktivFra) && !is_string($aktivFra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aktivFra)), __LINE__);
        }
        if (is_null($aktivFra) || (is_array($aktivFra) && empty($aktivFra))) {
            unset($this->AktivFra);
        } else {
            $this->AktivFra = $aktivFra;
        }
        return $this;
    }
    /**
     * Get AktivTil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAktivTil()
    {
        return isset($this->AktivTil) ? $this->AktivTil : null;
    }
    /**
     * Set AktivTil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aktivTil
     * @return \StructType\HistoriskNavnData
     */
    public function setAktivTil($aktivTil = '0001-01-01')
    {
        // validation for constraint: string
        if (!is_null($aktivTil) && !is_string($aktivTil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aktivTil)), __LINE__);
        }
        if (is_null($aktivTil) || (is_array($aktivTil) && empty($aktivTil))) {
            unset($this->AktivTil);
        } else {
            $this->AktivTil = $aktivTil;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HistoriskNavnData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
