<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HentArsrapportListe StructType
 * @subpackage Structs
 */
class HentArsrapportListe extends AbstractStructBase
{
    /**
     * The Orgnr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Orgnr;
    /**
     * The Dunsnr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Dunsnr;
    /**
     * Constructor method for HentArsrapportListe
     * @uses HentArsrapportListe::setOrgnr()
     * @uses HentArsrapportListe::setDunsnr()
     * @param int $orgnr
     * @param int $dunsnr
     */
    public function __construct($orgnr = null, $dunsnr = null)
    {
        $this
            ->setOrgnr($orgnr)
            ->setDunsnr($dunsnr);
    }
    /**
     * Get Orgnr value
     * @return int|null
     */
    public function getOrgnr()
    {
        return $this->Orgnr;
    }
    /**
     * Set Orgnr value
     * @param int $orgnr
     * @return \StructType\HentArsrapportListe
     */
    public function setOrgnr($orgnr = null)
    {
        // validation for constraint: int
        if (!is_null($orgnr) && !is_numeric($orgnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgnr)), __LINE__);
        }
        $this->Orgnr = $orgnr;
        return $this;
    }
    /**
     * Get Dunsnr value
     * @return int|null
     */
    public function getDunsnr()
    {
        return $this->Dunsnr;
    }
    /**
     * Set Dunsnr value
     * @param int $dunsnr
     * @return \StructType\HentArsrapportListe
     */
    public function setDunsnr($dunsnr = null)
    {
        // validation for constraint: int
        if (!is_null($dunsnr) && !is_numeric($dunsnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dunsnr)), __LINE__);
        }
        $this->Dunsnr = $dunsnr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HentArsrapportListe
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
