<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Grunnfakta StructType
 * @subpackage Structs
 */
class Grunnfakta extends AbstractStructBase
{
    /**
     * The SelskFormKode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SelskFormKode;
    /**
     * The SelskFormTekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SelskFormTekst;
    /**
     * The EtablertAr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EtablertAr;
    /**
     * The StiftetDato
     * Meta informations extracted from the WSDL
     * - default: 0001-01-01
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StiftetDato;
    /**
     * The Aksjekapital
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Aksjekapital;
    /**
     * The AksjekapitalStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AksjekapitalStatus;
    /**
     * The RegistrertSted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RegistrertSted;
    /**
     * The RegistrertDato
     * Meta informations extracted from the WSDL
     * - default: 0001-01-01
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RegistrertDato;
    /**
     * The RevisorOrgnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RevisorOrgnr;
    /**
     * The RevisorNavn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RevisorNavn;
    /**
     * The BankRegnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BankRegnr;
    /**
     * The BankNavn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankNavn;
    /**
     * The SektorKode
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SektorKode;
    /**
     * The SektorTekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SektorTekst;
    /**
     * The Formaal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Formaal;
    /**
     * The RegnskapsforerData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RegnskapsforerData[]
     */
    public $RegnskapsforerData;
    /**
     * The BransjeData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BransjeData[]
     */
    public $BransjeData;
    /**
     * The AnsatteData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AnsatteData[]
     */
    public $AnsatteData;
    /**
     * The RevisorFravalgtDato
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RevisorFravalgtDato;
    /**
     * The RegistrertMVA
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RegistrertMVA;
    /**
     * Constructor method for Grunnfakta
     * @uses Grunnfakta::setSelskFormKode()
     * @uses Grunnfakta::setSelskFormTekst()
     * @uses Grunnfakta::setEtablertAr()
     * @uses Grunnfakta::setStiftetDato()
     * @uses Grunnfakta::setAksjekapital()
     * @uses Grunnfakta::setAksjekapitalStatus()
     * @uses Grunnfakta::setRegistrertSted()
     * @uses Grunnfakta::setRegistrertDato()
     * @uses Grunnfakta::setRevisorOrgnr()
     * @uses Grunnfakta::setRevisorNavn()
     * @uses Grunnfakta::setBankRegnr()
     * @uses Grunnfakta::setBankNavn()
     * @uses Grunnfakta::setSektorKode()
     * @uses Grunnfakta::setSektorTekst()
     * @uses Grunnfakta::setFormaal()
     * @uses Grunnfakta::setRegnskapsforerData()
     * @uses Grunnfakta::setBransjeData()
     * @uses Grunnfakta::setAnsatteData()
     * @uses Grunnfakta::setRevisorFravalgtDato()
     * @uses Grunnfakta::setRegistrertMVA()
     * @param string $selskFormKode
     * @param string $selskFormTekst
     * @param int $etablertAr
     * @param string $stiftetDato
     * @param int $aksjekapital
     * @param string $aksjekapitalStatus
     * @param string $registrertSted
     * @param string $registrertDato
     * @param int $revisorOrgnr
     * @param string $revisorNavn
     * @param int $bankRegnr
     * @param string $bankNavn
     * @param int $sektorKode
     * @param string $sektorTekst
     * @param string $formaal
     * @param \StructType\RegnskapsforerData[] $regnskapsforerData
     * @param \StructType\BransjeData[] $bransjeData
     * @param \StructType\AnsatteData[] $ansatteData
     * @param string $revisorFravalgtDato
     * @param bool $registrertMVA
     */
    public function __construct($selskFormKode = null, $selskFormTekst = null, $etablertAr = null, $stiftetDato = '0001-01-01', $aksjekapital = 0, $aksjekapitalStatus = null, $registrertSted = null, $registrertDato = '0001-01-01', $revisorOrgnr = 0, $revisorNavn = null, $bankRegnr = 0, $bankNavn = null, $sektorKode = 0, $sektorTekst = null, $formaal = null, array $regnskapsforerData = array(), array $bransjeData = array(), array $ansatteData = array(), $revisorFravalgtDato = null, $registrertMVA = null)
    {
        $this
            ->setSelskFormKode($selskFormKode)
            ->setSelskFormTekst($selskFormTekst)
            ->setEtablertAr($etablertAr)
            ->setStiftetDato($stiftetDato)
            ->setAksjekapital($aksjekapital)
            ->setAksjekapitalStatus($aksjekapitalStatus)
            ->setRegistrertSted($registrertSted)
            ->setRegistrertDato($registrertDato)
            ->setRevisorOrgnr($revisorOrgnr)
            ->setRevisorNavn($revisorNavn)
            ->setBankRegnr($bankRegnr)
            ->setBankNavn($bankNavn)
            ->setSektorKode($sektorKode)
            ->setSektorTekst($sektorTekst)
            ->setFormaal($formaal)
            ->setRegnskapsforerData($regnskapsforerData)
            ->setBransjeData($bransjeData)
            ->setAnsatteData($ansatteData)
            ->setRevisorFravalgtDato($revisorFravalgtDato)
            ->setRegistrertMVA($registrertMVA);
    }
    /**
     * Get SelskFormKode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelskFormKode()
    {
        return isset($this->SelskFormKode) ? $this->SelskFormKode : null;
    }
    /**
     * Set SelskFormKode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selskFormKode
     * @return \StructType\Grunnfakta
     */
    public function setSelskFormKode($selskFormKode = null)
    {
        // validation for constraint: string
        if (!is_null($selskFormKode) && !is_string($selskFormKode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($selskFormKode)), __LINE__);
        }
        if (is_null($selskFormKode) || (is_array($selskFormKode) && empty($selskFormKode))) {
            unset($this->SelskFormKode);
        } else {
            $this->SelskFormKode = $selskFormKode;
        }
        return $this;
    }
    /**
     * Get SelskFormTekst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelskFormTekst()
    {
        return isset($this->SelskFormTekst) ? $this->SelskFormTekst : null;
    }
    /**
     * Set SelskFormTekst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selskFormTekst
     * @return \StructType\Grunnfakta
     */
    public function setSelskFormTekst($selskFormTekst = null)
    {
        // validation for constraint: string
        if (!is_null($selskFormTekst) && !is_string($selskFormTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($selskFormTekst)), __LINE__);
        }
        if (is_null($selskFormTekst) || (is_array($selskFormTekst) && empty($selskFormTekst))) {
            unset($this->SelskFormTekst);
        } else {
            $this->SelskFormTekst = $selskFormTekst;
        }
        return $this;
    }
    /**
     * Get EtablertAr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEtablertAr()
    {
        return isset($this->EtablertAr) ? $this->EtablertAr : null;
    }
    /**
     * Set EtablertAr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $etablertAr
     * @return \StructType\Grunnfakta
     */
    public function setEtablertAr($etablertAr = null)
    {
        // validation for constraint: int
        if (!is_null($etablertAr) && !is_numeric($etablertAr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($etablertAr)), __LINE__);
        }
        if (is_null($etablertAr) || (is_array($etablertAr) && empty($etablertAr))) {
            unset($this->EtablertAr);
        } else {
            $this->EtablertAr = $etablertAr;
        }
        return $this;
    }
    /**
     * Get StiftetDato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStiftetDato()
    {
        return isset($this->StiftetDato) ? $this->StiftetDato : null;
    }
    /**
     * Set StiftetDato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stiftetDato
     * @return \StructType\Grunnfakta
     */
    public function setStiftetDato($stiftetDato = '0001-01-01')
    {
        // validation for constraint: string
        if (!is_null($stiftetDato) && !is_string($stiftetDato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stiftetDato)), __LINE__);
        }
        if (is_null($stiftetDato) || (is_array($stiftetDato) && empty($stiftetDato))) {
            unset($this->StiftetDato);
        } else {
            $this->StiftetDato = $stiftetDato;
        }
        return $this;
    }
    /**
     * Get Aksjekapital value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAksjekapital()
    {
        return isset($this->Aksjekapital) ? $this->Aksjekapital : null;
    }
    /**
     * Set Aksjekapital value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aksjekapital
     * @return \StructType\Grunnfakta
     */
    public function setAksjekapital($aksjekapital = 0)
    {
        // validation for constraint: int
        if (!is_null($aksjekapital) && !is_numeric($aksjekapital)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aksjekapital)), __LINE__);
        }
        if (is_null($aksjekapital) || (is_array($aksjekapital) && empty($aksjekapital))) {
            unset($this->Aksjekapital);
        } else {
            $this->Aksjekapital = $aksjekapital;
        }
        return $this;
    }
    /**
     * Get AksjekapitalStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAksjekapitalStatus()
    {
        return isset($this->AksjekapitalStatus) ? $this->AksjekapitalStatus : null;
    }
    /**
     * Set AksjekapitalStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aksjekapitalStatus
     * @return \StructType\Grunnfakta
     */
    public function setAksjekapitalStatus($aksjekapitalStatus = null)
    {
        // validation for constraint: string
        if (!is_null($aksjekapitalStatus) && !is_string($aksjekapitalStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aksjekapitalStatus)), __LINE__);
        }
        if (is_null($aksjekapitalStatus) || (is_array($aksjekapitalStatus) && empty($aksjekapitalStatus))) {
            unset($this->AksjekapitalStatus);
        } else {
            $this->AksjekapitalStatus = $aksjekapitalStatus;
        }
        return $this;
    }
    /**
     * Get RegistrertSted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegistrertSted()
    {
        return isset($this->RegistrertSted) ? $this->RegistrertSted : null;
    }
    /**
     * Set RegistrertSted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $registrertSted
     * @return \StructType\Grunnfakta
     */
    public function setRegistrertSted($registrertSted = null)
    {
        // validation for constraint: string
        if (!is_null($registrertSted) && !is_string($registrertSted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrertSted)), __LINE__);
        }
        if (is_null($registrertSted) || (is_array($registrertSted) && empty($registrertSted))) {
            unset($this->RegistrertSted);
        } else {
            $this->RegistrertSted = $registrertSted;
        }
        return $this;
    }
    /**
     * Get RegistrertDato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegistrertDato()
    {
        return isset($this->RegistrertDato) ? $this->RegistrertDato : null;
    }
    /**
     * Set RegistrertDato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $registrertDato
     * @return \StructType\Grunnfakta
     */
    public function setRegistrertDato($registrertDato = '0001-01-01')
    {
        // validation for constraint: string
        if (!is_null($registrertDato) && !is_string($registrertDato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrertDato)), __LINE__);
        }
        if (is_null($registrertDato) || (is_array($registrertDato) && empty($registrertDato))) {
            unset($this->RegistrertDato);
        } else {
            $this->RegistrertDato = $registrertDato;
        }
        return $this;
    }
    /**
     * Get RevisorOrgnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRevisorOrgnr()
    {
        return isset($this->RevisorOrgnr) ? $this->RevisorOrgnr : null;
    }
    /**
     * Set RevisorOrgnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $revisorOrgnr
     * @return \StructType\Grunnfakta
     */
    public function setRevisorOrgnr($revisorOrgnr = 0)
    {
        // validation for constraint: int
        if (!is_null($revisorOrgnr) && !is_numeric($revisorOrgnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($revisorOrgnr)), __LINE__);
        }
        if (is_null($revisorOrgnr) || (is_array($revisorOrgnr) && empty($revisorOrgnr))) {
            unset($this->RevisorOrgnr);
        } else {
            $this->RevisorOrgnr = $revisorOrgnr;
        }
        return $this;
    }
    /**
     * Get RevisorNavn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRevisorNavn()
    {
        return isset($this->RevisorNavn) ? $this->RevisorNavn : null;
    }
    /**
     * Set RevisorNavn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $revisorNavn
     * @return \StructType\Grunnfakta
     */
    public function setRevisorNavn($revisorNavn = null)
    {
        // validation for constraint: string
        if (!is_null($revisorNavn) && !is_string($revisorNavn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($revisorNavn)), __LINE__);
        }
        if (is_null($revisorNavn) || (is_array($revisorNavn) && empty($revisorNavn))) {
            unset($this->RevisorNavn);
        } else {
            $this->RevisorNavn = $revisorNavn;
        }
        return $this;
    }
    /**
     * Get BankRegnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBankRegnr()
    {
        return isset($this->BankRegnr) ? $this->BankRegnr : null;
    }
    /**
     * Set BankRegnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bankRegnr
     * @return \StructType\Grunnfakta
     */
    public function setBankRegnr($bankRegnr = 0)
    {
        // validation for constraint: int
        if (!is_null($bankRegnr) && !is_numeric($bankRegnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bankRegnr)), __LINE__);
        }
        if (is_null($bankRegnr) || (is_array($bankRegnr) && empty($bankRegnr))) {
            unset($this->BankRegnr);
        } else {
            $this->BankRegnr = $bankRegnr;
        }
        return $this;
    }
    /**
     * Get BankNavn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankNavn()
    {
        return isset($this->BankNavn) ? $this->BankNavn : null;
    }
    /**
     * Set BankNavn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankNavn
     * @return \StructType\Grunnfakta
     */
    public function setBankNavn($bankNavn = null)
    {
        // validation for constraint: string
        if (!is_null($bankNavn) && !is_string($bankNavn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankNavn)), __LINE__);
        }
        if (is_null($bankNavn) || (is_array($bankNavn) && empty($bankNavn))) {
            unset($this->BankNavn);
        } else {
            $this->BankNavn = $bankNavn;
        }
        return $this;
    }
    /**
     * Get SektorKode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSektorKode()
    {
        return isset($this->SektorKode) ? $this->SektorKode : null;
    }
    /**
     * Set SektorKode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sektorKode
     * @return \StructType\Grunnfakta
     */
    public function setSektorKode($sektorKode = 0)
    {
        // validation for constraint: int
        if (!is_null($sektorKode) && !is_numeric($sektorKode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sektorKode)), __LINE__);
        }
        if (is_null($sektorKode) || (is_array($sektorKode) && empty($sektorKode))) {
            unset($this->SektorKode);
        } else {
            $this->SektorKode = $sektorKode;
        }
        return $this;
    }
    /**
     * Get SektorTekst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSektorTekst()
    {
        return isset($this->SektorTekst) ? $this->SektorTekst : null;
    }
    /**
     * Set SektorTekst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sektorTekst
     * @return \StructType\Grunnfakta
     */
    public function setSektorTekst($sektorTekst = null)
    {
        // validation for constraint: string
        if (!is_null($sektorTekst) && !is_string($sektorTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sektorTekst)), __LINE__);
        }
        if (is_null($sektorTekst) || (is_array($sektorTekst) && empty($sektorTekst))) {
            unset($this->SektorTekst);
        } else {
            $this->SektorTekst = $sektorTekst;
        }
        return $this;
    }
    /**
     * Get Formaal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormaal()
    {
        return isset($this->Formaal) ? $this->Formaal : null;
    }
    /**
     * Set Formaal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formaal
     * @return \StructType\Grunnfakta
     */
    public function setFormaal($formaal = null)
    {
        // validation for constraint: string
        if (!is_null($formaal) && !is_string($formaal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formaal)), __LINE__);
        }
        if (is_null($formaal) || (is_array($formaal) && empty($formaal))) {
            unset($this->Formaal);
        } else {
            $this->Formaal = $formaal;
        }
        return $this;
    }
    /**
     * Get RegnskapsforerData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RegnskapsforerData[]|null
     */
    public function getRegnskapsforerData()
    {
        return isset($this->RegnskapsforerData) ? $this->RegnskapsforerData : null;
    }
    /**
     * Set RegnskapsforerData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RegnskapsforerData[] $regnskapsforerData
     * @return \StructType\Grunnfakta
     */
    public function setRegnskapsforerData(array $regnskapsforerData = array())
    {
        foreach ($regnskapsforerData as $grunnfaktaRegnskapsforerDataItem) {
            // validation for constraint: itemType
            if (!$grunnfaktaRegnskapsforerDataItem instanceof \StructType\RegnskapsforerData) {
                throw new \InvalidArgumentException(sprintf('The RegnskapsforerData property can only contain items of \StructType\RegnskapsforerData, "%s" given', is_object($grunnfaktaRegnskapsforerDataItem) ? get_class($grunnfaktaRegnskapsforerDataItem) : gettype($grunnfaktaRegnskapsforerDataItem)), __LINE__);
            }
        }
        if (is_null($regnskapsforerData) || (is_array($regnskapsforerData) && empty($regnskapsforerData))) {
            unset($this->RegnskapsforerData);
        } else {
            $this->RegnskapsforerData = $regnskapsforerData;
        }
        return $this;
    }
    /**
     * Add item to RegnskapsforerData value
     * @throws \InvalidArgumentException
     * @param \StructType\RegnskapsforerData $item
     * @return \StructType\Grunnfakta
     */
    public function addToRegnskapsforerData(\StructType\RegnskapsforerData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RegnskapsforerData) {
            throw new \InvalidArgumentException(sprintf('The RegnskapsforerData property can only contain items of \StructType\RegnskapsforerData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RegnskapsforerData[] = $item;
        return $this;
    }
    /**
     * Get BransjeData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BransjeData[]|null
     */
    public function getBransjeData()
    {
        return isset($this->BransjeData) ? $this->BransjeData : null;
    }
    /**
     * Set BransjeData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BransjeData[] $bransjeData
     * @return \StructType\Grunnfakta
     */
    public function setBransjeData(array $bransjeData = array())
    {
        foreach ($bransjeData as $grunnfaktaBransjeDataItem) {
            // validation for constraint: itemType
            if (!$grunnfaktaBransjeDataItem instanceof \StructType\BransjeData) {
                throw new \InvalidArgumentException(sprintf('The BransjeData property can only contain items of \StructType\BransjeData, "%s" given', is_object($grunnfaktaBransjeDataItem) ? get_class($grunnfaktaBransjeDataItem) : gettype($grunnfaktaBransjeDataItem)), __LINE__);
            }
        }
        if (is_null($bransjeData) || (is_array($bransjeData) && empty($bransjeData))) {
            unset($this->BransjeData);
        } else {
            $this->BransjeData = $bransjeData;
        }
        return $this;
    }
    /**
     * Add item to BransjeData value
     * @throws \InvalidArgumentException
     * @param \StructType\BransjeData $item
     * @return \StructType\Grunnfakta
     */
    public function addToBransjeData(\StructType\BransjeData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BransjeData) {
            throw new \InvalidArgumentException(sprintf('The BransjeData property can only contain items of \StructType\BransjeData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BransjeData[] = $item;
        return $this;
    }
    /**
     * Get AnsatteData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AnsatteData[]|null
     */
    public function getAnsatteData()
    {
        return isset($this->AnsatteData) ? $this->AnsatteData : null;
    }
    /**
     * Set AnsatteData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AnsatteData[] $ansatteData
     * @return \StructType\Grunnfakta
     */
    public function setAnsatteData(array $ansatteData = array())
    {
        foreach ($ansatteData as $grunnfaktaAnsatteDataItem) {
            // validation for constraint: itemType
            if (!$grunnfaktaAnsatteDataItem instanceof \StructType\AnsatteData) {
                throw new \InvalidArgumentException(sprintf('The AnsatteData property can only contain items of \StructType\AnsatteData, "%s" given', is_object($grunnfaktaAnsatteDataItem) ? get_class($grunnfaktaAnsatteDataItem) : gettype($grunnfaktaAnsatteDataItem)), __LINE__);
            }
        }
        if (is_null($ansatteData) || (is_array($ansatteData) && empty($ansatteData))) {
            unset($this->AnsatteData);
        } else {
            $this->AnsatteData = $ansatteData;
        }
        return $this;
    }
    /**
     * Add item to AnsatteData value
     * @throws \InvalidArgumentException
     * @param \StructType\AnsatteData $item
     * @return \StructType\Grunnfakta
     */
    public function addToAnsatteData(\StructType\AnsatteData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AnsatteData) {
            throw new \InvalidArgumentException(sprintf('The AnsatteData property can only contain items of \StructType\AnsatteData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AnsatteData[] = $item;
        return $this;
    }
    /**
     * Get RevisorFravalgtDato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRevisorFravalgtDato()
    {
        return isset($this->RevisorFravalgtDato) ? $this->RevisorFravalgtDato : null;
    }
    /**
     * Set RevisorFravalgtDato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $revisorFravalgtDato
     * @return \StructType\Grunnfakta
     */
    public function setRevisorFravalgtDato($revisorFravalgtDato = null)
    {
        // validation for constraint: string
        if (!is_null($revisorFravalgtDato) && !is_string($revisorFravalgtDato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($revisorFravalgtDato)), __LINE__);
        }
        if (is_null($revisorFravalgtDato) || (is_array($revisorFravalgtDato) && empty($revisorFravalgtDato))) {
            unset($this->RevisorFravalgtDato);
        } else {
            $this->RevisorFravalgtDato = $revisorFravalgtDato;
        }
        return $this;
    }
    /**
     * Get RegistrertMVA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRegistrertMVA()
    {
        return isset($this->RegistrertMVA) ? $this->RegistrertMVA : null;
    }
    /**
     * Set RegistrertMVA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $registrertMVA
     * @return \StructType\Grunnfakta
     */
    public function setRegistrertMVA($registrertMVA = null)
    {
        // validation for constraint: boolean
        if (!is_null($registrertMVA) && !is_bool($registrertMVA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($registrertMVA)), __LINE__);
        }
        if (is_null($registrertMVA) || (is_array($registrertMVA) && empty($registrertMVA))) {
            unset($this->RegistrertMVA);
        } else {
            $this->RegistrertMVA = $registrertMVA;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Grunnfakta
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
