<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GjenpartData StructType
 * @subpackage Structs
 */
class GjenpartData extends AbstractStructBase
{
    /**
     * The Referansenr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Referansenr;
    /**
     * The OmspurtData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OmspurtData
     */
    public $OmspurtData;
    /**
     * The Ligning
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LigningGjenpart[]
     */
    public $Ligning;
    /**
     * The NaringsInteresser
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaringsInteresserGjenpart[]
     */
    public $NaringsInteresser;
    /**
     * The BetaOmspurtDetaljer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BetaOmspurtDetaljer
     */
    public $BetaOmspurtDetaljer;
    /**
     * Constructor method for GjenpartData
     * @uses GjenpartData::setReferansenr()
     * @uses GjenpartData::setOmspurtData()
     * @uses GjenpartData::setLigning()
     * @uses GjenpartData::setNaringsInteresser()
     * @uses GjenpartData::setBetaOmspurtDetaljer()
     * @param string $referansenr
     * @param \StructType\OmspurtData $omspurtData
     * @param \StructType\LigningGjenpart[] $ligning
     * @param \StructType\NaringsInteresserGjenpart[] $naringsInteresser
     * @param \StructType\BetaOmspurtDetaljer $betaOmspurtDetaljer
     */
    public function __construct($referansenr = null, \StructType\OmspurtData $omspurtData = null, array $ligning = array(), array $naringsInteresser = array(), \StructType\BetaOmspurtDetaljer $betaOmspurtDetaljer = null)
    {
        $this
            ->setReferansenr($referansenr)
            ->setOmspurtData($omspurtData)
            ->setLigning($ligning)
            ->setNaringsInteresser($naringsInteresser)
            ->setBetaOmspurtDetaljer($betaOmspurtDetaljer);
    }
    /**
     * Get Referansenr value
     * @return string
     */
    public function getReferansenr()
    {
        return $this->Referansenr;
    }
    /**
     * Set Referansenr value
     * @param string $referansenr
     * @return \StructType\GjenpartData
     */
    public function setReferansenr($referansenr = null)
    {
        // validation for constraint: string
        if (!is_null($referansenr) && !is_string($referansenr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referansenr)), __LINE__);
        }
        $this->Referansenr = $referansenr;
        return $this;
    }
    /**
     * Get OmspurtData value
     * @return \StructType\OmspurtData|null
     */
    public function getOmspurtData()
    {
        return $this->OmspurtData;
    }
    /**
     * Set OmspurtData value
     * @param \StructType\OmspurtData $omspurtData
     * @return \StructType\GjenpartData
     */
    public function setOmspurtData(\StructType\OmspurtData $omspurtData = null)
    {
        $this->OmspurtData = $omspurtData;
        return $this;
    }
    /**
     * Get Ligning value
     * @return \StructType\LigningGjenpart[]|null
     */
    public function getLigning()
    {
        return $this->Ligning;
    }
    /**
     * Set Ligning value
     * @throws \InvalidArgumentException
     * @param \StructType\LigningGjenpart[] $ligning
     * @return \StructType\GjenpartData
     */
    public function setLigning(array $ligning = array())
    {
        foreach ($ligning as $gjenpartDataLigningItem) {
            // validation for constraint: itemType
            if (!$gjenpartDataLigningItem instanceof \StructType\LigningGjenpart) {
                throw new \InvalidArgumentException(sprintf('The Ligning property can only contain items of \StructType\LigningGjenpart, "%s" given', is_object($gjenpartDataLigningItem) ? get_class($gjenpartDataLigningItem) : gettype($gjenpartDataLigningItem)), __LINE__);
            }
        }
        $this->Ligning = $ligning;
        return $this;
    }
    /**
     * Add item to Ligning value
     * @throws \InvalidArgumentException
     * @param \StructType\LigningGjenpart $item
     * @return \StructType\GjenpartData
     */
    public function addToLigning(\StructType\LigningGjenpart $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LigningGjenpart) {
            throw new \InvalidArgumentException(sprintf('The Ligning property can only contain items of \StructType\LigningGjenpart, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Ligning[] = $item;
        return $this;
    }
    /**
     * Get NaringsInteresser value
     * @return \StructType\NaringsInteresserGjenpart[]|null
     */
    public function getNaringsInteresser()
    {
        return $this->NaringsInteresser;
    }
    /**
     * Set NaringsInteresser value
     * @throws \InvalidArgumentException
     * @param \StructType\NaringsInteresserGjenpart[] $naringsInteresser
     * @return \StructType\GjenpartData
     */
    public function setNaringsInteresser(array $naringsInteresser = array())
    {
        foreach ($naringsInteresser as $gjenpartDataNaringsInteresserItem) {
            // validation for constraint: itemType
            if (!$gjenpartDataNaringsInteresserItem instanceof \StructType\NaringsInteresserGjenpart) {
                throw new \InvalidArgumentException(sprintf('The NaringsInteresser property can only contain items of \StructType\NaringsInteresserGjenpart, "%s" given', is_object($gjenpartDataNaringsInteresserItem) ? get_class($gjenpartDataNaringsInteresserItem) : gettype($gjenpartDataNaringsInteresserItem)), __LINE__);
            }
        }
        $this->NaringsInteresser = $naringsInteresser;
        return $this;
    }
    /**
     * Add item to NaringsInteresser value
     * @throws \InvalidArgumentException
     * @param \StructType\NaringsInteresserGjenpart $item
     * @return \StructType\GjenpartData
     */
    public function addToNaringsInteresser(\StructType\NaringsInteresserGjenpart $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaringsInteresserGjenpart) {
            throw new \InvalidArgumentException(sprintf('The NaringsInteresser property can only contain items of \StructType\NaringsInteresserGjenpart, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NaringsInteresser[] = $item;
        return $this;
    }
    /**
     * Get BetaOmspurtDetaljer value
     * @return \StructType\BetaOmspurtDetaljer|null
     */
    public function getBetaOmspurtDetaljer()
    {
        return $this->BetaOmspurtDetaljer;
    }
    /**
     * Set BetaOmspurtDetaljer value
     * @param \StructType\BetaOmspurtDetaljer $betaOmspurtDetaljer
     * @return \StructType\GjenpartData
     */
    public function setBetaOmspurtDetaljer(\StructType\BetaOmspurtDetaljer $betaOmspurtDetaljer = null)
    {
        $this->BetaOmspurtDetaljer = $betaOmspurtDetaljer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GjenpartData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
