<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Gjenpart StructType
 * @subpackage Structs
 */
class Gjenpart extends AbstractStructBase
{
    /**
     * The SluttBrukerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SluttBrukerID;
    /**
     * The KundeNavn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KundeNavn;
    /**
     * The KundeAdresse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KundeAdresse;
    /**
     * The Postnr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Postnr;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Telefon
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Telefon;
    /**
     * Constructor method for Gjenpart
     * @uses Gjenpart::setSluttBrukerID()
     * @uses Gjenpart::setKundeNavn()
     * @uses Gjenpart::setKundeAdresse()
     * @uses Gjenpart::setPostnr()
     * @uses Gjenpart::setEmail()
     * @uses Gjenpart::setTelefon()
     * @param string $sluttBrukerID
     * @param string $kundeNavn
     * @param string $kundeAdresse
     * @param int $postnr
     * @param string $email
     * @param int $telefon
     */
    public function __construct($sluttBrukerID = null, $kundeNavn = null, $kundeAdresse = null, $postnr = null, $email = null, $telefon = null)
    {
        $this
            ->setSluttBrukerID($sluttBrukerID)
            ->setKundeNavn($kundeNavn)
            ->setKundeAdresse($kundeAdresse)
            ->setPostnr($postnr)
            ->setEmail($email)
            ->setTelefon($telefon);
    }
    /**
     * Get SluttBrukerID value
     * @return string|null
     */
    public function getSluttBrukerID()
    {
        return $this->SluttBrukerID;
    }
    /**
     * Set SluttBrukerID value
     * @param string $sluttBrukerID
     * @return \StructType\Gjenpart
     */
    public function setSluttBrukerID($sluttBrukerID = null)
    {
        // validation for constraint: string
        if (!is_null($sluttBrukerID) && !is_string($sluttBrukerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sluttBrukerID)), __LINE__);
        }
        $this->SluttBrukerID = $sluttBrukerID;
        return $this;
    }
    /**
     * Get KundeNavn value
     * @return string|null
     */
    public function getKundeNavn()
    {
        return $this->KundeNavn;
    }
    /**
     * Set KundeNavn value
     * @param string $kundeNavn
     * @return \StructType\Gjenpart
     */
    public function setKundeNavn($kundeNavn = null)
    {
        // validation for constraint: string
        if (!is_null($kundeNavn) && !is_string($kundeNavn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kundeNavn)), __LINE__);
        }
        $this->KundeNavn = $kundeNavn;
        return $this;
    }
    /**
     * Get KundeAdresse value
     * @return string|null
     */
    public function getKundeAdresse()
    {
        return $this->KundeAdresse;
    }
    /**
     * Set KundeAdresse value
     * @param string $kundeAdresse
     * @return \StructType\Gjenpart
     */
    public function setKundeAdresse($kundeAdresse = null)
    {
        // validation for constraint: string
        if (!is_null($kundeAdresse) && !is_string($kundeAdresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kundeAdresse)), __LINE__);
        }
        $this->KundeAdresse = $kundeAdresse;
        return $this;
    }
    /**
     * Get Postnr value
     * @return int|null
     */
    public function getPostnr()
    {
        return $this->Postnr;
    }
    /**
     * Set Postnr value
     * @param int $postnr
     * @return \StructType\Gjenpart
     */
    public function setPostnr($postnr = null)
    {
        // validation for constraint: int
        if (!is_null($postnr) && !is_numeric($postnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($postnr)), __LINE__);
        }
        $this->Postnr = $postnr;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Gjenpart
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Telefon value
     * @return int|null
     */
    public function getTelefon()
    {
        return $this->Telefon;
    }
    /**
     * Set Telefon value
     * @param int $telefon
     * @return \StructType\Gjenpart
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: int
        if (!is_null($telefon) && !is_numeric($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($telefon)), __LINE__);
        }
        $this->Telefon = $telefon;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Gjenpart
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
