<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Datterselskap StructType
 * @subpackage Structs
 */
class Datterselskap extends AbstractStructBase
{
    /**
     * The Orgnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Orgnr;
    /**
     * The KodeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KodeType;
    /**
     * The KodeTekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KodeTekst;
    /**
     * The Navn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Navn;
    /**
     * The Postnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Postnr;
    /**
     * The Poststed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Poststed;
    /**
     * The Eierandel
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Eierandel;
    /**
     * Constructor method for Datterselskap
     * @uses Datterselskap::setOrgnr()
     * @uses Datterselskap::setKodeType()
     * @uses Datterselskap::setKodeTekst()
     * @uses Datterselskap::setNavn()
     * @uses Datterselskap::setPostnr()
     * @uses Datterselskap::setPoststed()
     * @uses Datterselskap::setEierandel()
     * @param int $orgnr
     * @param string $kodeType
     * @param string $kodeTekst
     * @param string $navn
     * @param int $postnr
     * @param string $poststed
     * @param float $eierandel
     */
    public function __construct($orgnr = 0, $kodeType = null, $kodeTekst = null, $navn = null, $postnr = 0, $poststed = null, $eierandel = 0)
    {
        $this
            ->setOrgnr($orgnr)
            ->setKodeType($kodeType)
            ->setKodeTekst($kodeTekst)
            ->setNavn($navn)
            ->setPostnr($postnr)
            ->setPoststed($poststed)
            ->setEierandel($eierandel);
    }
    /**
     * Get Orgnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrgnr()
    {
        return isset($this->Orgnr) ? $this->Orgnr : null;
    }
    /**
     * Set Orgnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $orgnr
     * @return \StructType\Datterselskap
     */
    public function setOrgnr($orgnr = 0)
    {
        // validation for constraint: int
        if (!is_null($orgnr) && !is_numeric($orgnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgnr)), __LINE__);
        }
        if (is_null($orgnr) || (is_array($orgnr) && empty($orgnr))) {
            unset($this->Orgnr);
        } else {
            $this->Orgnr = $orgnr;
        }
        return $this;
    }
    /**
     * Get KodeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKodeType()
    {
        return isset($this->KodeType) ? $this->KodeType : null;
    }
    /**
     * Set KodeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kodeType
     * @return \StructType\Datterselskap
     */
    public function setKodeType($kodeType = null)
    {
        // validation for constraint: string
        if (!is_null($kodeType) && !is_string($kodeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kodeType)), __LINE__);
        }
        if (is_null($kodeType) || (is_array($kodeType) && empty($kodeType))) {
            unset($this->KodeType);
        } else {
            $this->KodeType = $kodeType;
        }
        return $this;
    }
    /**
     * Get KodeTekst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKodeTekst()
    {
        return isset($this->KodeTekst) ? $this->KodeTekst : null;
    }
    /**
     * Set KodeTekst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kodeTekst
     * @return \StructType\Datterselskap
     */
    public function setKodeTekst($kodeTekst = null)
    {
        // validation for constraint: string
        if (!is_null($kodeTekst) && !is_string($kodeTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kodeTekst)), __LINE__);
        }
        if (is_null($kodeTekst) || (is_array($kodeTekst) && empty($kodeTekst))) {
            unset($this->KodeTekst);
        } else {
            $this->KodeTekst = $kodeTekst;
        }
        return $this;
    }
    /**
     * Get Navn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNavn()
    {
        return isset($this->Navn) ? $this->Navn : null;
    }
    /**
     * Set Navn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $navn
     * @return \StructType\Datterselskap
     */
    public function setNavn($navn = null)
    {
        // validation for constraint: string
        if (!is_null($navn) && !is_string($navn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($navn)), __LINE__);
        }
        if (is_null($navn) || (is_array($navn) && empty($navn))) {
            unset($this->Navn);
        } else {
            $this->Navn = $navn;
        }
        return $this;
    }
    /**
     * Get Postnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPostnr()
    {
        return isset($this->Postnr) ? $this->Postnr : null;
    }
    /**
     * Set Postnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $postnr
     * @return \StructType\Datterselskap
     */
    public function setPostnr($postnr = 0)
    {
        // validation for constraint: int
        if (!is_null($postnr) && !is_numeric($postnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($postnr)), __LINE__);
        }
        if (is_null($postnr) || (is_array($postnr) && empty($postnr))) {
            unset($this->Postnr);
        } else {
            $this->Postnr = $postnr;
        }
        return $this;
    }
    /**
     * Get Poststed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPoststed()
    {
        return isset($this->Poststed) ? $this->Poststed : null;
    }
    /**
     * Set Poststed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $poststed
     * @return \StructType\Datterselskap
     */
    public function setPoststed($poststed = null)
    {
        // validation for constraint: string
        if (!is_null($poststed) && !is_string($poststed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($poststed)), __LINE__);
        }
        if (is_null($poststed) || (is_array($poststed) && empty($poststed))) {
            unset($this->Poststed);
        } else {
            $this->Poststed = $poststed;
        }
        return $this;
    }
    /**
     * Get Eierandel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getEierandel()
    {
        return isset($this->Eierandel) ? $this->Eierandel : null;
    }
    /**
     * Set Eierandel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $eierandel
     * @return \StructType\Datterselskap
     */
    public function setEierandel($eierandel = 0)
    {
        if (is_null($eierandel) || (is_array($eierandel) && empty($eierandel))) {
            unset($this->Eierandel);
        } else {
            $this->Eierandel = $eierandel;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Datterselskap
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
