<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvdelingData StructType
 * @subpackage Structs
 */
class AvdelingData extends AbstractStructBase
{
    /**
     * The AntallAnsatte
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AntallAnsatte;
    /**
     * The Telefon
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Telefon;
    /**
     * The Telefax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Telefax;
    /**
     * The StiftetDato
     * Meta informations extracted from the WSDL
     * - default: 0001-01-01
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StiftetDato;
    /**
     * The BransjeKode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BransjeKode;
    /**
     * The BransjeTekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BransjeTekst;
    /**
     * The DagligLeder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DagligLeder;
    /**
     * The HovedforetakOrgnr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HovedforetakOrgnr;
    /**
     * The HovedforetakDunsnr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HovedforetakDunsnr;
    /**
     * The HovedforetakNavn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HovedforetakNavn;
    /**
     * Constructor method for AvdelingData
     * @uses AvdelingData::setAntallAnsatte()
     * @uses AvdelingData::setTelefon()
     * @uses AvdelingData::setTelefax()
     * @uses AvdelingData::setStiftetDato()
     * @uses AvdelingData::setBransjeKode()
     * @uses AvdelingData::setBransjeTekst()
     * @uses AvdelingData::setDagligLeder()
     * @uses AvdelingData::setHovedforetakOrgnr()
     * @uses AvdelingData::setHovedforetakDunsnr()
     * @uses AvdelingData::setHovedforetakNavn()
     * @param int $antallAnsatte
     * @param int $telefon
     * @param int $telefax
     * @param string $stiftetDato
     * @param string $bransjeKode
     * @param string $bransjeTekst
     * @param string $dagligLeder
     * @param int $hovedforetakOrgnr
     * @param int $hovedforetakDunsnr
     * @param string $hovedforetakNavn
     */
    public function __construct($antallAnsatte = null, $telefon = null, $telefax = null, $stiftetDato = '0001-01-01', $bransjeKode = null, $bransjeTekst = null, $dagligLeder = null, $hovedforetakOrgnr = null, $hovedforetakDunsnr = null, $hovedforetakNavn = null)
    {
        $this
            ->setAntallAnsatte($antallAnsatte)
            ->setTelefon($telefon)
            ->setTelefax($telefax)
            ->setStiftetDato($stiftetDato)
            ->setBransjeKode($bransjeKode)
            ->setBransjeTekst($bransjeTekst)
            ->setDagligLeder($dagligLeder)
            ->setHovedforetakOrgnr($hovedforetakOrgnr)
            ->setHovedforetakDunsnr($hovedforetakDunsnr)
            ->setHovedforetakNavn($hovedforetakNavn);
    }
    /**
     * Get AntallAnsatte value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAntallAnsatte()
    {
        return isset($this->AntallAnsatte) ? $this->AntallAnsatte : null;
    }
    /**
     * Set AntallAnsatte value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $antallAnsatte
     * @return \StructType\AvdelingData
     */
    public function setAntallAnsatte($antallAnsatte = null)
    {
        // validation for constraint: int
        if (!is_null($antallAnsatte) && !is_numeric($antallAnsatte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($antallAnsatte)), __LINE__);
        }
        if (is_null($antallAnsatte) || (is_array($antallAnsatte) && empty($antallAnsatte))) {
            unset($this->AntallAnsatte);
        } else {
            $this->AntallAnsatte = $antallAnsatte;
        }
        return $this;
    }
    /**
     * Get Telefon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTelefon()
    {
        return isset($this->Telefon) ? $this->Telefon : null;
    }
    /**
     * Set Telefon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $telefon
     * @return \StructType\AvdelingData
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: int
        if (!is_null($telefon) && !is_numeric($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($telefon)), __LINE__);
        }
        if (is_null($telefon) || (is_array($telefon) && empty($telefon))) {
            unset($this->Telefon);
        } else {
            $this->Telefon = $telefon;
        }
        return $this;
    }
    /**
     * Get Telefax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTelefax()
    {
        return isset($this->Telefax) ? $this->Telefax : null;
    }
    /**
     * Set Telefax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $telefax
     * @return \StructType\AvdelingData
     */
    public function setTelefax($telefax = null)
    {
        // validation for constraint: int
        if (!is_null($telefax) && !is_numeric($telefax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($telefax)), __LINE__);
        }
        if (is_null($telefax) || (is_array($telefax) && empty($telefax))) {
            unset($this->Telefax);
        } else {
            $this->Telefax = $telefax;
        }
        return $this;
    }
    /**
     * Get StiftetDato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStiftetDato()
    {
        return isset($this->StiftetDato) ? $this->StiftetDato : null;
    }
    /**
     * Set StiftetDato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stiftetDato
     * @return \StructType\AvdelingData
     */
    public function setStiftetDato($stiftetDato = '0001-01-01')
    {
        // validation for constraint: string
        if (!is_null($stiftetDato) && !is_string($stiftetDato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stiftetDato)), __LINE__);
        }
        if (is_null($stiftetDato) || (is_array($stiftetDato) && empty($stiftetDato))) {
            unset($this->StiftetDato);
        } else {
            $this->StiftetDato = $stiftetDato;
        }
        return $this;
    }
    /**
     * Get BransjeKode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBransjeKode()
    {
        return isset($this->BransjeKode) ? $this->BransjeKode : null;
    }
    /**
     * Set BransjeKode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bransjeKode
     * @return \StructType\AvdelingData
     */
    public function setBransjeKode($bransjeKode = null)
    {
        // validation for constraint: string
        if (!is_null($bransjeKode) && !is_string($bransjeKode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bransjeKode)), __LINE__);
        }
        if (is_null($bransjeKode) || (is_array($bransjeKode) && empty($bransjeKode))) {
            unset($this->BransjeKode);
        } else {
            $this->BransjeKode = $bransjeKode;
        }
        return $this;
    }
    /**
     * Get BransjeTekst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBransjeTekst()
    {
        return isset($this->BransjeTekst) ? $this->BransjeTekst : null;
    }
    /**
     * Set BransjeTekst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bransjeTekst
     * @return \StructType\AvdelingData
     */
    public function setBransjeTekst($bransjeTekst = null)
    {
        // validation for constraint: string
        if (!is_null($bransjeTekst) && !is_string($bransjeTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bransjeTekst)), __LINE__);
        }
        if (is_null($bransjeTekst) || (is_array($bransjeTekst) && empty($bransjeTekst))) {
            unset($this->BransjeTekst);
        } else {
            $this->BransjeTekst = $bransjeTekst;
        }
        return $this;
    }
    /**
     * Get DagligLeder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDagligLeder()
    {
        return isset($this->DagligLeder) ? $this->DagligLeder : null;
    }
    /**
     * Set DagligLeder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dagligLeder
     * @return \StructType\AvdelingData
     */
    public function setDagligLeder($dagligLeder = null)
    {
        // validation for constraint: string
        if (!is_null($dagligLeder) && !is_string($dagligLeder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dagligLeder)), __LINE__);
        }
        if (is_null($dagligLeder) || (is_array($dagligLeder) && empty($dagligLeder))) {
            unset($this->DagligLeder);
        } else {
            $this->DagligLeder = $dagligLeder;
        }
        return $this;
    }
    /**
     * Get HovedforetakOrgnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHovedforetakOrgnr()
    {
        return isset($this->HovedforetakOrgnr) ? $this->HovedforetakOrgnr : null;
    }
    /**
     * Set HovedforetakOrgnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $hovedforetakOrgnr
     * @return \StructType\AvdelingData
     */
    public function setHovedforetakOrgnr($hovedforetakOrgnr = null)
    {
        // validation for constraint: int
        if (!is_null($hovedforetakOrgnr) && !is_numeric($hovedforetakOrgnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hovedforetakOrgnr)), __LINE__);
        }
        if (is_null($hovedforetakOrgnr) || (is_array($hovedforetakOrgnr) && empty($hovedforetakOrgnr))) {
            unset($this->HovedforetakOrgnr);
        } else {
            $this->HovedforetakOrgnr = $hovedforetakOrgnr;
        }
        return $this;
    }
    /**
     * Get HovedforetakDunsnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHovedforetakDunsnr()
    {
        return isset($this->HovedforetakDunsnr) ? $this->HovedforetakDunsnr : null;
    }
    /**
     * Set HovedforetakDunsnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $hovedforetakDunsnr
     * @return \StructType\AvdelingData
     */
    public function setHovedforetakDunsnr($hovedforetakDunsnr = null)
    {
        // validation for constraint: int
        if (!is_null($hovedforetakDunsnr) && !is_numeric($hovedforetakDunsnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hovedforetakDunsnr)), __LINE__);
        }
        if (is_null($hovedforetakDunsnr) || (is_array($hovedforetakDunsnr) && empty($hovedforetakDunsnr))) {
            unset($this->HovedforetakDunsnr);
        } else {
            $this->HovedforetakDunsnr = $hovedforetakDunsnr;
        }
        return $this;
    }
    /**
     * Get HovedforetakNavn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHovedforetakNavn()
    {
        return isset($this->HovedforetakNavn) ? $this->HovedforetakNavn : null;
    }
    /**
     * Set HovedforetakNavn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hovedforetakNavn
     * @return \StructType\AvdelingData
     */
    public function setHovedforetakNavn($hovedforetakNavn = null)
    {
        // validation for constraint: string
        if (!is_null($hovedforetakNavn) && !is_string($hovedforetakNavn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hovedforetakNavn)), __LINE__);
        }
        if (is_null($hovedforetakNavn) || (is_array($hovedforetakNavn) && empty($hovedforetakNavn))) {
            unset($this->HovedforetakNavn);
        } else {
            $this->HovedforetakNavn = $hovedforetakNavn;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AvdelingData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
