<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArsrapportData StructType
 * @subpackage Structs
 */
class ArsrapportData extends AbstractStructBase
{
    /**
     * The Orgnr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Orgnr;
    /**
     * The Dunsnr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Dunsnr;
    /**
     * The Navn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Navn;
    /**
     * The Regnskapsar
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Regnskapsar
     */
    public $Regnskapsar;
    /**
     * Constructor method for ArsrapportData
     * @uses ArsrapportData::setOrgnr()
     * @uses ArsrapportData::setDunsnr()
     * @uses ArsrapportData::setNavn()
     * @uses ArsrapportData::setRegnskapsar()
     * @param int $orgnr
     * @param int $dunsnr
     * @param string $navn
     * @param \StructType\Regnskapsar $regnskapsar
     */
    public function __construct($orgnr = null, $dunsnr = null, $navn = null, \StructType\Regnskapsar $regnskapsar = null)
    {
        $this
            ->setOrgnr($orgnr)
            ->setDunsnr($dunsnr)
            ->setNavn($navn)
            ->setRegnskapsar($regnskapsar);
    }
    /**
     * Get Orgnr value
     * @return int
     */
    public function getOrgnr()
    {
        return $this->Orgnr;
    }
    /**
     * Set Orgnr value
     * @param int $orgnr
     * @return \StructType\ArsrapportData
     */
    public function setOrgnr($orgnr = null)
    {
        // validation for constraint: int
        if (!is_null($orgnr) && !is_numeric($orgnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgnr)), __LINE__);
        }
        $this->Orgnr = $orgnr;
        return $this;
    }
    /**
     * Get Dunsnr value
     * @return int
     */
    public function getDunsnr()
    {
        return $this->Dunsnr;
    }
    /**
     * Set Dunsnr value
     * @param int $dunsnr
     * @return \StructType\ArsrapportData
     */
    public function setDunsnr($dunsnr = null)
    {
        // validation for constraint: int
        if (!is_null($dunsnr) && !is_numeric($dunsnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dunsnr)), __LINE__);
        }
        $this->Dunsnr = $dunsnr;
        return $this;
    }
    /**
     * Get Navn value
     * @return string
     */
    public function getNavn()
    {
        return $this->Navn;
    }
    /**
     * Set Navn value
     * @param string $navn
     * @return \StructType\ArsrapportData
     */
    public function setNavn($navn = null)
    {
        // validation for constraint: string
        if (!is_null($navn) && !is_string($navn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($navn)), __LINE__);
        }
        $this->Navn = $navn;
        return $this;
    }
    /**
     * Get Regnskapsar value
     * @return \StructType\Regnskapsar|null
     */
    public function getRegnskapsar()
    {
        return $this->Regnskapsar;
    }
    /**
     * Set Regnskapsar value
     * @param \StructType\Regnskapsar $regnskapsar
     * @return \StructType\ArsrapportData
     */
    public function setRegnskapsar(\StructType\Regnskapsar $regnskapsar = null)
    {
        $this->Regnskapsar = $regnskapsar;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArsrapportData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
