<?php

namespace EnumType;

/**
 * This class stands for SokTypeVerdier EnumType
 * @subpackage Enumerations
 */
class SokTypeVerdier
{
    /**
     * Constant for value 'Matchit'
     * @return string 'Matchit'
     */
    const VALUE_MATCHIT = 'Matchit';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MATCHIT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MATCHIT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
