<?php

namespace EnumType;

/**
 * This class stands for Overvakningstype EnumType
 * @subpackage Enumerations
 */
class Overvakningstype
{
    /**
     * Constant for value 'Daglig overvakning'
     * @return string 'Daglig overvakning'
     */
    const VALUE_DAGLIG_OVERVAKNING = 'Daglig overvakning';
    /**
     * Constant for value 'Daglig overvakning + SDO Mini'
     * @return string 'Daglig overvakning + SDO Mini'
     */
    const VALUE_DAGLIG_OVERVAKNING_SDO_MINI = 'Daglig overvakning + SDO Mini';
    /**
     * Constant for value 'Daglig overvakning + SDO Normal'
     * @return string 'Daglig overvakning + SDO Normal'
     */
    const VALUE_DAGLIG_OVERVAKNING_SDO_NORMAL = 'Daglig overvakning + SDO Normal';
    /**
     * Constant for value 'Daglig overvakning + SDO Spesial'
     * @return string 'Daglig overvakning + SDO Spesial'
     */
    const VALUE_DAGLIG_OVERVAKNING_SDO_SPESIAL = 'Daglig overvakning + SDO Spesial';
    /**
     * Constant for value 'SDO Mini'
     * @return string 'SDO Mini'
     */
    const VALUE_SDO_MINI = 'SDO Mini';
    /**
     * Constant for value 'SDO Normal'
     * @return string 'SDO Normal'
     */
    const VALUE_SDO_NORMAL = 'SDO Normal';
    /**
     * Constant for value 'SDO Spesial'
     * @return string 'SDO Spesial'
     */
    const VALUE_SDO_SPESIAL = 'SDO Spesial';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DAGLIG_OVERVAKNING
     * @uses self::VALUE_DAGLIG_OVERVAKNING_SDO_MINI
     * @uses self::VALUE_DAGLIG_OVERVAKNING_SDO_NORMAL
     * @uses self::VALUE_DAGLIG_OVERVAKNING_SDO_SPESIAL
     * @uses self::VALUE_SDO_MINI
     * @uses self::VALUE_SDO_NORMAL
     * @uses self::VALUE_SDO_SPESIAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DAGLIG_OVERVAKNING,
            self::VALUE_DAGLIG_OVERVAKNING_SDO_MINI,
            self::VALUE_DAGLIG_OVERVAKNING_SDO_NORMAL,
            self::VALUE_DAGLIG_OVERVAKNING_SDO_SPESIAL,
            self::VALUE_SDO_MINI,
            self::VALUE_SDO_NORMAL,
            self::VALUE_SDO_SPESIAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
