<?php

namespace EnumType;

/**
 * This class stands for KonsernlinkType EnumType
 * @subpackage Enumerations
 */
class KonsernlinkType
{
    /**
     * Constant for value 'HeleKonsernet'
     * @return string 'HeleKonsernet'
     */
    const VALUE_HELE_KONSERNET = 'HeleKonsernet';
    /**
     * Constant for value 'ForetakOversteMor'
     * @return string 'ForetakOversteMor'
     */
    const VALUE_FORETAK_OVERSTE_MOR = 'ForetakOversteMor';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HELE_KONSERNET
     * @uses self::VALUE_FORETAK_OVERSTE_MOR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HELE_KONSERNET,
            self::VALUE_FORETAK_OVERSTE_MOR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
