<?php

namespace EnumType;

/**
 * This class stands for EiendomVerdier EnumType
 * @subpackage Enumerations
 */
class EiendomVerdier
{
    /**
     * Constant for value 'EiendomNorge'
     * @return string 'EiendomNorge'
     */
    const VALUE_EIENDOM_NORGE = 'EiendomNorge';
    /**
     * Constant for value 'EiendomNorgeListe'
     * @return string 'EiendomNorgeListe'
     */
    const VALUE_EIENDOM_NORGE_LISTE = 'EiendomNorgeListe';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EIENDOM_NORGE
     * @uses self::VALUE_EIENDOM_NORGE_LISTE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EIENDOM_NORGE,
            self::VALUE_EIENDOM_NORGE_LISTE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
