<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for wijkCheckResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error182: De combinatie postcode/huisnummer is ongeldig | error183: De uitgave code is ongeldig | error184: De abonnementsoort code is ongeldig of niet gekoppeld aan een uitgave | error185: De pakketcode is ongeldig of er zijn geen
 * gekoppelde uitgaven | error186: De postcode dient te bestaan uit 4 cijfers gevolgd door een spatie en 2 hoofdletters | error187: Het huisnummer dient geheel te bestaan uit cijfers | error188: Teveel parameters tegelijk ingevuld, kies uitgave of
 * abonnementsoort of pakket | error256: De propositie is niet gevonden
 * @subpackage Structs
 */
class WijkCheckResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The leveringMogelijk
     * Meta informations extracted from the WSDL
     * - documentation: [0,1,2] Indicatie of levering mogelijk is. 0 = geen levering mogelijk, 1 = reguliere bezorging mogelijk, 2 = postbezorging mogelijk.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $leveringMogelijk;
    /**
     * Constructor method for wijkCheckResponse
     * @uses WijkCheckResponse::setRequestTag()
     * @uses WijkCheckResponse::setLeveringMogelijk()
     * @param string $requestTag
     * @param float $leveringMogelijk
     */
    public function __construct($requestTag = null, $leveringMogelijk = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setLeveringMogelijk($leveringMogelijk);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\WijkCheckResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get leveringMogelijk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLeveringMogelijk()
    {
        return isset($this->leveringMogelijk) ? $this->leveringMogelijk : null;
    }
    /**
     * Set leveringMogelijk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $leveringMogelijk
     * @return \StructType\WijkCheckResponse
     */
    public function setLeveringMogelijk($leveringMogelijk = null)
    {
        // validation for constraint: totalDigits
        if (is_float($leveringMogelijk) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $leveringMogelijk)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($leveringMogelijk, strpos($leveringMogelijk, '.')))), __LINE__);
        }
        if (is_null($leveringMogelijk) || (is_array($leveringMogelijk) && empty($leveringMogelijk))) {
            unset($this->leveringMogelijk);
        } else {
            $this->leveringMogelijk = $leveringMogelijk;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WijkCheckResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
