<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for wijkCheckRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Controleert of er een levering mogelijk is voor de uitgave/abonnementsoort/pakket op het opgegeven adres.
 * @subpackage Structs
 */
class WijkCheckRequest extends AbstractStructBase
{
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - documentation: Postcode.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $postcode;
    /**
     * The huisNummer
     * Meta informations extracted from the WSDL
     * - documentation: Huisnummer.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $huisNummer;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The uitgaveCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de uitgave waarvoor de controle moet worden uitgevoerd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 12
     * @var string
     */
    public $uitgaveCode;
    /**
     * The aboSoortCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de abonnementsoort waarvoor de controle moet worden uitgevoerd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 30
     * @var string
     */
    public $aboSoortCode;
    /**
     * The pakketCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van het pakket waarvoor de controle moet worden uitgevoerd. Als voor 1 van de onderdelen niet bezorgd kan worden dan is de uitslag negatief.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $pakketCode;
    /**
     * The propositieCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van het propositie waarvoor de controle moet worden uitgevoerd. N.B. o.b.v. propositiecode en actiecode wordt de propositie opgezocht. Als voor 1 van de onderdelen niet bezorgd kan worden dan is de uitslag negatief.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $propositieCode;
    /**
     * The actieCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van het actie waarmee de propositie opgezocht moet worden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 15
     * @var string
     */
    public $actieCode;
    /**
     * Constructor method for wijkCheckRequest
     * @uses WijkCheckRequest::setPostcode()
     * @uses WijkCheckRequest::setHuisNummer()
     * @uses WijkCheckRequest::setRequestTag()
     * @uses WijkCheckRequest::setUitgaveCode()
     * @uses WijkCheckRequest::setAboSoortCode()
     * @uses WijkCheckRequest::setPakketCode()
     * @uses WijkCheckRequest::setPropositieCode()
     * @uses WijkCheckRequest::setActieCode()
     * @param string $postcode
     * @param float $huisNummer
     * @param string $requestTag
     * @param string $uitgaveCode
     * @param string $aboSoortCode
     * @param string $pakketCode
     * @param string $propositieCode
     * @param string $actieCode
     */
    public function __construct($postcode = null, $huisNummer = null, $requestTag = null, $uitgaveCode = null, $aboSoortCode = null, $pakketCode = null, $propositieCode = null, $actieCode = null)
    {
        $this
            ->setPostcode($postcode)
            ->setHuisNummer($huisNummer)
            ->setRequestTag($requestTag)
            ->setUitgaveCode($uitgaveCode)
            ->setAboSoortCode($aboSoortCode)
            ->setPakketCode($pakketCode)
            ->setPropositieCode($propositieCode)
            ->setActieCode($actieCode);
    }
    /**
     * Get postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\WijkCheckRequest
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postcode) && strlen($postcode) > 10) || (is_array($postcode) && count($postcode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($postcode) ? strlen($postcode) : count($postcode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($postcode) && strlen($postcode) < 1) || (is_array($postcode) && count($postcode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get huisNummer value
     * @return float
     */
    public function getHuisNummer()
    {
        return $this->huisNummer;
    }
    /**
     * Set huisNummer value
     * @param float $huisNummer
     * @return \StructType\WijkCheckRequest
     */
    public function setHuisNummer($huisNummer = null)
    {
        // validation for constraint: totalDigits
        if (is_float($huisNummer) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $huisNummer)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($huisNummer, strpos($huisNummer, '.')))), __LINE__);
        }
        $this->huisNummer = $huisNummer;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\WijkCheckRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get uitgaveCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveCode()
    {
        return isset($this->uitgaveCode) ? $this->uitgaveCode : null;
    }
    /**
     * Set uitgaveCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveCode
     * @return \StructType\WijkCheckRequest
     */
    public function setUitgaveCode($uitgaveCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($uitgaveCode) && strlen($uitgaveCode) > 12) || (is_array($uitgaveCode) && count($uitgaveCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($uitgaveCode) ? strlen($uitgaveCode) : count($uitgaveCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uitgaveCode) && !is_string($uitgaveCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uitgaveCode)), __LINE__);
        }
        if (is_null($uitgaveCode) || (is_array($uitgaveCode) && empty($uitgaveCode))) {
            unset($this->uitgaveCode);
        } else {
            $this->uitgaveCode = $uitgaveCode;
        }
        return $this;
    }
    /**
     * Get aboSoortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortCode()
    {
        return isset($this->aboSoortCode) ? $this->aboSoortCode : null;
    }
    /**
     * Set aboSoortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortCode
     * @return \StructType\WijkCheckRequest
     */
    public function setAboSoortCode($aboSoortCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboSoortCode) && strlen($aboSoortCode) > 30) || (is_array($aboSoortCode) && count($aboSoortCode) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($aboSoortCode) ? strlen($aboSoortCode) : count($aboSoortCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboSoortCode) && !is_string($aboSoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboSoortCode)), __LINE__);
        }
        if (is_null($aboSoortCode) || (is_array($aboSoortCode) && empty($aboSoortCode))) {
            unset($this->aboSoortCode);
        } else {
            $this->aboSoortCode = $aboSoortCode;
        }
        return $this;
    }
    /**
     * Get pakketCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketCode()
    {
        return isset($this->pakketCode) ? $this->pakketCode : null;
    }
    /**
     * Set pakketCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketCode
     * @return \StructType\WijkCheckRequest
     */
    public function setPakketCode($pakketCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pakketCode) && strlen($pakketCode) > 20) || (is_array($pakketCode) && count($pakketCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($pakketCode) ? strlen($pakketCode) : count($pakketCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pakketCode) && !is_string($pakketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pakketCode)), __LINE__);
        }
        if (is_null($pakketCode) || (is_array($pakketCode) && empty($pakketCode))) {
            unset($this->pakketCode);
        } else {
            $this->pakketCode = $pakketCode;
        }
        return $this;
    }
    /**
     * Get propositieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPropositieCode()
    {
        return isset($this->propositieCode) ? $this->propositieCode : null;
    }
    /**
     * Set propositieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $propositieCode
     * @return \StructType\WijkCheckRequest
     */
    public function setPropositieCode($propositieCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($propositieCode) && strlen($propositieCode) > 20) || (is_array($propositieCode) && count($propositieCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($propositieCode) ? strlen($propositieCode) : count($propositieCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($propositieCode) && !is_string($propositieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propositieCode)), __LINE__);
        }
        if (is_null($propositieCode) || (is_array($propositieCode) && empty($propositieCode))) {
            unset($this->propositieCode);
        } else {
            $this->propositieCode = $propositieCode;
        }
        return $this;
    }
    /**
     * Get actieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActieCode()
    {
        return isset($this->actieCode) ? $this->actieCode : null;
    }
    /**
     * Set actieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actieCode
     * @return \StructType\WijkCheckRequest
     */
    public function setActieCode($actieCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($actieCode) && strlen($actieCode) > 15) || (is_array($actieCode) && count($actieCode) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($actieCode) ? strlen($actieCode) : count($actieCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($actieCode) && !is_string($actieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actieCode)), __LINE__);
        }
        if (is_null($actieCode) || (is_array($actieCode) && empty($actieCode))) {
            unset($this->actieCode);
        } else {
            $this->actieCode = $actieCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WijkCheckRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
