<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VrijVeldTekstV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Abosoort vrij veld tekst 1800 karakters.
 * @subpackage Structs
 */
class VrijVeldTekstV4 extends AbstractStructBase
{
    /**
     * The label
     * Meta informations extracted from the WSDL
     * - documentation: Label van het vrije veld.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 25
     * @var string
     */
    public $label;
    /**
     * The waarde
     * Meta informations extracted from the WSDL
     * - documentation: Waarde van het vrije veld.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 1800
     * @var string
     */
    public $waarde;
    /**
     * Constructor method for VrijVeldTekstV4
     * @uses VrijVeldTekstV4::setLabel()
     * @uses VrijVeldTekstV4::setWaarde()
     * @param string $label
     * @param string $waarde
     */
    public function __construct($label = null, $waarde = null)
    {
        $this
            ->setLabel($label)
            ->setWaarde($waarde);
    }
    /**
     * Get label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabel()
    {
        return isset($this->label) ? $this->label : null;
    }
    /**
     * Set label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $label
     * @return \StructType\VrijVeldTekstV4
     */
    public function setLabel($label = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($label) && strlen($label) > 25) || (is_array($label) && count($label) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($label) ? strlen($label) : count($label)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        if (is_null($label) || (is_array($label) && empty($label))) {
            unset($this->label);
        } else {
            $this->label = $label;
        }
        return $this;
    }
    /**
     * Get waarde value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWaarde()
    {
        return isset($this->waarde) ? $this->waarde : null;
    }
    /**
     * Set waarde value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $waarde
     * @return \StructType\VrijVeldTekstV4
     */
    public function setWaarde($waarde = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($waarde) && strlen($waarde) > 1800) || (is_array($waarde) && count($waarde) > 1800)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1800 element(s) or a scalar of 1800 character(s) at most, "%d" length given', is_scalar($waarde) ? strlen($waarde) : count($waarde)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($waarde) && !is_string($waarde)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($waarde)), __LINE__);
        }
        if (is_null($waarde) || (is_array($waarde) && empty($waarde))) {
            unset($this->waarde);
        } else {
            $this->waarde = $waarde;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VrijVeldTekstV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
