<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerschInfoTabV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met verschijningen.
 * @subpackage Structs
 */
class VerschInfoTabV4 extends AbstractStructBase
{
    /**
     * The verschInfo
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met verschijningen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\VerschInfoV4[]
     */
    public $verschInfo;
    /**
     * Constructor method for VerschInfoTabV4
     * @uses VerschInfoTabV4::setVerschInfo()
     * @param \StructType\VerschInfoV4[] $verschInfo
     */
    public function __construct(array $verschInfo = array())
    {
        $this
            ->setVerschInfo($verschInfo);
    }
    /**
     * Get verschInfo value
     * @return \StructType\VerschInfoV4[]|null
     */
    public function getVerschInfo()
    {
        return $this->verschInfo;
    }
    /**
     * Set verschInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\VerschInfoV4[] $verschInfo
     * @return \StructType\VerschInfoTabV4
     */
    public function setVerschInfo(array $verschInfo = array())
    {
        foreach ($verschInfo as $verschInfoTabV4VerschInfoItem) {
            // validation for constraint: itemType
            if (!$verschInfoTabV4VerschInfoItem instanceof \StructType\VerschInfoV4) {
                throw new \InvalidArgumentException(sprintf('The verschInfo property can only contain items of \StructType\VerschInfoV4, "%s" given', is_object($verschInfoTabV4VerschInfoItem) ? get_class($verschInfoTabV4VerschInfoItem) : gettype($verschInfoTabV4VerschInfoItem)), __LINE__);
            }
        }
        $this->verschInfo = $verschInfo;
        return $this;
    }
    /**
     * Add item to verschInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\VerschInfoV4 $item
     * @return \StructType\VerschInfoTabV4
     */
    public function addToVerschInfo(\StructType\VerschInfoV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VerschInfoV4) {
            throw new \InvalidArgumentException(sprintf('The verschInfo property can only contain items of \StructType\VerschInfoV4, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->verschInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerschInfoTabV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
