<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateKlantAdresRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Een klant wil een wijziging maken aan zijn adresgegevens, of een privé of correspondentieadres toevoegen. <br/><u>Let op:</u> bij wijzigingen van een bestaand abonnement dienen alle elementen opnieuw te worden meegegeven. Lege
 * elementen of niet meegegeven (groepen) elementen worden leeg gemaakt door de update.
 * @subpackage Structs
 */
class UpdateKlantAdresRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The relNo
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van de relatie waarbij het adres gewijzigd moet worden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The adresType
     * Meta informations extracted from the WSDL
     * - documentation: [B,C,P] Welk adres moet gewijzigd worden? 'B' = Bezoekadres, 'C' = Correspondentieadres, 'P' = Privéadres.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 1
     * @var string
     */
    public $adresType;
    /**
     * The adres
     * Meta informations extracted from the WSDL
     * - documentation: Te wijzigen of aan te maken adresgegevens.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdresObjectV4
     */
    public $adres;
    /**
     * The canUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen update uitgevoerd). false (Default) = updaten, true = testmodus niet updaten.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canUpdate;
    /**
     * Constructor method for updateKlantAdresRequest
     * @uses UpdateKlantAdresRequest::setRequestTag()
     * @uses UpdateKlantAdresRequest::setRelNo()
     * @uses UpdateKlantAdresRequest::setAdresType()
     * @uses UpdateKlantAdresRequest::setAdres()
     * @uses UpdateKlantAdresRequest::setCanUpdate()
     * @param string $requestTag
     * @param int $relNo
     * @param string $adresType
     * @param \StructType\AdresObjectV4 $adres
     * @param bool $canUpdate
     */
    public function __construct($requestTag = null, $relNo = null, $adresType = null, \StructType\AdresObjectV4 $adres = null, $canUpdate = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setRelNo($relNo)
            ->setAdresType($adresType)
            ->setAdres($adres)
            ->setCanUpdate($canUpdate);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\UpdateKlantAdresRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNo()
    {
        return isset($this->relNo) ? $this->relNo : null;
    }
    /**
     * Set relNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNo
     * @return \StructType\UpdateKlantAdresRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNo, strpos($relNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNo) && !is_numeric($relNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNo)), __LINE__);
        }
        if (is_null($relNo) || (is_array($relNo) && empty($relNo))) {
            unset($this->relNo);
        } else {
            $this->relNo = $relNo;
        }
        return $this;
    }
    /**
     * Get adresType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdresType()
    {
        return isset($this->adresType) ? $this->adresType : null;
    }
    /**
     * Set adresType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adresType
     * @return \StructType\UpdateKlantAdresRequest
     */
    public function setAdresType($adresType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($adresType) && strlen($adresType) > 1) || (is_array($adresType) && count($adresType) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($adresType) ? strlen($adresType) : count($adresType)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($adresType) && !is_string($adresType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adresType)), __LINE__);
        }
        if (is_null($adresType) || (is_array($adresType) && empty($adresType))) {
            unset($this->adresType);
        } else {
            $this->adresType = $adresType;
        }
        return $this;
    }
    /**
     * Get adres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdresObjectV4|null
     */
    public function getAdres()
    {
        return isset($this->adres) ? $this->adres : null;
    }
    /**
     * Set adres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AdresObjectV4 $adres
     * @return \StructType\UpdateKlantAdresRequest
     */
    public function setAdres(\StructType\AdresObjectV4 $adres = null)
    {
        if (is_null($adres) || (is_array($adres) && empty($adres))) {
            unset($this->adres);
        } else {
            $this->adres = $adres;
        }
        return $this;
    }
    /**
     * Get canUpdate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanUpdate()
    {
        return isset($this->canUpdate) ? $this->canUpdate : null;
    }
    /**
     * Set canUpdate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canUpdate
     * @return \StructType\UpdateKlantAdresRequest
     */
    public function setCanUpdate($canUpdate = null)
    {
        if (is_null($canUpdate) || (is_array($canUpdate) && empty($canUpdate))) {
            unset($this->canUpdate);
        } else {
            $this->canUpdate = $canUpdate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateKlantAdresRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
