<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateAboBetaalwijzeResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error1: Het abonnement is niet gevonden | error3: De betaalwijze is niet bekend | error4: Bij automatische incasso is een rekeningnummer verplicht | error12: Er is geen abonnement opgegeven | error26: Het opgegeven rekeningnummer
 * voldoet niet | error215: Het IBAN nummer is ongeldig | error216: De BIC code is ongeldig | error217: Bij automatische incasso of eenmalige incasso is een IBAN nummer verplicht | error218: Het IBAN nummer dient samen met de BIC code opgegeven te
 * worden | error219: De opgegeven BIC code hoort niet bij het opgegeven IBAN nummer | error264: Bij betaalwijze creditcard zijn gegevens van de creditcard verplicht
 * @subpackage Structs
 */
class UpdateAboBetaalwijzeResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The machtigingsKenmerk
     * Meta informations extracted from the WSDL
     * - documentation: Door Zeno aangemaakt machtigingskenmerk in geval van betaalwijze SEPA incasso.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 35
     * @var string
     */
    public $machtigingsKenmerk;
    /**
     * Constructor method for updateAboBetaalwijzeResponse
     * @uses UpdateAboBetaalwijzeResponse::setRequestTag()
     * @uses UpdateAboBetaalwijzeResponse::setMachtigingsKenmerk()
     * @param string $requestTag
     * @param string $machtigingsKenmerk
     */
    public function __construct($requestTag = null, $machtigingsKenmerk = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setMachtigingsKenmerk($machtigingsKenmerk);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\UpdateAboBetaalwijzeResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get machtigingsKenmerk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMachtigingsKenmerk()
    {
        return isset($this->machtigingsKenmerk) ? $this->machtigingsKenmerk : null;
    }
    /**
     * Set machtigingsKenmerk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $machtigingsKenmerk
     * @return \StructType\UpdateAboBetaalwijzeResponse
     */
    public function setMachtigingsKenmerk($machtigingsKenmerk = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($machtigingsKenmerk) && strlen($machtigingsKenmerk) > 35) || (is_array($machtigingsKenmerk) && count($machtigingsKenmerk) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($machtigingsKenmerk) ? strlen($machtigingsKenmerk) : count($machtigingsKenmerk)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($machtigingsKenmerk) && !is_string($machtigingsKenmerk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($machtigingsKenmerk)), __LINE__);
        }
        if (is_null($machtigingsKenmerk) || (is_array($machtigingsKenmerk) && empty($machtigingsKenmerk))) {
            unset($this->machtigingsKenmerk);
        } else {
            $this->machtigingsKenmerk = $machtigingsKenmerk;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateAboBetaalwijzeResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
