<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UitgaveV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Uitgave object t.b.v getUitgaveInfo.
 * @subpackage Structs
 */
class UitgaveV4 extends AbstractStructBase
{
    /**
     * The uitgaveCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de uitgave.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 12
     * @var string
     */
    public $uitgaveCode;
    /**
     * The uitgaveNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam/omschrijving van de uitgave.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $uitgaveNaam;
    /**
     * The uitgaveActief
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of de uitgave actief is of niet.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $uitgaveActief;
    /**
     * The abonnementsoorten
     * Meta informations extracted from the WSDL
     * - documentation: Lijst van 0:n abonnementsoort objecten van de abonnementsoorten bij de uitgave. Zie Abonnementsoort object. Afhankelijk van parameter.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AbonnementsoortInfoV4
     */
    public $abonnementsoorten;
    /**
     * Constructor method for UitgaveV4
     * @uses UitgaveV4::setUitgaveCode()
     * @uses UitgaveV4::setUitgaveNaam()
     * @uses UitgaveV4::setUitgaveActief()
     * @uses UitgaveV4::setAbonnementsoorten()
     * @param string $uitgaveCode
     * @param string $uitgaveNaam
     * @param bool $uitgaveActief
     * @param \StructType\AbonnementsoortInfoV4 $abonnementsoorten
     */
    public function __construct($uitgaveCode = null, $uitgaveNaam = null, $uitgaveActief = null, \StructType\AbonnementsoortInfoV4 $abonnementsoorten = null)
    {
        $this
            ->setUitgaveCode($uitgaveCode)
            ->setUitgaveNaam($uitgaveNaam)
            ->setUitgaveActief($uitgaveActief)
            ->setAbonnementsoorten($abonnementsoorten);
    }
    /**
     * Get uitgaveCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveCode()
    {
        return isset($this->uitgaveCode) ? $this->uitgaveCode : null;
    }
    /**
     * Set uitgaveCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveCode
     * @return \StructType\UitgaveV4
     */
    public function setUitgaveCode($uitgaveCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($uitgaveCode) && strlen($uitgaveCode) > 12) || (is_array($uitgaveCode) && count($uitgaveCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($uitgaveCode) ? strlen($uitgaveCode) : count($uitgaveCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uitgaveCode) && !is_string($uitgaveCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uitgaveCode)), __LINE__);
        }
        if (is_null($uitgaveCode) || (is_array($uitgaveCode) && empty($uitgaveCode))) {
            unset($this->uitgaveCode);
        } else {
            $this->uitgaveCode = $uitgaveCode;
        }
        return $this;
    }
    /**
     * Get uitgaveNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveNaam()
    {
        return isset($this->uitgaveNaam) ? $this->uitgaveNaam : null;
    }
    /**
     * Set uitgaveNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveNaam
     * @return \StructType\UitgaveV4
     */
    public function setUitgaveNaam($uitgaveNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($uitgaveNaam) && strlen($uitgaveNaam) > 120) || (is_array($uitgaveNaam) && count($uitgaveNaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($uitgaveNaam) ? strlen($uitgaveNaam) : count($uitgaveNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uitgaveNaam) && !is_string($uitgaveNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uitgaveNaam)), __LINE__);
        }
        if (is_null($uitgaveNaam) || (is_array($uitgaveNaam) && empty($uitgaveNaam))) {
            unset($this->uitgaveNaam);
        } else {
            $this->uitgaveNaam = $uitgaveNaam;
        }
        return $this;
    }
    /**
     * Get uitgaveActief value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUitgaveActief()
    {
        return isset($this->uitgaveActief) ? $this->uitgaveActief : null;
    }
    /**
     * Set uitgaveActief value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $uitgaveActief
     * @return \StructType\UitgaveV4
     */
    public function setUitgaveActief($uitgaveActief = null)
    {
        if (is_null($uitgaveActief) || (is_array($uitgaveActief) && empty($uitgaveActief))) {
            unset($this->uitgaveActief);
        } else {
            $this->uitgaveActief = $uitgaveActief;
        }
        return $this;
    }
    /**
     * Get abonnementsoorten value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AbonnementsoortInfoV4|null
     */
    public function getAbonnementsoorten()
    {
        return isset($this->abonnementsoorten) ? $this->abonnementsoorten : null;
    }
    /**
     * Set abonnementsoorten value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AbonnementsoortInfoV4 $abonnementsoorten
     * @return \StructType\UitgaveV4
     */
    public function setAbonnementsoorten(\StructType\AbonnementsoortInfoV4 $abonnementsoorten = null)
    {
        if (is_null($abonnementsoorten) || (is_array($abonnementsoorten) && empty($abonnementsoorten))) {
            unset($this->abonnementsoorten);
        } else {
            $this->abonnementsoorten = $abonnementsoorten;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UitgaveV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
