<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UitgaveInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met uitgaven.
 * @subpackage Structs
 */
class UitgaveInfoV4 extends AbstractStructBase
{
    /**
     * The uitgave
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met uitgaven.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\UitgaveV4[]
     */
    public $uitgave;
    /**
     * Constructor method for UitgaveInfoV4
     * @uses UitgaveInfoV4::setUitgave()
     * @param \StructType\UitgaveV4[] $uitgave
     */
    public function __construct(array $uitgave = array())
    {
        $this
            ->setUitgave($uitgave);
    }
    /**
     * Get uitgave value
     * @return \StructType\UitgaveV4[]|null
     */
    public function getUitgave()
    {
        return $this->uitgave;
    }
    /**
     * Set uitgave value
     * @throws \InvalidArgumentException
     * @param \StructType\UitgaveV4[] $uitgave
     * @return \StructType\UitgaveInfoV4
     */
    public function setUitgave(array $uitgave = array())
    {
        foreach ($uitgave as $uitgaveInfoV4UitgaveItem) {
            // validation for constraint: itemType
            if (!$uitgaveInfoV4UitgaveItem instanceof \StructType\UitgaveV4) {
                throw new \InvalidArgumentException(sprintf('The uitgave property can only contain items of \StructType\UitgaveV4, "%s" given', is_object($uitgaveInfoV4UitgaveItem) ? get_class($uitgaveInfoV4UitgaveItem) : gettype($uitgaveInfoV4UitgaveItem)), __LINE__);
            }
        }
        $this->uitgave = $uitgave;
        return $this;
    }
    /**
     * Add item to uitgave value
     * @throws \InvalidArgumentException
     * @param \StructType\UitgaveV4 $item
     * @return \StructType\UitgaveInfoV4
     */
    public function addToUitgave(\StructType\UitgaveV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UitgaveV4) {
            throw new \InvalidArgumentException(sprintf('The uitgave property can only contain items of \StructType\UitgaveV4, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->uitgave[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UitgaveInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
