<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ToekMutV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Gegevens met betrekking tot een toekomstige mutatie, zoals bijvoorbeeld een verhuizing of vakantie regeling.
 * @subpackage Structs
 */
class ToekMutV4 extends AbstractStructBase
{
    /**
     * The toekMutNo
     * Meta informations extracted from the WSDL
     * - documentation: Toekomstige mutatie nummer.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $toekMutNo;
    /**
     * The relNo
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The datumVan
     * Meta informations extracted from the WSDL
     * - documentation: Ingangsdatum (datum vanaf).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $datumVan;
    /**
     * The datumTm
     * Meta informations extracted from the WSDL
     * - documentation: Einddatum (datum tot en met). Indien deze leeg is, geldt de wijziging permanent voor de toekomst.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $datumTm;
    /**
     * The specifiekVoorAbonnement
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie: true geeft aan of de regeling/verhuizing specifiek voor een abonnement geldt, false of deze integraal voor de relatie geldt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $specifiekVoorAbonnement;
    /**
     * The regelingType
     * Meta informations extracted from the WSDL
     * - documentation: [0,1,2,3,4,5,6,7] Soort regeling. 0 = Verhuizing, 1 = Onderbreking + verlengen, 2 = Goed doel, 3 = Vakantie bonnen, 4 = Vakantieadres, 5 = Doorsturen naar vriend of familie, 6 = Onderbreken zonder verlenging/zonder restitutie, 7 =
     * Restitutieregeling.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 1
     * @var int
     */
    public $regelingType;
    /**
     * The abonnementSoortCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de abonnementsoort van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 30
     * @var string
     */
    public $abonnementSoortCode;
    /**
     * The abonnementSoortNaam
     * Meta informations extracted from the WSDL
     * - documentation: Omschrijving van de abonnementsoort van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 500
     * @var string
     */
    public $abonnementSoortNaam;
    /**
     * The artikelGroepCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de artikelgroep van het abonnement (N.B. => Oude product).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $artikelGroepCode;
    /**
     * The artikelGroepNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam van de artikelgroep van het abonnement (N.B. => Oude product).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $artikelGroepNaam;
    /**
     * The pakketCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van het pakket van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $pakketCode;
    /**
     * The pakketNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam van het pakket van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $pakketNaam;
    /**
     * The pakketVrijeCode1
     * Meta informations extracted from the WSDL
     * - documentation: De code van de vrije code 1 van het pakket
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $pakketVrijeCode1;
    /**
     * The pakketVrijeNaam1
     * Meta informations extracted from the WSDL
     * - documentation: De naam van de vrije code 1 van het pakket
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $pakketVrijeNaam1;
    /**
     * The persoonsObjectOntvanger
     * Meta informations extracted from the WSDL
     * - documentation: Persoonsgegevens van de relatie die de tijdelijke ontvanger is bij vakantieRegelingType 5 (doorsturen).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PersoonsObjectV4
     */
    public $persoonsObjectOntvanger;
    /**
     * The adresObjectVakantie
     * Meta informations extracted from the WSDL
     * - documentation: Adresgegevens van het tijdelijke adres, of het adres van de tijdelijke ontvanger bij vakantieRegelingType 4 (vakantieadres) en 5 (doorsturen).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdresObjectV4
     */
    public $adresObjectVakantie;
    /**
     * The tijdelijkAdres
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of de adres wijziging tijdelijk is.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $tijdelijkAdres;
    /**
     * The adresObjectBezoek
     * Meta informations extracted from the WSDL
     * - documentation: Adresgegevens van het nieuwe bezoek adres i.g.v. verhuizing.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdresObjectV4
     */
    public $adresObjectBezoek;
    /**
     * The adresObjectCorrespondentie
     * Meta informations extracted from the WSDL
     * - documentation: Adresgegevens van het nieuwe correspondentie adres i.g.v. verhuizing.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdresObjectV4
     */
    public $adresObjectCorrespondentie;
    /**
     * The adresObjectPrive
     * Meta informations extracted from the WSDL
     * - documentation: Adresgegevens van het nieuwe prive adres i.g.v. verhuizing.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdresObjectV4
     */
    public $adresObjectPrive;
    /**
     * The canDelete
     * Meta informations extracted from the WSDL
     * - documentation: Geeft aan of een toekomstige mutatie eventueel verwijderd mag worden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canDelete;
    /**
     * Constructor method for ToekMutV4
     * @uses ToekMutV4::setToekMutNo()
     * @uses ToekMutV4::setRelNo()
     * @uses ToekMutV4::setDatumVan()
     * @uses ToekMutV4::setDatumTm()
     * @uses ToekMutV4::setSpecifiekVoorAbonnement()
     * @uses ToekMutV4::setRegelingType()
     * @uses ToekMutV4::setAbonnementSoortCode()
     * @uses ToekMutV4::setAbonnementSoortNaam()
     * @uses ToekMutV4::setArtikelGroepCode()
     * @uses ToekMutV4::setArtikelGroepNaam()
     * @uses ToekMutV4::setPakketCode()
     * @uses ToekMutV4::setPakketNaam()
     * @uses ToekMutV4::setPakketVrijeCode1()
     * @uses ToekMutV4::setPakketVrijeNaam1()
     * @uses ToekMutV4::setPersoonsObjectOntvanger()
     * @uses ToekMutV4::setAdresObjectVakantie()
     * @uses ToekMutV4::setTijdelijkAdres()
     * @uses ToekMutV4::setAdresObjectBezoek()
     * @uses ToekMutV4::setAdresObjectCorrespondentie()
     * @uses ToekMutV4::setAdresObjectPrive()
     * @uses ToekMutV4::setCanDelete()
     * @param int $toekMutNo
     * @param int $relNo
     * @param string $datumVan
     * @param string $datumTm
     * @param bool $specifiekVoorAbonnement
     * @param int $regelingType
     * @param string $abonnementSoortCode
     * @param string $abonnementSoortNaam
     * @param string $artikelGroepCode
     * @param string $artikelGroepNaam
     * @param string $pakketCode
     * @param string $pakketNaam
     * @param string $pakketVrijeCode1
     * @param string $pakketVrijeNaam1
     * @param \StructType\PersoonsObjectV4 $persoonsObjectOntvanger
     * @param \StructType\AdresObjectV4 $adresObjectVakantie
     * @param bool $tijdelijkAdres
     * @param \StructType\AdresObjectV4 $adresObjectBezoek
     * @param \StructType\AdresObjectV4 $adresObjectCorrespondentie
     * @param \StructType\AdresObjectV4 $adresObjectPrive
     * @param bool $canDelete
     */
    public function __construct($toekMutNo = null, $relNo = null, $datumVan = null, $datumTm = null, $specifiekVoorAbonnement = null, $regelingType = null, $abonnementSoortCode = null, $abonnementSoortNaam = null, $artikelGroepCode = null, $artikelGroepNaam = null, $pakketCode = null, $pakketNaam = null, $pakketVrijeCode1 = null, $pakketVrijeNaam1 = null, \StructType\PersoonsObjectV4 $persoonsObjectOntvanger = null, \StructType\AdresObjectV4 $adresObjectVakantie = null, $tijdelijkAdres = null, \StructType\AdresObjectV4 $adresObjectBezoek = null, \StructType\AdresObjectV4 $adresObjectCorrespondentie = null, \StructType\AdresObjectV4 $adresObjectPrive = null, $canDelete = null)
    {
        $this
            ->setToekMutNo($toekMutNo)
            ->setRelNo($relNo)
            ->setDatumVan($datumVan)
            ->setDatumTm($datumTm)
            ->setSpecifiekVoorAbonnement($specifiekVoorAbonnement)
            ->setRegelingType($regelingType)
            ->setAbonnementSoortCode($abonnementSoortCode)
            ->setAbonnementSoortNaam($abonnementSoortNaam)
            ->setArtikelGroepCode($artikelGroepCode)
            ->setArtikelGroepNaam($artikelGroepNaam)
            ->setPakketCode($pakketCode)
            ->setPakketNaam($pakketNaam)
            ->setPakketVrijeCode1($pakketVrijeCode1)
            ->setPakketVrijeNaam1($pakketVrijeNaam1)
            ->setPersoonsObjectOntvanger($persoonsObjectOntvanger)
            ->setAdresObjectVakantie($adresObjectVakantie)
            ->setTijdelijkAdres($tijdelijkAdres)
            ->setAdresObjectBezoek($adresObjectBezoek)
            ->setAdresObjectCorrespondentie($adresObjectCorrespondentie)
            ->setAdresObjectPrive($adresObjectPrive)
            ->setCanDelete($canDelete);
    }
    /**
     * Get toekMutNo value
     * @return int
     */
    public function getToekMutNo()
    {
        return $this->toekMutNo;
    }
    /**
     * Set toekMutNo value
     * @param int $toekMutNo
     * @return \StructType\ToekMutV4
     */
    public function setToekMutNo($toekMutNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($toekMutNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $toekMutNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($toekMutNo, strpos($toekMutNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($toekMutNo) && !is_numeric($toekMutNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($toekMutNo)), __LINE__);
        }
        $this->toekMutNo = $toekMutNo;
        return $this;
    }
    /**
     * Get relNo value
     * @return int
     */
    public function getRelNo()
    {
        return $this->relNo;
    }
    /**
     * Set relNo value
     * @param int $relNo
     * @return \StructType\ToekMutV4
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNo, strpos($relNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNo) && !is_numeric($relNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNo)), __LINE__);
        }
        $this->relNo = $relNo;
        return $this;
    }
    /**
     * Get datumVan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumVan()
    {
        return isset($this->datumVan) ? $this->datumVan : null;
    }
    /**
     * Set datumVan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumVan
     * @return \StructType\ToekMutV4
     */
    public function setDatumVan($datumVan = null)
    {
        // validation for constraint: string
        if (!is_null($datumVan) && !is_string($datumVan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datumVan)), __LINE__);
        }
        if (is_null($datumVan) || (is_array($datumVan) && empty($datumVan))) {
            unset($this->datumVan);
        } else {
            $this->datumVan = $datumVan;
        }
        return $this;
    }
    /**
     * Get datumTm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumTm()
    {
        return isset($this->datumTm) ? $this->datumTm : null;
    }
    /**
     * Set datumTm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumTm
     * @return \StructType\ToekMutV4
     */
    public function setDatumTm($datumTm = null)
    {
        // validation for constraint: string
        if (!is_null($datumTm) && !is_string($datumTm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datumTm)), __LINE__);
        }
        if (is_null($datumTm) || (is_array($datumTm) && empty($datumTm))) {
            unset($this->datumTm);
        } else {
            $this->datumTm = $datumTm;
        }
        return $this;
    }
    /**
     * Get specifiekVoorAbonnement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSpecifiekVoorAbonnement()
    {
        return isset($this->specifiekVoorAbonnement) ? $this->specifiekVoorAbonnement : null;
    }
    /**
     * Set specifiekVoorAbonnement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $specifiekVoorAbonnement
     * @return \StructType\ToekMutV4
     */
    public function setSpecifiekVoorAbonnement($specifiekVoorAbonnement = null)
    {
        if (is_null($specifiekVoorAbonnement) || (is_array($specifiekVoorAbonnement) && empty($specifiekVoorAbonnement))) {
            unset($this->specifiekVoorAbonnement);
        } else {
            $this->specifiekVoorAbonnement = $specifiekVoorAbonnement;
        }
        return $this;
    }
    /**
     * Get regelingType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRegelingType()
    {
        return isset($this->regelingType) ? $this->regelingType : null;
    }
    /**
     * Set regelingType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $regelingType
     * @return \StructType\ToekMutV4
     */
    public function setRegelingType($regelingType = null)
    {
        // validation for constraint: totalDigits
        if (is_float($regelingType) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $regelingType)) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 1 digits, "%d" given', strlen(substr($regelingType, strpos($regelingType, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($regelingType) && !is_numeric($regelingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($regelingType)), __LINE__);
        }
        if (is_null($regelingType) || (is_array($regelingType) && empty($regelingType))) {
            unset($this->regelingType);
        } else {
            $this->regelingType = $regelingType;
        }
        return $this;
    }
    /**
     * Get abonnementSoortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementSoortCode()
    {
        return isset($this->abonnementSoortCode) ? $this->abonnementSoortCode : null;
    }
    /**
     * Set abonnementSoortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementSoortCode
     * @return \StructType\ToekMutV4
     */
    public function setAbonnementSoortCode($abonnementSoortCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abonnementSoortCode) && strlen($abonnementSoortCode) > 30) || (is_array($abonnementSoortCode) && count($abonnementSoortCode) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($abonnementSoortCode) ? strlen($abonnementSoortCode) : count($abonnementSoortCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abonnementSoortCode) && !is_string($abonnementSoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abonnementSoortCode)), __LINE__);
        }
        if (is_null($abonnementSoortCode) || (is_array($abonnementSoortCode) && empty($abonnementSoortCode))) {
            unset($this->abonnementSoortCode);
        } else {
            $this->abonnementSoortCode = $abonnementSoortCode;
        }
        return $this;
    }
    /**
     * Get abonnementSoortNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementSoortNaam()
    {
        return isset($this->abonnementSoortNaam) ? $this->abonnementSoortNaam : null;
    }
    /**
     * Set abonnementSoortNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementSoortNaam
     * @return \StructType\ToekMutV4
     */
    public function setAbonnementSoortNaam($abonnementSoortNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abonnementSoortNaam) && strlen($abonnementSoortNaam) > 500) || (is_array($abonnementSoortNaam) && count($abonnementSoortNaam) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($abonnementSoortNaam) ? strlen($abonnementSoortNaam) : count($abonnementSoortNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abonnementSoortNaam) && !is_string($abonnementSoortNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abonnementSoortNaam)), __LINE__);
        }
        if (is_null($abonnementSoortNaam) || (is_array($abonnementSoortNaam) && empty($abonnementSoortNaam))) {
            unset($this->abonnementSoortNaam);
        } else {
            $this->abonnementSoortNaam = $abonnementSoortNaam;
        }
        return $this;
    }
    /**
     * Get artikelGroepCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtikelGroepCode()
    {
        return isset($this->artikelGroepCode) ? $this->artikelGroepCode : null;
    }
    /**
     * Set artikelGroepCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artikelGroepCode
     * @return \StructType\ToekMutV4
     */
    public function setArtikelGroepCode($artikelGroepCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($artikelGroepCode) && strlen($artikelGroepCode) > 20) || (is_array($artikelGroepCode) && count($artikelGroepCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($artikelGroepCode) ? strlen($artikelGroepCode) : count($artikelGroepCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($artikelGroepCode) && !is_string($artikelGroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artikelGroepCode)), __LINE__);
        }
        if (is_null($artikelGroepCode) || (is_array($artikelGroepCode) && empty($artikelGroepCode))) {
            unset($this->artikelGroepCode);
        } else {
            $this->artikelGroepCode = $artikelGroepCode;
        }
        return $this;
    }
    /**
     * Get artikelGroepNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtikelGroepNaam()
    {
        return isset($this->artikelGroepNaam) ? $this->artikelGroepNaam : null;
    }
    /**
     * Set artikelGroepNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artikelGroepNaam
     * @return \StructType\ToekMutV4
     */
    public function setArtikelGroepNaam($artikelGroepNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($artikelGroepNaam) && strlen($artikelGroepNaam) > 120) || (is_array($artikelGroepNaam) && count($artikelGroepNaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($artikelGroepNaam) ? strlen($artikelGroepNaam) : count($artikelGroepNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($artikelGroepNaam) && !is_string($artikelGroepNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artikelGroepNaam)), __LINE__);
        }
        if (is_null($artikelGroepNaam) || (is_array($artikelGroepNaam) && empty($artikelGroepNaam))) {
            unset($this->artikelGroepNaam);
        } else {
            $this->artikelGroepNaam = $artikelGroepNaam;
        }
        return $this;
    }
    /**
     * Get pakketCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketCode()
    {
        return isset($this->pakketCode) ? $this->pakketCode : null;
    }
    /**
     * Set pakketCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketCode
     * @return \StructType\ToekMutV4
     */
    public function setPakketCode($pakketCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pakketCode) && strlen($pakketCode) > 20) || (is_array($pakketCode) && count($pakketCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($pakketCode) ? strlen($pakketCode) : count($pakketCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pakketCode) && !is_string($pakketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pakketCode)), __LINE__);
        }
        if (is_null($pakketCode) || (is_array($pakketCode) && empty($pakketCode))) {
            unset($this->pakketCode);
        } else {
            $this->pakketCode = $pakketCode;
        }
        return $this;
    }
    /**
     * Get pakketNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketNaam()
    {
        return isset($this->pakketNaam) ? $this->pakketNaam : null;
    }
    /**
     * Set pakketNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketNaam
     * @return \StructType\ToekMutV4
     */
    public function setPakketNaam($pakketNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pakketNaam) && strlen($pakketNaam) > 120) || (is_array($pakketNaam) && count($pakketNaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($pakketNaam) ? strlen($pakketNaam) : count($pakketNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pakketNaam) && !is_string($pakketNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pakketNaam)), __LINE__);
        }
        if (is_null($pakketNaam) || (is_array($pakketNaam) && empty($pakketNaam))) {
            unset($this->pakketNaam);
        } else {
            $this->pakketNaam = $pakketNaam;
        }
        return $this;
    }
    /**
     * Get pakketVrijeCode1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketVrijeCode1()
    {
        return isset($this->pakketVrijeCode1) ? $this->pakketVrijeCode1 : null;
    }
    /**
     * Set pakketVrijeCode1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketVrijeCode1
     * @return \StructType\ToekMutV4
     */
    public function setPakketVrijeCode1($pakketVrijeCode1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pakketVrijeCode1) && strlen($pakketVrijeCode1) > 20) || (is_array($pakketVrijeCode1) && count($pakketVrijeCode1) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($pakketVrijeCode1) ? strlen($pakketVrijeCode1) : count($pakketVrijeCode1)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pakketVrijeCode1) && !is_string($pakketVrijeCode1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pakketVrijeCode1)), __LINE__);
        }
        if (is_null($pakketVrijeCode1) || (is_array($pakketVrijeCode1) && empty($pakketVrijeCode1))) {
            unset($this->pakketVrijeCode1);
        } else {
            $this->pakketVrijeCode1 = $pakketVrijeCode1;
        }
        return $this;
    }
    /**
     * Get pakketVrijeNaam1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketVrijeNaam1()
    {
        return isset($this->pakketVrijeNaam1) ? $this->pakketVrijeNaam1 : null;
    }
    /**
     * Set pakketVrijeNaam1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketVrijeNaam1
     * @return \StructType\ToekMutV4
     */
    public function setPakketVrijeNaam1($pakketVrijeNaam1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pakketVrijeNaam1) && strlen($pakketVrijeNaam1) > 120) || (is_array($pakketVrijeNaam1) && count($pakketVrijeNaam1) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($pakketVrijeNaam1) ? strlen($pakketVrijeNaam1) : count($pakketVrijeNaam1)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pakketVrijeNaam1) && !is_string($pakketVrijeNaam1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pakketVrijeNaam1)), __LINE__);
        }
        if (is_null($pakketVrijeNaam1) || (is_array($pakketVrijeNaam1) && empty($pakketVrijeNaam1))) {
            unset($this->pakketVrijeNaam1);
        } else {
            $this->pakketVrijeNaam1 = $pakketVrijeNaam1;
        }
        return $this;
    }
    /**
     * Get persoonsObjectOntvanger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PersoonsObjectV4|null
     */
    public function getPersoonsObjectOntvanger()
    {
        return isset($this->persoonsObjectOntvanger) ? $this->persoonsObjectOntvanger : null;
    }
    /**
     * Set persoonsObjectOntvanger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PersoonsObjectV4 $persoonsObjectOntvanger
     * @return \StructType\ToekMutV4
     */
    public function setPersoonsObjectOntvanger(\StructType\PersoonsObjectV4 $persoonsObjectOntvanger = null)
    {
        if (is_null($persoonsObjectOntvanger) || (is_array($persoonsObjectOntvanger) && empty($persoonsObjectOntvanger))) {
            unset($this->persoonsObjectOntvanger);
        } else {
            $this->persoonsObjectOntvanger = $persoonsObjectOntvanger;
        }
        return $this;
    }
    /**
     * Get adresObjectVakantie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdresObjectV4|null
     */
    public function getAdresObjectVakantie()
    {
        return isset($this->adresObjectVakantie) ? $this->adresObjectVakantie : null;
    }
    /**
     * Set adresObjectVakantie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AdresObjectV4 $adresObjectVakantie
     * @return \StructType\ToekMutV4
     */
    public function setAdresObjectVakantie(\StructType\AdresObjectV4 $adresObjectVakantie = null)
    {
        if (is_null($adresObjectVakantie) || (is_array($adresObjectVakantie) && empty($adresObjectVakantie))) {
            unset($this->adresObjectVakantie);
        } else {
            $this->adresObjectVakantie = $adresObjectVakantie;
        }
        return $this;
    }
    /**
     * Get tijdelijkAdres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getTijdelijkAdres()
    {
        return isset($this->tijdelijkAdres) ? $this->tijdelijkAdres : null;
    }
    /**
     * Set tijdelijkAdres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $tijdelijkAdres
     * @return \StructType\ToekMutV4
     */
    public function setTijdelijkAdres($tijdelijkAdres = null)
    {
        if (is_null($tijdelijkAdres) || (is_array($tijdelijkAdres) && empty($tijdelijkAdres))) {
            unset($this->tijdelijkAdres);
        } else {
            $this->tijdelijkAdres = $tijdelijkAdres;
        }
        return $this;
    }
    /**
     * Get adresObjectBezoek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdresObjectV4|null
     */
    public function getAdresObjectBezoek()
    {
        return isset($this->adresObjectBezoek) ? $this->adresObjectBezoek : null;
    }
    /**
     * Set adresObjectBezoek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AdresObjectV4 $adresObjectBezoek
     * @return \StructType\ToekMutV4
     */
    public function setAdresObjectBezoek(\StructType\AdresObjectV4 $adresObjectBezoek = null)
    {
        if (is_null($adresObjectBezoek) || (is_array($adresObjectBezoek) && empty($adresObjectBezoek))) {
            unset($this->adresObjectBezoek);
        } else {
            $this->adresObjectBezoek = $adresObjectBezoek;
        }
        return $this;
    }
    /**
     * Get adresObjectCorrespondentie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdresObjectV4|null
     */
    public function getAdresObjectCorrespondentie()
    {
        return isset($this->adresObjectCorrespondentie) ? $this->adresObjectCorrespondentie : null;
    }
    /**
     * Set adresObjectCorrespondentie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AdresObjectV4 $adresObjectCorrespondentie
     * @return \StructType\ToekMutV4
     */
    public function setAdresObjectCorrespondentie(\StructType\AdresObjectV4 $adresObjectCorrespondentie = null)
    {
        if (is_null($adresObjectCorrespondentie) || (is_array($adresObjectCorrespondentie) && empty($adresObjectCorrespondentie))) {
            unset($this->adresObjectCorrespondentie);
        } else {
            $this->adresObjectCorrespondentie = $adresObjectCorrespondentie;
        }
        return $this;
    }
    /**
     * Get adresObjectPrive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdresObjectV4|null
     */
    public function getAdresObjectPrive()
    {
        return isset($this->adresObjectPrive) ? $this->adresObjectPrive : null;
    }
    /**
     * Set adresObjectPrive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AdresObjectV4 $adresObjectPrive
     * @return \StructType\ToekMutV4
     */
    public function setAdresObjectPrive(\StructType\AdresObjectV4 $adresObjectPrive = null)
    {
        if (is_null($adresObjectPrive) || (is_array($adresObjectPrive) && empty($adresObjectPrive))) {
            unset($this->adresObjectPrive);
        } else {
            $this->adresObjectPrive = $adresObjectPrive;
        }
        return $this;
    }
    /**
     * Get canDelete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanDelete()
    {
        return isset($this->canDelete) ? $this->canDelete : null;
    }
    /**
     * Set canDelete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canDelete
     * @return \StructType\ToekMutV4
     */
    public function setCanDelete($canDelete = null)
    {
        if (is_null($canDelete) || (is_array($canDelete) && empty($canDelete))) {
            unset($this->canDelete);
        } else {
            $this->canDelete = $canDelete;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ToekMutV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
