<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for switchAbonnementRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Een bestaand abonnement omzetten (switchen) naar een andere abonnementsvorm.
 * @subpackage Structs
 */
class SwitchAbonnementRequest extends AbstractStructBase
{
    /**
     * The aboNo
     * Meta informations extracted from the WSDL
     * - documentation: Abonnementnummer van het abonnement dat omgezet moet worden.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The aboObject
     * Meta informations extracted from the WSDL
     * - documentation: Gegevens van het nieuwe abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AboObjectV4
     */
    public $aboObject;
    /**
     * The aboStopReden
     * Meta informations extracted from the WSDL
     * - documentation: Reden waarom huidige abonnement wordt gestopt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 15
     * @var string
     */
    public $aboStopReden;
    /**
     * The aboAdmKosten
     * Meta informations extracted from the WSDL
     * - documentation: Administratiekosten die in rekening worden gebracht (future support).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $aboAdmKosten;
    /**
     * The aboFactuurOnderdrukken
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie geen factuur (false=Wel factuur, true=Geen factuur).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $aboFactuurOnderdrukken;
    /**
     * The aboSwitchEindePeriode
     * Meta informations extracted from the WSDL
     * - documentation: [0,1,2] Switch pas toepassen aan het einde van het huidige abonnement of per opgegeven aboIngangsDatum (0=per ingangsdatum, 1=per einde gefactureerde periode, 2=per einde contract).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $aboSwitchEindePeriode;
    /**
     * The geenControleLopendAbo
     * Meta informations extracted from the WSDL
     * - documentation: Controle actief abonnement niet uitvoeren voor deze aanvraag (false=Nee/true=Ja, default false dus wel uitvoeren).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $geenControleLopendAbo;
    /**
     * The canSwitch
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen switch uitgevoerd) false (Default) = switchen, true = testmodus niet switchen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canSwitch;
    /**
     * Constructor method for switchAbonnementRequest
     * @uses SwitchAbonnementRequest::setAboNo()
     * @uses SwitchAbonnementRequest::setRequestTag()
     * @uses SwitchAbonnementRequest::setAboObject()
     * @uses SwitchAbonnementRequest::setAboStopReden()
     * @uses SwitchAbonnementRequest::setAboAdmKosten()
     * @uses SwitchAbonnementRequest::setAboFactuurOnderdrukken()
     * @uses SwitchAbonnementRequest::setAboSwitchEindePeriode()
     * @uses SwitchAbonnementRequest::setGeenControleLopendAbo()
     * @uses SwitchAbonnementRequest::setCanSwitch()
     * @param int $aboNo
     * @param string $requestTag
     * @param \StructType\AboObjectV4 $aboObject
     * @param string $aboStopReden
     * @param float $aboAdmKosten
     * @param bool $aboFactuurOnderdrukken
     * @param float $aboSwitchEindePeriode
     * @param bool $geenControleLopendAbo
     * @param bool $canSwitch
     */
    public function __construct($aboNo = null, $requestTag = null, \StructType\AboObjectV4 $aboObject = null, $aboStopReden = null, $aboAdmKosten = null, $aboFactuurOnderdrukken = null, $aboSwitchEindePeriode = null, $geenControleLopendAbo = null, $canSwitch = null)
    {
        $this
            ->setAboNo($aboNo)
            ->setRequestTag($requestTag)
            ->setAboObject($aboObject)
            ->setAboStopReden($aboStopReden)
            ->setAboAdmKosten($aboAdmKosten)
            ->setAboFactuurOnderdrukken($aboFactuurOnderdrukken)
            ->setAboSwitchEindePeriode($aboSwitchEindePeriode)
            ->setGeenControleLopendAbo($geenControleLopendAbo)
            ->setCanSwitch($canSwitch);
    }
    /**
     * Get aboNo value
     * @return int
     */
    public function getAboNo()
    {
        return $this->aboNo;
    }
    /**
     * Set aboNo value
     * @param int $aboNo
     * @return \StructType\SwitchAbonnementRequest
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($aboNo, strpos($aboNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($aboNo) && !is_numeric($aboNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aboNo)), __LINE__);
        }
        $this->aboNo = $aboNo;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\SwitchAbonnementRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get aboObject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AboObjectV4|null
     */
    public function getAboObject()
    {
        return isset($this->aboObject) ? $this->aboObject : null;
    }
    /**
     * Set aboObject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AboObjectV4 $aboObject
     * @return \StructType\SwitchAbonnementRequest
     */
    public function setAboObject(\StructType\AboObjectV4 $aboObject = null)
    {
        if (is_null($aboObject) || (is_array($aboObject) && empty($aboObject))) {
            unset($this->aboObject);
        } else {
            $this->aboObject = $aboObject;
        }
        return $this;
    }
    /**
     * Get aboStopReden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboStopReden()
    {
        return isset($this->aboStopReden) ? $this->aboStopReden : null;
    }
    /**
     * Set aboStopReden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboStopReden
     * @return \StructType\SwitchAbonnementRequest
     */
    public function setAboStopReden($aboStopReden = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboStopReden) && strlen($aboStopReden) > 15) || (is_array($aboStopReden) && count($aboStopReden) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($aboStopReden) ? strlen($aboStopReden) : count($aboStopReden)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboStopReden) && !is_string($aboStopReden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboStopReden)), __LINE__);
        }
        if (is_null($aboStopReden) || (is_array($aboStopReden) && empty($aboStopReden))) {
            unset($this->aboStopReden);
        } else {
            $this->aboStopReden = $aboStopReden;
        }
        return $this;
    }
    /**
     * Get aboAdmKosten value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAboAdmKosten()
    {
        return isset($this->aboAdmKosten) ? $this->aboAdmKosten : null;
    }
    /**
     * Set aboAdmKosten value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aboAdmKosten
     * @return \StructType\SwitchAbonnementRequest
     */
    public function setAboAdmKosten($aboAdmKosten = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboAdmKosten) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboAdmKosten)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($aboAdmKosten, strpos($aboAdmKosten, '.')))), __LINE__);
        }
        if (is_null($aboAdmKosten) || (is_array($aboAdmKosten) && empty($aboAdmKosten))) {
            unset($this->aboAdmKosten);
        } else {
            $this->aboAdmKosten = $aboAdmKosten;
        }
        return $this;
    }
    /**
     * Get aboFactuurOnderdrukken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAboFactuurOnderdrukken()
    {
        return isset($this->aboFactuurOnderdrukken) ? $this->aboFactuurOnderdrukken : null;
    }
    /**
     * Set aboFactuurOnderdrukken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $aboFactuurOnderdrukken
     * @return \StructType\SwitchAbonnementRequest
     */
    public function setAboFactuurOnderdrukken($aboFactuurOnderdrukken = null)
    {
        if (is_null($aboFactuurOnderdrukken) || (is_array($aboFactuurOnderdrukken) && empty($aboFactuurOnderdrukken))) {
            unset($this->aboFactuurOnderdrukken);
        } else {
            $this->aboFactuurOnderdrukken = $aboFactuurOnderdrukken;
        }
        return $this;
    }
    /**
     * Get aboSwitchEindePeriode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAboSwitchEindePeriode()
    {
        return isset($this->aboSwitchEindePeriode) ? $this->aboSwitchEindePeriode : null;
    }
    /**
     * Set aboSwitchEindePeriode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aboSwitchEindePeriode
     * @return \StructType\SwitchAbonnementRequest
     */
    public function setAboSwitchEindePeriode($aboSwitchEindePeriode = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboSwitchEindePeriode) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboSwitchEindePeriode)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($aboSwitchEindePeriode, strpos($aboSwitchEindePeriode, '.')))), __LINE__);
        }
        if (is_null($aboSwitchEindePeriode) || (is_array($aboSwitchEindePeriode) && empty($aboSwitchEindePeriode))) {
            unset($this->aboSwitchEindePeriode);
        } else {
            $this->aboSwitchEindePeriode = $aboSwitchEindePeriode;
        }
        return $this;
    }
    /**
     * Get geenControleLopendAbo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGeenControleLopendAbo()
    {
        return isset($this->geenControleLopendAbo) ? $this->geenControleLopendAbo : null;
    }
    /**
     * Set geenControleLopendAbo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $geenControleLopendAbo
     * @return \StructType\SwitchAbonnementRequest
     */
    public function setGeenControleLopendAbo($geenControleLopendAbo = null)
    {
        if (is_null($geenControleLopendAbo) || (is_array($geenControleLopendAbo) && empty($geenControleLopendAbo))) {
            unset($this->geenControleLopendAbo);
        } else {
            $this->geenControleLopendAbo = $geenControleLopendAbo;
        }
        return $this;
    }
    /**
     * Get canSwitch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanSwitch()
    {
        return isset($this->canSwitch) ? $this->canSwitch : null;
    }
    /**
     * Set canSwitch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canSwitch
     * @return \StructType\SwitchAbonnementRequest
     */
    public function setCanSwitch($canSwitch = null)
    {
        if (is_null($canSwitch) || (is_array($canSwitch) && empty($canSwitch))) {
            unset($this->canSwitch);
        } else {
            $this->canSwitch = $canSwitch;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SwitchAbonnementRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
