<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for stopGratisAboPerDirectRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Stopt een abonnement per direct. Bedoelt om abonnementen op een nieuwsbrief of online toegang te stoppen.<br /> Mag aangeroepen worden met ofwel aboNo, ofwel met een relNo, een uitgaveCode en evt. een abosoortCode.<br /><br />
 * Voorwaarden: <ul><li>Looptijd van een abonnement is opgegeven in maanden of jaren, of edities en is ingericht met 365 edities per jaar</li> <li>Abonnementsoort is gratis</li></ul><br /> Abonnement wordt stopgezet per de datum van gisteren. Als de
 * startdatum van het abonnement gelijk is aan de datum van vandaag, wordt het abonnement per vandaag gestopt en wordt 'verzendstop' aangezet.<br />
 * @subpackage Structs
 */
class StopGratisAboPerDirectRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The aboNo
     * Meta informations extracted from the WSDL
     * - documentation: Het abonnementnummer van het te stoppen abonnement. Als dit is ingevuld, moeten de argumenten relNo, uitgaveCode en abosoortCode leeg zijn
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The relNo
     * Meta informations extracted from the WSDL
     * - documentation: Een relatienummer. Mag alleen gebruikt worden in combinatie met de argumenten uitgaveCode en abosoortCode
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The uitgaveCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van een uitgave. Verplicht als relNo is ingevuld.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 12
     * @var string
     */
    public $uitgaveCode;
    /**
     * The abosoortCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van een abonnementsoort. Optioneel bij opgave van een relNo en een uitgaveCode
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 30
     * @var string
     */
    public $abosoortCode;
    /**
     * The stopReden
     * Meta informations extracted from the WSDL
     * - documentation: De stopreden die bij het stoppen van het abonnement genoteerd moet worden. Kan verplicht zijn, afhankelijk van de inrichting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 15
     * @var string
     */
    public $stopReden;
    /**
     * Constructor method for stopGratisAboPerDirectRequest
     * @uses StopGratisAboPerDirectRequest::setRequestTag()
     * @uses StopGratisAboPerDirectRequest::setAboNo()
     * @uses StopGratisAboPerDirectRequest::setRelNo()
     * @uses StopGratisAboPerDirectRequest::setUitgaveCode()
     * @uses StopGratisAboPerDirectRequest::setAbosoortCode()
     * @uses StopGratisAboPerDirectRequest::setStopReden()
     * @param string $requestTag
     * @param int $aboNo
     * @param int $relNo
     * @param string $uitgaveCode
     * @param string $abosoortCode
     * @param string $stopReden
     */
    public function __construct($requestTag = null, $aboNo = null, $relNo = null, $uitgaveCode = null, $abosoortCode = null, $stopReden = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setAboNo($aboNo)
            ->setRelNo($relNo)
            ->setUitgaveCode($uitgaveCode)
            ->setAbosoortCode($abosoortCode)
            ->setStopReden($stopReden);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\StopGratisAboPerDirectRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get aboNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboNo()
    {
        return isset($this->aboNo) ? $this->aboNo : null;
    }
    /**
     * Set aboNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboNo
     * @return \StructType\StopGratisAboPerDirectRequest
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($aboNo, strpos($aboNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($aboNo) && !is_numeric($aboNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aboNo)), __LINE__);
        }
        if (is_null($aboNo) || (is_array($aboNo) && empty($aboNo))) {
            unset($this->aboNo);
        } else {
            $this->aboNo = $aboNo;
        }
        return $this;
    }
    /**
     * Get relNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNo()
    {
        return isset($this->relNo) ? $this->relNo : null;
    }
    /**
     * Set relNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNo
     * @return \StructType\StopGratisAboPerDirectRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNo, strpos($relNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNo) && !is_numeric($relNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNo)), __LINE__);
        }
        if (is_null($relNo) || (is_array($relNo) && empty($relNo))) {
            unset($this->relNo);
        } else {
            $this->relNo = $relNo;
        }
        return $this;
    }
    /**
     * Get uitgaveCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveCode()
    {
        return isset($this->uitgaveCode) ? $this->uitgaveCode : null;
    }
    /**
     * Set uitgaveCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveCode
     * @return \StructType\StopGratisAboPerDirectRequest
     */
    public function setUitgaveCode($uitgaveCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($uitgaveCode) && strlen($uitgaveCode) > 12) || (is_array($uitgaveCode) && count($uitgaveCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($uitgaveCode) ? strlen($uitgaveCode) : count($uitgaveCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uitgaveCode) && !is_string($uitgaveCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uitgaveCode)), __LINE__);
        }
        if (is_null($uitgaveCode) || (is_array($uitgaveCode) && empty($uitgaveCode))) {
            unset($this->uitgaveCode);
        } else {
            $this->uitgaveCode = $uitgaveCode;
        }
        return $this;
    }
    /**
     * Get abosoortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbosoortCode()
    {
        return isset($this->abosoortCode) ? $this->abosoortCode : null;
    }
    /**
     * Set abosoortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abosoortCode
     * @return \StructType\StopGratisAboPerDirectRequest
     */
    public function setAbosoortCode($abosoortCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abosoortCode) && strlen($abosoortCode) > 30) || (is_array($abosoortCode) && count($abosoortCode) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($abosoortCode) ? strlen($abosoortCode) : count($abosoortCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abosoortCode) && !is_string($abosoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abosoortCode)), __LINE__);
        }
        if (is_null($abosoortCode) || (is_array($abosoortCode) && empty($abosoortCode))) {
            unset($this->abosoortCode);
        } else {
            $this->abosoortCode = $abosoortCode;
        }
        return $this;
    }
    /**
     * Get stopReden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStopReden()
    {
        return isset($this->stopReden) ? $this->stopReden : null;
    }
    /**
     * Set stopReden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stopReden
     * @return \StructType\StopGratisAboPerDirectRequest
     */
    public function setStopReden($stopReden = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($stopReden) && strlen($stopReden) > 15) || (is_array($stopReden) && count($stopReden) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($stopReden) ? strlen($stopReden) : count($stopReden)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($stopReden) && !is_string($stopReden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stopReden)), __LINE__);
        }
        if (is_null($stopReden) || (is_array($stopReden) && empty($stopReden))) {
            unset($this->stopReden);
        } else {
            $this->stopReden = $stopReden;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopGratisAboPerDirectRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
