<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchSmartcodeRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Geeft het aboneementnummer terug van het abonnement behorende bij de smartcode.
 * @subpackage Structs
 */
class SearchSmartcodeRequest extends AbstractStructBase
{
    /**
     * The smartcode
     * Meta informations extracted from the WSDL
     * - documentation: De smartcode die gezocht moet worden.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $smartcode;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for searchSmartcodeRequest
     * @uses SearchSmartcodeRequest::setSmartcode()
     * @uses SearchSmartcodeRequest::setRequestTag()
     * @param string $smartcode
     * @param string $requestTag
     */
    public function __construct($smartcode = null, $requestTag = null)
    {
        $this
            ->setSmartcode($smartcode)
            ->setRequestTag($requestTag);
    }
    /**
     * Get smartcode value
     * @return string
     */
    public function getSmartcode()
    {
        return $this->smartcode;
    }
    /**
     * Set smartcode value
     * @param string $smartcode
     * @return \StructType\SearchSmartcodeRequest
     */
    public function setSmartcode($smartcode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($smartcode) && strlen($smartcode) > 4000) || (is_array($smartcode) && count($smartcode) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($smartcode) ? strlen($smartcode) : count($smartcode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($smartcode) && strlen($smartcode) < 1) || (is_array($smartcode) && count($smartcode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($smartcode) && !is_string($smartcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($smartcode)), __LINE__);
        }
        $this->smartcode = $smartcode;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\SearchSmartcodeRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchSmartcodeRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
