<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchAbonnementByCredRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Geeft een lijst met abonnementen op die gelden voor de opgegeven userName en password combinatie.
 * @subpackage Structs
 */
class SearchAbonnementByCredRequest extends AbstractStructBase
{
    /**
     * The userName
     * Meta informations extracted from the WSDL
     * - documentation: Gebruikersnaam.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - documentation: Wachtwoord.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $password;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The toonAbonnementen
     * Meta informations extracted from the WSDL
     * - documentation: [0,1,2] Welk type abonnementen moet worden getoond 0=Alleen gewone (default) 1=Alleen licentie 2=Alle abonnementen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $toonAbonnementen;
    /**
     * Constructor method for searchAbonnementByCredRequest
     * @uses SearchAbonnementByCredRequest::setUserName()
     * @uses SearchAbonnementByCredRequest::setPassword()
     * @uses SearchAbonnementByCredRequest::setRequestTag()
     * @uses SearchAbonnementByCredRequest::setToonAbonnementen()
     * @param string $userName
     * @param string $password
     * @param string $requestTag
     * @param float $toonAbonnementen
     */
    public function __construct($userName = null, $password = null, $requestTag = null, $toonAbonnementen = null)
    {
        $this
            ->setUserName($userName)
            ->setPassword($password)
            ->setRequestTag($requestTag)
            ->setToonAbonnementen($toonAbonnementen);
    }
    /**
     * Get userName value
     * @return string
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \StructType\SearchAbonnementByCredRequest
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($userName) && strlen($userName) > 100) || (is_array($userName) && count($userName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($userName) ? strlen($userName) : count($userName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($userName) && strlen($userName) < 1) || (is_array($userName) && count($userName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\SearchAbonnementByCredRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($password) && strlen($password) > 100) || (is_array($password) && count($password) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($password) ? strlen($password) : count($password)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($password) && strlen($password) < 1) || (is_array($password) && count($password) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\SearchAbonnementByCredRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get toonAbonnementen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getToonAbonnementen()
    {
        return isset($this->toonAbonnementen) ? $this->toonAbonnementen : null;
    }
    /**
     * Set toonAbonnementen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $toonAbonnementen
     * @return \StructType\SearchAbonnementByCredRequest
     */
    public function setToonAbonnementen($toonAbonnementen = null)
    {
        // validation for constraint: totalDigits
        if (is_float($toonAbonnementen) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $toonAbonnementen)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($toonAbonnementen, strpos($toonAbonnementen, '.')))), __LINE__);
        }
        if (is_null($toonAbonnementen) || (is_array($toonAbonnementen) && empty($toonAbonnementen))) {
            unset($this->toonAbonnementen);
        } else {
            $this->toonAbonnementen = $toonAbonnementen;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchAbonnementByCredRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
