<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropositiesV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Proposities object.
 * @subpackage Structs
 */
class PropositiesV4 extends AbstractStructBase
{
    /**
     * The actieNummer
     * Meta informations extracted from the WSDL
     * - documentation: Het unieke nummer van de actie.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $actieNummer;
    /**
     * The actieCode
     * Meta informations extracted from the WSDL
     * - documentation: De code van de actie.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $actieCode;
    /**
     * The actieNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam/omschrijving van de actie.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 120
     * - minLength: 1
     * @var string
     */
    public $actieNaam;
    /**
     * The propositieNummer
     * Meta informations extracted from the WSDL
     * - documentation: Het unieke nummer van de propositie.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $propositieNummer;
    /**
     * The propositieCode
     * Meta informations extracted from the WSDL
     * - documentation: De code van de propositie.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $propositieCode;
    /**
     * The propositieNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam/omschrijving van de propositie.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 120
     * - minLength: 1
     * @var string
     */
    public $propositieNaam;
    /**
     * The uitgaveNummer
     * Meta informations extracted from the WSDL
     * - documentation: Het unieke nummer van de uitgave.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $uitgaveNummer;
    /**
     * The uitgaveCode
     * Meta informations extracted from the WSDL
     * - documentation: De code van de uitgave.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 12
     * @var string
     */
    public $uitgaveCode;
    /**
     * The uitgaveNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam/omschrivjing van de propositie.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $uitgaveNaam;
    /**
     * The abonnementsoortNummer
     * Meta informations extracted from the WSDL
     * - documentation: Het unieke nummer van de abonnementsoort. Alleen gevuld indien de propositie voor een abosoort geldt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $abonnementsoortNummer;
    /**
     * The abonnementsoortCode
     * Meta informations extracted from the WSDL
     * - documentation: De code van de abonnementsoort. Alleen gevuld indien de propositie voor een abosoort geldt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 30
     * @var string
     */
    public $abonnementsoortCode;
    /**
     * The abonnementsoortNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam/omschrijving van de abonnementsoort. Alleen gevuld indien de propositie voor een abosoort geldt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 500
     * @var string
     */
    public $abonnementsoortNaam;
    /**
     * The betaalwijze
     * Meta informations extracted from the WSDL
     * - documentation: Betaalwijze van de abonnementsoort. (0= Geen voorkeur, 1= Bij voorkeur aut. incasso, 2= Verplicht aut. incasso)
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $betaalwijze;
    /**
     * The abonnementsoortPrijsExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: (Basis-) prijs voor de abonnementsoort excl. BTW. Alleen gevuld indien de propositie voor een abosoort geldt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $abonnementsoortPrijsExclBtw;
    /**
     * The abonnementsoortPrijsInclBtw
     * Meta informations extracted from the WSDL
     * - documentation: (Basis-) prijs voor de abonnementsoort incl. BTW. Alleen gevuld indien de propositie voor een abosoort geldt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $abonnementsoortPrijsInclBtw;
    /**
     * The pakketNummer
     * Meta informations extracted from the WSDL
     * - documentation: Het unieke nummer van het pakket. Alleen gevuld indien de propositie voor een pakket geldt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $pakketNummer;
    /**
     * The pakketCode
     * Meta informations extracted from the WSDL
     * - documentation: De code van het pakket. Alleen gevuld indien de propositie voor een pakket geldt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $pakketCode;
    /**
     * The pakketNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam/omschrijving van het pakket. Alleen gevuld indien de propositie voor een pakket geldt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $pakketNaam;
    /**
     * The pakketPrijsExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: (Basis-) prijs van het pakket excl. BTW. Alleen gevuld indien de propositie voor een pakket geldt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $pakketPrijsExclBtw;
    /**
     * The pakketPrijsInclBtw
     * Meta informations extracted from the WSDL
     * - documentation: (Basis-) prijs van het pakket incl. BTW. Alleen gevuld indien de propositie voor een pakket geldt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $pakketPrijsInclBtw;
    /**
     * The propositiePremiums
     * Meta informations extracted from the WSDL
     * - documentation: Een lijst met de gevonden premiums bij de propositie. Zie PropositiePremiums.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PropositiePremiumsTabV4
     */
    public $propositiePremiums;
    /**
     * The prijsPropositieInclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Propositieprijs Prijs voor de hele propositie gelden voor eerste factuur/contractperiode.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $prijsPropositieInclBtw;
    /**
     * The kortingTekst
     * Meta informations extracted from the WSDL
     * - documentation: Kortingtekst bij de propositieprijs.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $kortingTekst;
    /**
     * The prijs1ePeriodeExcl
     * Meta informations extracted from the WSDL
     * - documentation: Prijs voor de abonnementsoort excl. BTW voor de 1e periode (i.v.m. eventuele korting van de actie).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $prijs1ePeriodeExcl;
    /**
     * The prijs1ePeriodeIncl
     * Meta informations extracted from the WSDL
     * - documentation: Prijs voor de abonnementsoort incl. BTW voor de 1e periode (i.v.m. eventuele korting van de actie).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $prijs1ePeriodeIncl;
    /**
     * The actieHerkomstcode
     * Meta informations extracted from the WSDL
     * - documentation: Herkomst code die bij de actie is ingesteld.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $actieHerkomstcode;
    /**
     * The actieHerkomstnaam
     * Meta informations extracted from the WSDL
     * - documentation: Herkomst omschrijving die bij de actie is ingesteld.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $actieHerkomstnaam;
    /**
     * Constructor method for PropositiesV4
     * @uses PropositiesV4::setActieNummer()
     * @uses PropositiesV4::setActieCode()
     * @uses PropositiesV4::setActieNaam()
     * @uses PropositiesV4::setPropositieNummer()
     * @uses PropositiesV4::setPropositieCode()
     * @uses PropositiesV4::setPropositieNaam()
     * @uses PropositiesV4::setUitgaveNummer()
     * @uses PropositiesV4::setUitgaveCode()
     * @uses PropositiesV4::setUitgaveNaam()
     * @uses PropositiesV4::setAbonnementsoortNummer()
     * @uses PropositiesV4::setAbonnementsoortCode()
     * @uses PropositiesV4::setAbonnementsoortNaam()
     * @uses PropositiesV4::setBetaalwijze()
     * @uses PropositiesV4::setAbonnementsoortPrijsExclBtw()
     * @uses PropositiesV4::setAbonnementsoortPrijsInclBtw()
     * @uses PropositiesV4::setPakketNummer()
     * @uses PropositiesV4::setPakketCode()
     * @uses PropositiesV4::setPakketNaam()
     * @uses PropositiesV4::setPakketPrijsExclBtw()
     * @uses PropositiesV4::setPakketPrijsInclBtw()
     * @uses PropositiesV4::setPropositiePremiums()
     * @uses PropositiesV4::setPrijsPropositieInclBtw()
     * @uses PropositiesV4::setKortingTekst()
     * @uses PropositiesV4::setPrijs1ePeriodeExcl()
     * @uses PropositiesV4::setPrijs1ePeriodeIncl()
     * @uses PropositiesV4::setActieHerkomstcode()
     * @uses PropositiesV4::setActieHerkomstnaam()
     * @param int $actieNummer
     * @param string $actieCode
     * @param string $actieNaam
     * @param int $propositieNummer
     * @param string $propositieCode
     * @param string $propositieNaam
     * @param int $uitgaveNummer
     * @param string $uitgaveCode
     * @param string $uitgaveNaam
     * @param int $abonnementsoortNummer
     * @param string $abonnementsoortCode
     * @param string $abonnementsoortNaam
     * @param float $betaalwijze
     * @param float $abonnementsoortPrijsExclBtw
     * @param float $abonnementsoortPrijsInclBtw
     * @param int $pakketNummer
     * @param string $pakketCode
     * @param string $pakketNaam
     * @param float $pakketPrijsExclBtw
     * @param float $pakketPrijsInclBtw
     * @param \StructType\PropositiePremiumsTabV4 $propositiePremiums
     * @param float $prijsPropositieInclBtw
     * @param string $kortingTekst
     * @param float $prijs1ePeriodeExcl
     * @param float $prijs1ePeriodeIncl
     * @param string $actieHerkomstcode
     * @param string $actieHerkomstnaam
     */
    public function __construct($actieNummer = null, $actieCode = null, $actieNaam = null, $propositieNummer = null, $propositieCode = null, $propositieNaam = null, $uitgaveNummer = null, $uitgaveCode = null, $uitgaveNaam = null, $abonnementsoortNummer = null, $abonnementsoortCode = null, $abonnementsoortNaam = null, $betaalwijze = null, $abonnementsoortPrijsExclBtw = null, $abonnementsoortPrijsInclBtw = null, $pakketNummer = null, $pakketCode = null, $pakketNaam = null, $pakketPrijsExclBtw = null, $pakketPrijsInclBtw = null, \StructType\PropositiePremiumsTabV4 $propositiePremiums = null, $prijsPropositieInclBtw = null, $kortingTekst = null, $prijs1ePeriodeExcl = null, $prijs1ePeriodeIncl = null, $actieHerkomstcode = null, $actieHerkomstnaam = null)
    {
        $this
            ->setActieNummer($actieNummer)
            ->setActieCode($actieCode)
            ->setActieNaam($actieNaam)
            ->setPropositieNummer($propositieNummer)
            ->setPropositieCode($propositieCode)
            ->setPropositieNaam($propositieNaam)
            ->setUitgaveNummer($uitgaveNummer)
            ->setUitgaveCode($uitgaveCode)
            ->setUitgaveNaam($uitgaveNaam)
            ->setAbonnementsoortNummer($abonnementsoortNummer)
            ->setAbonnementsoortCode($abonnementsoortCode)
            ->setAbonnementsoortNaam($abonnementsoortNaam)
            ->setBetaalwijze($betaalwijze)
            ->setAbonnementsoortPrijsExclBtw($abonnementsoortPrijsExclBtw)
            ->setAbonnementsoortPrijsInclBtw($abonnementsoortPrijsInclBtw)
            ->setPakketNummer($pakketNummer)
            ->setPakketCode($pakketCode)
            ->setPakketNaam($pakketNaam)
            ->setPakketPrijsExclBtw($pakketPrijsExclBtw)
            ->setPakketPrijsInclBtw($pakketPrijsInclBtw)
            ->setPropositiePremiums($propositiePremiums)
            ->setPrijsPropositieInclBtw($prijsPropositieInclBtw)
            ->setKortingTekst($kortingTekst)
            ->setPrijs1ePeriodeExcl($prijs1ePeriodeExcl)
            ->setPrijs1ePeriodeIncl($prijs1ePeriodeIncl)
            ->setActieHerkomstcode($actieHerkomstcode)
            ->setActieHerkomstnaam($actieHerkomstnaam);
    }
    /**
     * Get actieNummer value
     * @return int
     */
    public function getActieNummer()
    {
        return $this->actieNummer;
    }
    /**
     * Set actieNummer value
     * @param int $actieNummer
     * @return \StructType\PropositiesV4
     */
    public function setActieNummer($actieNummer = null)
    {
        // validation for constraint: totalDigits
        if (is_float($actieNummer) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $actieNummer)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($actieNummer, strpos($actieNummer, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($actieNummer) && !is_numeric($actieNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($actieNummer)), __LINE__);
        }
        $this->actieNummer = $actieNummer;
        return $this;
    }
    /**
     * Get actieCode value
     * @return string
     */
    public function getActieCode()
    {
        return $this->actieCode;
    }
    /**
     * Set actieCode value
     * @param string $actieCode
     * @return \StructType\PropositiesV4
     */
    public function setActieCode($actieCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($actieCode) && strlen($actieCode) > 20) || (is_array($actieCode) && count($actieCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($actieCode) ? strlen($actieCode) : count($actieCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($actieCode) && strlen($actieCode) < 1) || (is_array($actieCode) && count($actieCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($actieCode) && !is_string($actieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actieCode)), __LINE__);
        }
        $this->actieCode = $actieCode;
        return $this;
    }
    /**
     * Get actieNaam value
     * @return string
     */
    public function getActieNaam()
    {
        return $this->actieNaam;
    }
    /**
     * Set actieNaam value
     * @param string $actieNaam
     * @return \StructType\PropositiesV4
     */
    public function setActieNaam($actieNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($actieNaam) && strlen($actieNaam) > 120) || (is_array($actieNaam) && count($actieNaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($actieNaam) ? strlen($actieNaam) : count($actieNaam)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($actieNaam) && strlen($actieNaam) < 1) || (is_array($actieNaam) && count($actieNaam) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($actieNaam) && !is_string($actieNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actieNaam)), __LINE__);
        }
        $this->actieNaam = $actieNaam;
        return $this;
    }
    /**
     * Get propositieNummer value
     * @return int
     */
    public function getPropositieNummer()
    {
        return $this->propositieNummer;
    }
    /**
     * Set propositieNummer value
     * @param int $propositieNummer
     * @return \StructType\PropositiesV4
     */
    public function setPropositieNummer($propositieNummer = null)
    {
        // validation for constraint: totalDigits
        if (is_float($propositieNummer) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $propositieNummer)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($propositieNummer, strpos($propositieNummer, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($propositieNummer) && !is_numeric($propositieNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($propositieNummer)), __LINE__);
        }
        $this->propositieNummer = $propositieNummer;
        return $this;
    }
    /**
     * Get propositieCode value
     * @return string
     */
    public function getPropositieCode()
    {
        return $this->propositieCode;
    }
    /**
     * Set propositieCode value
     * @param string $propositieCode
     * @return \StructType\PropositiesV4
     */
    public function setPropositieCode($propositieCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($propositieCode) && strlen($propositieCode) > 20) || (is_array($propositieCode) && count($propositieCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($propositieCode) ? strlen($propositieCode) : count($propositieCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($propositieCode) && strlen($propositieCode) < 1) || (is_array($propositieCode) && count($propositieCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($propositieCode) && !is_string($propositieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propositieCode)), __LINE__);
        }
        $this->propositieCode = $propositieCode;
        return $this;
    }
    /**
     * Get propositieNaam value
     * @return string
     */
    public function getPropositieNaam()
    {
        return $this->propositieNaam;
    }
    /**
     * Set propositieNaam value
     * @param string $propositieNaam
     * @return \StructType\PropositiesV4
     */
    public function setPropositieNaam($propositieNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($propositieNaam) && strlen($propositieNaam) > 120) || (is_array($propositieNaam) && count($propositieNaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($propositieNaam) ? strlen($propositieNaam) : count($propositieNaam)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($propositieNaam) && strlen($propositieNaam) < 1) || (is_array($propositieNaam) && count($propositieNaam) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($propositieNaam) && !is_string($propositieNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propositieNaam)), __LINE__);
        }
        $this->propositieNaam = $propositieNaam;
        return $this;
    }
    /**
     * Get uitgaveNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUitgaveNummer()
    {
        return isset($this->uitgaveNummer) ? $this->uitgaveNummer : null;
    }
    /**
     * Set uitgaveNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $uitgaveNummer
     * @return \StructType\PropositiesV4
     */
    public function setUitgaveNummer($uitgaveNummer = null)
    {
        // validation for constraint: totalDigits
        if (is_float($uitgaveNummer) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $uitgaveNummer)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($uitgaveNummer, strpos($uitgaveNummer, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($uitgaveNummer) && !is_numeric($uitgaveNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uitgaveNummer)), __LINE__);
        }
        if (is_null($uitgaveNummer) || (is_array($uitgaveNummer) && empty($uitgaveNummer))) {
            unset($this->uitgaveNummer);
        } else {
            $this->uitgaveNummer = $uitgaveNummer;
        }
        return $this;
    }
    /**
     * Get uitgaveCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveCode()
    {
        return isset($this->uitgaveCode) ? $this->uitgaveCode : null;
    }
    /**
     * Set uitgaveCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveCode
     * @return \StructType\PropositiesV4
     */
    public function setUitgaveCode($uitgaveCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($uitgaveCode) && strlen($uitgaveCode) > 12) || (is_array($uitgaveCode) && count($uitgaveCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($uitgaveCode) ? strlen($uitgaveCode) : count($uitgaveCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uitgaveCode) && !is_string($uitgaveCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uitgaveCode)), __LINE__);
        }
        if (is_null($uitgaveCode) || (is_array($uitgaveCode) && empty($uitgaveCode))) {
            unset($this->uitgaveCode);
        } else {
            $this->uitgaveCode = $uitgaveCode;
        }
        return $this;
    }
    /**
     * Get uitgaveNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveNaam()
    {
        return isset($this->uitgaveNaam) ? $this->uitgaveNaam : null;
    }
    /**
     * Set uitgaveNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveNaam
     * @return \StructType\PropositiesV4
     */
    public function setUitgaveNaam($uitgaveNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($uitgaveNaam) && strlen($uitgaveNaam) > 120) || (is_array($uitgaveNaam) && count($uitgaveNaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($uitgaveNaam) ? strlen($uitgaveNaam) : count($uitgaveNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uitgaveNaam) && !is_string($uitgaveNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uitgaveNaam)), __LINE__);
        }
        if (is_null($uitgaveNaam) || (is_array($uitgaveNaam) && empty($uitgaveNaam))) {
            unset($this->uitgaveNaam);
        } else {
            $this->uitgaveNaam = $uitgaveNaam;
        }
        return $this;
    }
    /**
     * Get abonnementsoortNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAbonnementsoortNummer()
    {
        return isset($this->abonnementsoortNummer) ? $this->abonnementsoortNummer : null;
    }
    /**
     * Set abonnementsoortNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $abonnementsoortNummer
     * @return \StructType\PropositiesV4
     */
    public function setAbonnementsoortNummer($abonnementsoortNummer = null)
    {
        // validation for constraint: totalDigits
        if (is_float($abonnementsoortNummer) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $abonnementsoortNummer)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($abonnementsoortNummer, strpos($abonnementsoortNummer, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($abonnementsoortNummer) && !is_numeric($abonnementsoortNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($abonnementsoortNummer)), __LINE__);
        }
        if (is_null($abonnementsoortNummer) || (is_array($abonnementsoortNummer) && empty($abonnementsoortNummer))) {
            unset($this->abonnementsoortNummer);
        } else {
            $this->abonnementsoortNummer = $abonnementsoortNummer;
        }
        return $this;
    }
    /**
     * Get abonnementsoortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementsoortCode()
    {
        return isset($this->abonnementsoortCode) ? $this->abonnementsoortCode : null;
    }
    /**
     * Set abonnementsoortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementsoortCode
     * @return \StructType\PropositiesV4
     */
    public function setAbonnementsoortCode($abonnementsoortCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abonnementsoortCode) && strlen($abonnementsoortCode) > 30) || (is_array($abonnementsoortCode) && count($abonnementsoortCode) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($abonnementsoortCode) ? strlen($abonnementsoortCode) : count($abonnementsoortCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abonnementsoortCode) && !is_string($abonnementsoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abonnementsoortCode)), __LINE__);
        }
        if (is_null($abonnementsoortCode) || (is_array($abonnementsoortCode) && empty($abonnementsoortCode))) {
            unset($this->abonnementsoortCode);
        } else {
            $this->abonnementsoortCode = $abonnementsoortCode;
        }
        return $this;
    }
    /**
     * Get abonnementsoortNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementsoortNaam()
    {
        return isset($this->abonnementsoortNaam) ? $this->abonnementsoortNaam : null;
    }
    /**
     * Set abonnementsoortNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementsoortNaam
     * @return \StructType\PropositiesV4
     */
    public function setAbonnementsoortNaam($abonnementsoortNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abonnementsoortNaam) && strlen($abonnementsoortNaam) > 500) || (is_array($abonnementsoortNaam) && count($abonnementsoortNaam) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($abonnementsoortNaam) ? strlen($abonnementsoortNaam) : count($abonnementsoortNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abonnementsoortNaam) && !is_string($abonnementsoortNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abonnementsoortNaam)), __LINE__);
        }
        if (is_null($abonnementsoortNaam) || (is_array($abonnementsoortNaam) && empty($abonnementsoortNaam))) {
            unset($this->abonnementsoortNaam);
        } else {
            $this->abonnementsoortNaam = $abonnementsoortNaam;
        }
        return $this;
    }
    /**
     * Get betaalwijze value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBetaalwijze()
    {
        return isset($this->betaalwijze) ? $this->betaalwijze : null;
    }
    /**
     * Set betaalwijze value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $betaalwijze
     * @return \StructType\PropositiesV4
     */
    public function setBetaalwijze($betaalwijze = null)
    {
        // validation for constraint: totalDigits
        if (is_float($betaalwijze) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $betaalwijze)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($betaalwijze, strpos($betaalwijze, '.')))), __LINE__);
        }
        if (is_null($betaalwijze) || (is_array($betaalwijze) && empty($betaalwijze))) {
            unset($this->betaalwijze);
        } else {
            $this->betaalwijze = $betaalwijze;
        }
        return $this;
    }
    /**
     * Get abonnementsoortPrijsExclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAbonnementsoortPrijsExclBtw()
    {
        return isset($this->abonnementsoortPrijsExclBtw) ? $this->abonnementsoortPrijsExclBtw : null;
    }
    /**
     * Set abonnementsoortPrijsExclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $abonnementsoortPrijsExclBtw
     * @return \StructType\PropositiesV4
     */
    public function setAbonnementsoortPrijsExclBtw($abonnementsoortPrijsExclBtw = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($abonnementsoortPrijsExclBtw) && strlen(substr($abonnementsoortPrijsExclBtw, strpos($abonnementsoortPrijsExclBtw, '.'))) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($abonnementsoortPrijsExclBtw, strpos($abonnementsoortPrijsExclBtw, '.')))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($abonnementsoortPrijsExclBtw) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $abonnementsoortPrijsExclBtw)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($abonnementsoortPrijsExclBtw, strpos($abonnementsoortPrijsExclBtw, '.')))), __LINE__);
        }
        if (is_null($abonnementsoortPrijsExclBtw) || (is_array($abonnementsoortPrijsExclBtw) && empty($abonnementsoortPrijsExclBtw))) {
            unset($this->abonnementsoortPrijsExclBtw);
        } else {
            $this->abonnementsoortPrijsExclBtw = $abonnementsoortPrijsExclBtw;
        }
        return $this;
    }
    /**
     * Get abonnementsoortPrijsInclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAbonnementsoortPrijsInclBtw()
    {
        return isset($this->abonnementsoortPrijsInclBtw) ? $this->abonnementsoortPrijsInclBtw : null;
    }
    /**
     * Set abonnementsoortPrijsInclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $abonnementsoortPrijsInclBtw
     * @return \StructType\PropositiesV4
     */
    public function setAbonnementsoortPrijsInclBtw($abonnementsoortPrijsInclBtw = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($abonnementsoortPrijsInclBtw) && strlen(substr($abonnementsoortPrijsInclBtw, strpos($abonnementsoortPrijsInclBtw, '.'))) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($abonnementsoortPrijsInclBtw, strpos($abonnementsoortPrijsInclBtw, '.')))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($abonnementsoortPrijsInclBtw) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $abonnementsoortPrijsInclBtw)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($abonnementsoortPrijsInclBtw, strpos($abonnementsoortPrijsInclBtw, '.')))), __LINE__);
        }
        if (is_null($abonnementsoortPrijsInclBtw) || (is_array($abonnementsoortPrijsInclBtw) && empty($abonnementsoortPrijsInclBtw))) {
            unset($this->abonnementsoortPrijsInclBtw);
        } else {
            $this->abonnementsoortPrijsInclBtw = $abonnementsoortPrijsInclBtw;
        }
        return $this;
    }
    /**
     * Get pakketNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPakketNummer()
    {
        return isset($this->pakketNummer) ? $this->pakketNummer : null;
    }
    /**
     * Set pakketNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pakketNummer
     * @return \StructType\PropositiesV4
     */
    public function setPakketNummer($pakketNummer = null)
    {
        // validation for constraint: totalDigits
        if (is_float($pakketNummer) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $pakketNummer)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($pakketNummer, strpos($pakketNummer, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($pakketNummer) && !is_numeric($pakketNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pakketNummer)), __LINE__);
        }
        if (is_null($pakketNummer) || (is_array($pakketNummer) && empty($pakketNummer))) {
            unset($this->pakketNummer);
        } else {
            $this->pakketNummer = $pakketNummer;
        }
        return $this;
    }
    /**
     * Get pakketCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketCode()
    {
        return isset($this->pakketCode) ? $this->pakketCode : null;
    }
    /**
     * Set pakketCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketCode
     * @return \StructType\PropositiesV4
     */
    public function setPakketCode($pakketCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pakketCode) && strlen($pakketCode) > 20) || (is_array($pakketCode) && count($pakketCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($pakketCode) ? strlen($pakketCode) : count($pakketCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pakketCode) && !is_string($pakketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pakketCode)), __LINE__);
        }
        if (is_null($pakketCode) || (is_array($pakketCode) && empty($pakketCode))) {
            unset($this->pakketCode);
        } else {
            $this->pakketCode = $pakketCode;
        }
        return $this;
    }
    /**
     * Get pakketNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketNaam()
    {
        return isset($this->pakketNaam) ? $this->pakketNaam : null;
    }
    /**
     * Set pakketNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketNaam
     * @return \StructType\PropositiesV4
     */
    public function setPakketNaam($pakketNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pakketNaam) && strlen($pakketNaam) > 120) || (is_array($pakketNaam) && count($pakketNaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($pakketNaam) ? strlen($pakketNaam) : count($pakketNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pakketNaam) && !is_string($pakketNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pakketNaam)), __LINE__);
        }
        if (is_null($pakketNaam) || (is_array($pakketNaam) && empty($pakketNaam))) {
            unset($this->pakketNaam);
        } else {
            $this->pakketNaam = $pakketNaam;
        }
        return $this;
    }
    /**
     * Get pakketPrijsExclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPakketPrijsExclBtw()
    {
        return isset($this->pakketPrijsExclBtw) ? $this->pakketPrijsExclBtw : null;
    }
    /**
     * Set pakketPrijsExclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pakketPrijsExclBtw
     * @return \StructType\PropositiesV4
     */
    public function setPakketPrijsExclBtw($pakketPrijsExclBtw = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($pakketPrijsExclBtw) && strlen(substr($pakketPrijsExclBtw, strpos($pakketPrijsExclBtw, '.'))) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($pakketPrijsExclBtw, strpos($pakketPrijsExclBtw, '.')))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($pakketPrijsExclBtw) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $pakketPrijsExclBtw)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($pakketPrijsExclBtw, strpos($pakketPrijsExclBtw, '.')))), __LINE__);
        }
        if (is_null($pakketPrijsExclBtw) || (is_array($pakketPrijsExclBtw) && empty($pakketPrijsExclBtw))) {
            unset($this->pakketPrijsExclBtw);
        } else {
            $this->pakketPrijsExclBtw = $pakketPrijsExclBtw;
        }
        return $this;
    }
    /**
     * Get pakketPrijsInclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPakketPrijsInclBtw()
    {
        return isset($this->pakketPrijsInclBtw) ? $this->pakketPrijsInclBtw : null;
    }
    /**
     * Set pakketPrijsInclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pakketPrijsInclBtw
     * @return \StructType\PropositiesV4
     */
    public function setPakketPrijsInclBtw($pakketPrijsInclBtw = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($pakketPrijsInclBtw) && strlen(substr($pakketPrijsInclBtw, strpos($pakketPrijsInclBtw, '.'))) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($pakketPrijsInclBtw, strpos($pakketPrijsInclBtw, '.')))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($pakketPrijsInclBtw) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $pakketPrijsInclBtw)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($pakketPrijsInclBtw, strpos($pakketPrijsInclBtw, '.')))), __LINE__);
        }
        if (is_null($pakketPrijsInclBtw) || (is_array($pakketPrijsInclBtw) && empty($pakketPrijsInclBtw))) {
            unset($this->pakketPrijsInclBtw);
        } else {
            $this->pakketPrijsInclBtw = $pakketPrijsInclBtw;
        }
        return $this;
    }
    /**
     * Get propositiePremiums value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PropositiePremiumsTabV4|null
     */
    public function getPropositiePremiums()
    {
        return isset($this->propositiePremiums) ? $this->propositiePremiums : null;
    }
    /**
     * Set propositiePremiums value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PropositiePremiumsTabV4 $propositiePremiums
     * @return \StructType\PropositiesV4
     */
    public function setPropositiePremiums(\StructType\PropositiePremiumsTabV4 $propositiePremiums = null)
    {
        if (is_null($propositiePremiums) || (is_array($propositiePremiums) && empty($propositiePremiums))) {
            unset($this->propositiePremiums);
        } else {
            $this->propositiePremiums = $propositiePremiums;
        }
        return $this;
    }
    /**
     * Get prijsPropositieInclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijsPropositieInclBtw()
    {
        return isset($this->prijsPropositieInclBtw) ? $this->prijsPropositieInclBtw : null;
    }
    /**
     * Set prijsPropositieInclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijsPropositieInclBtw
     * @return \StructType\PropositiesV4
     */
    public function setPrijsPropositieInclBtw($prijsPropositieInclBtw = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($prijsPropositieInclBtw) && strlen(substr($prijsPropositieInclBtw, strpos($prijsPropositieInclBtw, '.'))) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($prijsPropositieInclBtw, strpos($prijsPropositieInclBtw, '.')))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($prijsPropositieInclBtw) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $prijsPropositieInclBtw)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($prijsPropositieInclBtw, strpos($prijsPropositieInclBtw, '.')))), __LINE__);
        }
        if (is_null($prijsPropositieInclBtw) || (is_array($prijsPropositieInclBtw) && empty($prijsPropositieInclBtw))) {
            unset($this->prijsPropositieInclBtw);
        } else {
            $this->prijsPropositieInclBtw = $prijsPropositieInclBtw;
        }
        return $this;
    }
    /**
     * Get kortingTekst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKortingTekst()
    {
        return isset($this->kortingTekst) ? $this->kortingTekst : null;
    }
    /**
     * Set kortingTekst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kortingTekst
     * @return \StructType\PropositiesV4
     */
    public function setKortingTekst($kortingTekst = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($kortingTekst) && strlen($kortingTekst) > 4000) || (is_array($kortingTekst) && count($kortingTekst) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($kortingTekst) ? strlen($kortingTekst) : count($kortingTekst)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kortingTekst) && !is_string($kortingTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kortingTekst)), __LINE__);
        }
        if (is_null($kortingTekst) || (is_array($kortingTekst) && empty($kortingTekst))) {
            unset($this->kortingTekst);
        } else {
            $this->kortingTekst = $kortingTekst;
        }
        return $this;
    }
    /**
     * Get prijs1ePeriodeExcl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijs1ePeriodeExcl()
    {
        return isset($this->prijs1ePeriodeExcl) ? $this->prijs1ePeriodeExcl : null;
    }
    /**
     * Set prijs1ePeriodeExcl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijs1ePeriodeExcl
     * @return \StructType\PropositiesV4
     */
    public function setPrijs1ePeriodeExcl($prijs1ePeriodeExcl = null)
    {
        // validation for constraint: totalDigits
        if (is_float($prijs1ePeriodeExcl) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $prijs1ePeriodeExcl)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($prijs1ePeriodeExcl, strpos($prijs1ePeriodeExcl, '.')))), __LINE__);
        }
        if (is_null($prijs1ePeriodeExcl) || (is_array($prijs1ePeriodeExcl) && empty($prijs1ePeriodeExcl))) {
            unset($this->prijs1ePeriodeExcl);
        } else {
            $this->prijs1ePeriodeExcl = $prijs1ePeriodeExcl;
        }
        return $this;
    }
    /**
     * Get prijs1ePeriodeIncl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijs1ePeriodeIncl()
    {
        return isset($this->prijs1ePeriodeIncl) ? $this->prijs1ePeriodeIncl : null;
    }
    /**
     * Set prijs1ePeriodeIncl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijs1ePeriodeIncl
     * @return \StructType\PropositiesV4
     */
    public function setPrijs1ePeriodeIncl($prijs1ePeriodeIncl = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($prijs1ePeriodeIncl) && strlen(substr($prijs1ePeriodeIncl, strpos($prijs1ePeriodeIncl, '.'))) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($prijs1ePeriodeIncl, strpos($prijs1ePeriodeIncl, '.')))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($prijs1ePeriodeIncl) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $prijs1ePeriodeIncl)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($prijs1ePeriodeIncl, strpos($prijs1ePeriodeIncl, '.')))), __LINE__);
        }
        if (is_null($prijs1ePeriodeIncl) || (is_array($prijs1ePeriodeIncl) && empty($prijs1ePeriodeIncl))) {
            unset($this->prijs1ePeriodeIncl);
        } else {
            $this->prijs1ePeriodeIncl = $prijs1ePeriodeIncl;
        }
        return $this;
    }
    /**
     * Get actieHerkomstcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActieHerkomstcode()
    {
        return isset($this->actieHerkomstcode) ? $this->actieHerkomstcode : null;
    }
    /**
     * Set actieHerkomstcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actieHerkomstcode
     * @return \StructType\PropositiesV4
     */
    public function setActieHerkomstcode($actieHerkomstcode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($actieHerkomstcode) && strlen($actieHerkomstcode) > 20) || (is_array($actieHerkomstcode) && count($actieHerkomstcode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($actieHerkomstcode) ? strlen($actieHerkomstcode) : count($actieHerkomstcode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($actieHerkomstcode) && !is_string($actieHerkomstcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actieHerkomstcode)), __LINE__);
        }
        if (is_null($actieHerkomstcode) || (is_array($actieHerkomstcode) && empty($actieHerkomstcode))) {
            unset($this->actieHerkomstcode);
        } else {
            $this->actieHerkomstcode = $actieHerkomstcode;
        }
        return $this;
    }
    /**
     * Get actieHerkomstnaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActieHerkomstnaam()
    {
        return isset($this->actieHerkomstnaam) ? $this->actieHerkomstnaam : null;
    }
    /**
     * Set actieHerkomstnaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actieHerkomstnaam
     * @return \StructType\PropositiesV4
     */
    public function setActieHerkomstnaam($actieHerkomstnaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($actieHerkomstnaam) && strlen($actieHerkomstnaam) > 120) || (is_array($actieHerkomstnaam) && count($actieHerkomstnaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($actieHerkomstnaam) ? strlen($actieHerkomstnaam) : count($actieHerkomstnaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($actieHerkomstnaam) && !is_string($actieHerkomstnaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actieHerkomstnaam)), __LINE__);
        }
        if (is_null($actieHerkomstnaam) || (is_array($actieHerkomstnaam) && empty($actieHerkomstnaam))) {
            unset($this->actieHerkomstnaam);
        } else {
            $this->actieHerkomstnaam = $actieHerkomstnaam;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PropositiesV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
