<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropositiePremiumsV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: PropositiePremiums object.
 * @subpackage Structs
 */
class PropositiePremiumsV4 extends AbstractStructBase
{
    /**
     * The artikelNummer
     * Meta informations extracted from the WSDL
     * - documentation: Het unieke nummer van de propositiePremium.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $artikelNummer;
    /**
     * The artikelCode
     * Meta informations extracted from the WSDL
     * - documentation: De code van de propositiePremium.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $artikelCode;
    /**
     * The artikelNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam/omschrijving van de propositiePremium.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 500
     * - minLength: 1
     * @var string
     */
    public $artikelNaam;
    /**
     * The artikelVerkoopprijsExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: De verkoopprijs (excl. BTW).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $artikelVerkoopprijsExclBtw;
    /**
     * The artikelVerkoopprijsInclBtw
     * Meta informations extracted from the WSDL
     * - documentation: De verkoopprijs (incl. BTW).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $artikelVerkoopprijsInclBtw;
    /**
     * Constructor method for PropositiePremiumsV4
     * @uses PropositiePremiumsV4::setArtikelNummer()
     * @uses PropositiePremiumsV4::setArtikelCode()
     * @uses PropositiePremiumsV4::setArtikelNaam()
     * @uses PropositiePremiumsV4::setArtikelVerkoopprijsExclBtw()
     * @uses PropositiePremiumsV4::setArtikelVerkoopprijsInclBtw()
     * @param int $artikelNummer
     * @param string $artikelCode
     * @param string $artikelNaam
     * @param float $artikelVerkoopprijsExclBtw
     * @param float $artikelVerkoopprijsInclBtw
     */
    public function __construct($artikelNummer = null, $artikelCode = null, $artikelNaam = null, $artikelVerkoopprijsExclBtw = null, $artikelVerkoopprijsInclBtw = null)
    {
        $this
            ->setArtikelNummer($artikelNummer)
            ->setArtikelCode($artikelCode)
            ->setArtikelNaam($artikelNaam)
            ->setArtikelVerkoopprijsExclBtw($artikelVerkoopprijsExclBtw)
            ->setArtikelVerkoopprijsInclBtw($artikelVerkoopprijsInclBtw);
    }
    /**
     * Get artikelNummer value
     * @return int
     */
    public function getArtikelNummer()
    {
        return $this->artikelNummer;
    }
    /**
     * Set artikelNummer value
     * @param int $artikelNummer
     * @return \StructType\PropositiePremiumsV4
     */
    public function setArtikelNummer($artikelNummer = null)
    {
        // validation for constraint: totalDigits
        if (is_float($artikelNummer) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $artikelNummer)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($artikelNummer, strpos($artikelNummer, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($artikelNummer) && !is_numeric($artikelNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($artikelNummer)), __LINE__);
        }
        $this->artikelNummer = $artikelNummer;
        return $this;
    }
    /**
     * Get artikelCode value
     * @return string
     */
    public function getArtikelCode()
    {
        return $this->artikelCode;
    }
    /**
     * Set artikelCode value
     * @param string $artikelCode
     * @return \StructType\PropositiePremiumsV4
     */
    public function setArtikelCode($artikelCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($artikelCode) && strlen($artikelCode) > 30) || (is_array($artikelCode) && count($artikelCode) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($artikelCode) ? strlen($artikelCode) : count($artikelCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($artikelCode) && strlen($artikelCode) < 1) || (is_array($artikelCode) && count($artikelCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($artikelCode) && !is_string($artikelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artikelCode)), __LINE__);
        }
        $this->artikelCode = $artikelCode;
        return $this;
    }
    /**
     * Get artikelNaam value
     * @return string
     */
    public function getArtikelNaam()
    {
        return $this->artikelNaam;
    }
    /**
     * Set artikelNaam value
     * @param string $artikelNaam
     * @return \StructType\PropositiePremiumsV4
     */
    public function setArtikelNaam($artikelNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($artikelNaam) && strlen($artikelNaam) > 500) || (is_array($artikelNaam) && count($artikelNaam) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($artikelNaam) ? strlen($artikelNaam) : count($artikelNaam)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($artikelNaam) && strlen($artikelNaam) < 1) || (is_array($artikelNaam) && count($artikelNaam) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($artikelNaam) && !is_string($artikelNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artikelNaam)), __LINE__);
        }
        $this->artikelNaam = $artikelNaam;
        return $this;
    }
    /**
     * Get artikelVerkoopprijsExclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getArtikelVerkoopprijsExclBtw()
    {
        return isset($this->artikelVerkoopprijsExclBtw) ? $this->artikelVerkoopprijsExclBtw : null;
    }
    /**
     * Set artikelVerkoopprijsExclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $artikelVerkoopprijsExclBtw
     * @return \StructType\PropositiePremiumsV4
     */
    public function setArtikelVerkoopprijsExclBtw($artikelVerkoopprijsExclBtw = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($artikelVerkoopprijsExclBtw) && strlen(substr($artikelVerkoopprijsExclBtw, strpos($artikelVerkoopprijsExclBtw, '.'))) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($artikelVerkoopprijsExclBtw, strpos($artikelVerkoopprijsExclBtw, '.')))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($artikelVerkoopprijsExclBtw) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $artikelVerkoopprijsExclBtw)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($artikelVerkoopprijsExclBtw, strpos($artikelVerkoopprijsExclBtw, '.')))), __LINE__);
        }
        if (is_null($artikelVerkoopprijsExclBtw) || (is_array($artikelVerkoopprijsExclBtw) && empty($artikelVerkoopprijsExclBtw))) {
            unset($this->artikelVerkoopprijsExclBtw);
        } else {
            $this->artikelVerkoopprijsExclBtw = $artikelVerkoopprijsExclBtw;
        }
        return $this;
    }
    /**
     * Get artikelVerkoopprijsInclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getArtikelVerkoopprijsInclBtw()
    {
        return isset($this->artikelVerkoopprijsInclBtw) ? $this->artikelVerkoopprijsInclBtw : null;
    }
    /**
     * Set artikelVerkoopprijsInclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $artikelVerkoopprijsInclBtw
     * @return \StructType\PropositiePremiumsV4
     */
    public function setArtikelVerkoopprijsInclBtw($artikelVerkoopprijsInclBtw = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($artikelVerkoopprijsInclBtw) && strlen(substr($artikelVerkoopprijsInclBtw, strpos($artikelVerkoopprijsInclBtw, '.'))) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($artikelVerkoopprijsInclBtw, strpos($artikelVerkoopprijsInclBtw, '.')))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($artikelVerkoopprijsInclBtw) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $artikelVerkoopprijsInclBtw)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($artikelVerkoopprijsInclBtw, strpos($artikelVerkoopprijsInclBtw, '.')))), __LINE__);
        }
        if (is_null($artikelVerkoopprijsInclBtw) || (is_array($artikelVerkoopprijsInclBtw) && empty($artikelVerkoopprijsInclBtw))) {
            unset($this->artikelVerkoopprijsInclBtw);
        } else {
            $this->artikelVerkoopprijsInclBtw = $artikelVerkoopprijsInclBtw;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PropositiePremiumsV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
