<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LicentiehouderV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Licentiehouder object.
 * @subpackage Structs
 */
class LicentiehouderV4 extends AbstractStructBase
{
    /**
     * The relNo
     * Meta informations extracted from the WSDL
     * - documentation: Het relatienummer van de licentiehouder.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The licentieNo
     * Meta informations extracted from the WSDL
     * - documentation: Het licentienummer van de licentiehouder.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $licentieNo;
    /**
     * The achternaam
     * Meta informations extracted from the WSDL
     * - documentation: Achternaam van de licentiehouder.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $achternaam;
    /**
     * The voornaam
     * Meta informations extracted from the WSDL
     * - documentation: Voornaam van de licentiehouder.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $voornaam;
    /**
     * The tussenvoegsels
     * Meta informations extracted from the WSDL
     * - documentation: Tussenvoegsels van de licentiehouder.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $tussenvoegsels;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - documentation: Het e-mail adres van de licentiehouder.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 80
     * @var string
     */
    public $email;
    /**
     * The rollen
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met rollen aanwezig bij de licentiehouder.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RolInfoV4
     */
    public $rollen;
    /**
     * Constructor method for LicentiehouderV4
     * @uses LicentiehouderV4::setRelNo()
     * @uses LicentiehouderV4::setLicentieNo()
     * @uses LicentiehouderV4::setAchternaam()
     * @uses LicentiehouderV4::setVoornaam()
     * @uses LicentiehouderV4::setTussenvoegsels()
     * @uses LicentiehouderV4::setEmail()
     * @uses LicentiehouderV4::setRollen()
     * @param int $relNo
     * @param int $licentieNo
     * @param string $achternaam
     * @param string $voornaam
     * @param string $tussenvoegsels
     * @param string $email
     * @param \StructType\RolInfoV4 $rollen
     */
    public function __construct($relNo = null, $licentieNo = null, $achternaam = null, $voornaam = null, $tussenvoegsels = null, $email = null, \StructType\RolInfoV4 $rollen = null)
    {
        $this
            ->setRelNo($relNo)
            ->setLicentieNo($licentieNo)
            ->setAchternaam($achternaam)
            ->setVoornaam($voornaam)
            ->setTussenvoegsels($tussenvoegsels)
            ->setEmail($email)
            ->setRollen($rollen);
    }
    /**
     * Get relNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNo()
    {
        return isset($this->relNo) ? $this->relNo : null;
    }
    /**
     * Set relNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNo
     * @return \StructType\LicentiehouderV4
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNo, strpos($relNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNo) && !is_numeric($relNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNo)), __LINE__);
        }
        if (is_null($relNo) || (is_array($relNo) && empty($relNo))) {
            unset($this->relNo);
        } else {
            $this->relNo = $relNo;
        }
        return $this;
    }
    /**
     * Get licentieNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLicentieNo()
    {
        return isset($this->licentieNo) ? $this->licentieNo : null;
    }
    /**
     * Set licentieNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $licentieNo
     * @return \StructType\LicentiehouderV4
     */
    public function setLicentieNo($licentieNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($licentieNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $licentieNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($licentieNo, strpos($licentieNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($licentieNo) && !is_numeric($licentieNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($licentieNo)), __LINE__);
        }
        if (is_null($licentieNo) || (is_array($licentieNo) && empty($licentieNo))) {
            unset($this->licentieNo);
        } else {
            $this->licentieNo = $licentieNo;
        }
        return $this;
    }
    /**
     * Get achternaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAchternaam()
    {
        return isset($this->achternaam) ? $this->achternaam : null;
    }
    /**
     * Set achternaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $achternaam
     * @return \StructType\LicentiehouderV4
     */
    public function setAchternaam($achternaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($achternaam) && strlen($achternaam) > 4000) || (is_array($achternaam) && count($achternaam) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($achternaam) ? strlen($achternaam) : count($achternaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($achternaam) && !is_string($achternaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($achternaam)), __LINE__);
        }
        if (is_null($achternaam) || (is_array($achternaam) && empty($achternaam))) {
            unset($this->achternaam);
        } else {
            $this->achternaam = $achternaam;
        }
        return $this;
    }
    /**
     * Get voornaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoornaam()
    {
        return isset($this->voornaam) ? $this->voornaam : null;
    }
    /**
     * Set voornaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voornaam
     * @return \StructType\LicentiehouderV4
     */
    public function setVoornaam($voornaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($voornaam) && strlen($voornaam) > 4000) || (is_array($voornaam) && count($voornaam) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($voornaam) ? strlen($voornaam) : count($voornaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($voornaam) && !is_string($voornaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voornaam)), __LINE__);
        }
        if (is_null($voornaam) || (is_array($voornaam) && empty($voornaam))) {
            unset($this->voornaam);
        } else {
            $this->voornaam = $voornaam;
        }
        return $this;
    }
    /**
     * Get tussenvoegsels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTussenvoegsels()
    {
        return isset($this->tussenvoegsels) ? $this->tussenvoegsels : null;
    }
    /**
     * Set tussenvoegsels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tussenvoegsels
     * @return \StructType\LicentiehouderV4
     */
    public function setTussenvoegsels($tussenvoegsels = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($tussenvoegsels) && strlen($tussenvoegsels) > 4000) || (is_array($tussenvoegsels) && count($tussenvoegsels) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($tussenvoegsels) ? strlen($tussenvoegsels) : count($tussenvoegsels)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tussenvoegsels) && !is_string($tussenvoegsels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tussenvoegsels)), __LINE__);
        }
        if (is_null($tussenvoegsels) || (is_array($tussenvoegsels) && empty($tussenvoegsels))) {
            unset($this->tussenvoegsels);
        } else {
            $this->tussenvoegsels = $tussenvoegsels;
        }
        return $this;
    }
    /**
     * Get email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->email) ? $this->email : null;
    }
    /**
     * Set email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\LicentiehouderV4
     */
    public function setEmail($email = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($email) && strlen($email) > 80) || (is_array($email) && count($email) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($email) ? strlen($email) : count($email)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->email);
        } else {
            $this->email = $email;
        }
        return $this;
    }
    /**
     * Get rollen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RolInfoV4|null
     */
    public function getRollen()
    {
        return isset($this->rollen) ? $this->rollen : null;
    }
    /**
     * Set rollen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RolInfoV4 $rollen
     * @return \StructType\LicentiehouderV4
     */
    public function setRollen(\StructType\RolInfoV4 $rollen = null)
    {
        if (is_null($rollen) || (is_array($rollen) && empty($rollen))) {
            unset($this->rollen);
        } else {
            $this->rollen = $rollen;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LicentiehouderV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
