<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LicentiehouderInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Een lijst met de gevonden licentiehouders.
 * @subpackage Structs
 */
class LicentiehouderInfoV4 extends AbstractStructBase
{
    /**
     * The licentiehouder
     * Meta informations extracted from the WSDL
     * - documentation: Een lijst met de gevonden licentiehouders.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\LicentiehouderV4[]
     */
    public $licentiehouder;
    /**
     * Constructor method for LicentiehouderInfoV4
     * @uses LicentiehouderInfoV4::setLicentiehouder()
     * @param \StructType\LicentiehouderV4[] $licentiehouder
     */
    public function __construct(array $licentiehouder = array())
    {
        $this
            ->setLicentiehouder($licentiehouder);
    }
    /**
     * Get licentiehouder value
     * @return \StructType\LicentiehouderV4[]|null
     */
    public function getLicentiehouder()
    {
        return $this->licentiehouder;
    }
    /**
     * Set licentiehouder value
     * @throws \InvalidArgumentException
     * @param \StructType\LicentiehouderV4[] $licentiehouder
     * @return \StructType\LicentiehouderInfoV4
     */
    public function setLicentiehouder(array $licentiehouder = array())
    {
        foreach ($licentiehouder as $licentiehouderInfoV4LicentiehouderItem) {
            // validation for constraint: itemType
            if (!$licentiehouderInfoV4LicentiehouderItem instanceof \StructType\LicentiehouderV4) {
                throw new \InvalidArgumentException(sprintf('The licentiehouder property can only contain items of \StructType\LicentiehouderV4, "%s" given', is_object($licentiehouderInfoV4LicentiehouderItem) ? get_class($licentiehouderInfoV4LicentiehouderItem) : gettype($licentiehouderInfoV4LicentiehouderItem)), __LINE__);
            }
        }
        $this->licentiehouder = $licentiehouder;
        return $this;
    }
    /**
     * Add item to licentiehouder value
     * @throws \InvalidArgumentException
     * @param \StructType\LicentiehouderV4 $item
     * @return \StructType\LicentiehouderInfoV4
     */
    public function addToLicentiehouder(\StructType\LicentiehouderV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LicentiehouderV4) {
            throw new \InvalidArgumentException(sprintf('The licentiehouder property can only contain items of \StructType\LicentiehouderV4, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->licentiehouder[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LicentiehouderInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
