<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HerkomstInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met herkomsten.
 * @subpackage Structs
 */
class HerkomstInfoV4 extends AbstractStructBase
{
    /**
     * The herkomst
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met herkomsten.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\HerkomstV4[]
     */
    public $herkomst;
    /**
     * Constructor method for HerkomstInfoV4
     * @uses HerkomstInfoV4::setHerkomst()
     * @param \StructType\HerkomstV4[] $herkomst
     */
    public function __construct(array $herkomst = array())
    {
        $this
            ->setHerkomst($herkomst);
    }
    /**
     * Get herkomst value
     * @return \StructType\HerkomstV4[]|null
     */
    public function getHerkomst()
    {
        return $this->herkomst;
    }
    /**
     * Set herkomst value
     * @throws \InvalidArgumentException
     * @param \StructType\HerkomstV4[] $herkomst
     * @return \StructType\HerkomstInfoV4
     */
    public function setHerkomst(array $herkomst = array())
    {
        foreach ($herkomst as $herkomstInfoV4HerkomstItem) {
            // validation for constraint: itemType
            if (!$herkomstInfoV4HerkomstItem instanceof \StructType\HerkomstV4) {
                throw new \InvalidArgumentException(sprintf('The herkomst property can only contain items of \StructType\HerkomstV4, "%s" given', is_object($herkomstInfoV4HerkomstItem) ? get_class($herkomstInfoV4HerkomstItem) : gettype($herkomstInfoV4HerkomstItem)), __LINE__);
            }
        }
        $this->herkomst = $herkomst;
        return $this;
    }
    /**
     * Add item to herkomst value
     * @throws \InvalidArgumentException
     * @param \StructType\HerkomstV4 $item
     * @return \StructType\HerkomstInfoV4
     */
    public function addToHerkomst(\StructType\HerkomstV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HerkomstV4) {
            throw new \InvalidArgumentException(sprintf('The herkomst property can only contain items of \StructType\HerkomstV4, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->herkomst[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HerkomstInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
