<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getRelatieAbosoortPrijsResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error21: De debiteur is niet gevonden | error92: De abonnementsoort is niet bekend | error93: De abonnee is niet gevonden
 * @subpackage Structs
 */
class GetRelatieAbosoortPrijsResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The prijsExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: De prijs excl. BTW.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $prijsExclBtw;
    /**
     * The prijsExclBtwPerStuk
     * Meta informations extracted from the WSDL
     * - documentation: De prijs excl. BTW per stuk.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $prijsExclBtwPerStuk;
    /**
     * The kortingStaffelBedr
     * Meta informations extracted from the WSDL
     * - documentation: Het bedrag aan eventuele staffelkorting dat geldt voor het gegeven aantal exemplaren.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingStaffelBedr;
    /**
     * The kortingStaffelPerc
     * Meta informations extracted from the WSDL
     * - documentation: Het percentage aan eventuele staffelkorting die geldt voor het gegeven aantal exemplaren.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingStaffelPerc;
    /**
     * The kortingPrijsmatrixBedr
     * Meta informations extracted from the WSDL
     * - documentation: Het eventuele kortingsbedrag die geldt volgens de prijsmatrix.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingPrijsmatrixBedr;
    /**
     * The kortingPrijsmatrixPerc
     * Meta informations extracted from the WSDL
     * - documentation: Het eventuele kortingspercentage die geldt volgens de prijsmatrix.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingPrijsmatrixPerc;
    /**
     * The kortingPrijsmatrixOmschr
     * Meta informations extracted from the WSDL
     * - documentation: De omschrijving van de reden van de korting volgens de prijsmatrix.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $kortingPrijsmatrixOmschr;
    /**
     * The btwPerc
     * Meta informations extracted from the WSDL
     * - documentation: Het BTW percentage dat geldt voor de debiteur.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $btwPerc;
    /**
     * The btwBedr
     * Meta informations extracted from the WSDL
     * - documentation: het bedrag aan BTW dat geldt voor de debiteur.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $btwBedr;
    /**
     * Constructor method for getRelatieAbosoortPrijsResponse
     * @uses GetRelatieAbosoortPrijsResponse::setRequestTag()
     * @uses GetRelatieAbosoortPrijsResponse::setPrijsExclBtw()
     * @uses GetRelatieAbosoortPrijsResponse::setPrijsExclBtwPerStuk()
     * @uses GetRelatieAbosoortPrijsResponse::setKortingStaffelBedr()
     * @uses GetRelatieAbosoortPrijsResponse::setKortingStaffelPerc()
     * @uses GetRelatieAbosoortPrijsResponse::setKortingPrijsmatrixBedr()
     * @uses GetRelatieAbosoortPrijsResponse::setKortingPrijsmatrixPerc()
     * @uses GetRelatieAbosoortPrijsResponse::setKortingPrijsmatrixOmschr()
     * @uses GetRelatieAbosoortPrijsResponse::setBtwPerc()
     * @uses GetRelatieAbosoortPrijsResponse::setBtwBedr()
     * @param string $requestTag
     * @param float $prijsExclBtw
     * @param float $prijsExclBtwPerStuk
     * @param float $kortingStaffelBedr
     * @param float $kortingStaffelPerc
     * @param float $kortingPrijsmatrixBedr
     * @param float $kortingPrijsmatrixPerc
     * @param string $kortingPrijsmatrixOmschr
     * @param float $btwPerc
     * @param float $btwBedr
     */
    public function __construct($requestTag = null, $prijsExclBtw = null, $prijsExclBtwPerStuk = null, $kortingStaffelBedr = null, $kortingStaffelPerc = null, $kortingPrijsmatrixBedr = null, $kortingPrijsmatrixPerc = null, $kortingPrijsmatrixOmschr = null, $btwPerc = null, $btwBedr = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setPrijsExclBtw($prijsExclBtw)
            ->setPrijsExclBtwPerStuk($prijsExclBtwPerStuk)
            ->setKortingStaffelBedr($kortingStaffelBedr)
            ->setKortingStaffelPerc($kortingStaffelPerc)
            ->setKortingPrijsmatrixBedr($kortingPrijsmatrixBedr)
            ->setKortingPrijsmatrixPerc($kortingPrijsmatrixPerc)
            ->setKortingPrijsmatrixOmschr($kortingPrijsmatrixOmschr)
            ->setBtwPerc($btwPerc)
            ->setBtwBedr($btwBedr);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\GetRelatieAbosoortPrijsResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get prijsExclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijsExclBtw()
    {
        return isset($this->prijsExclBtw) ? $this->prijsExclBtw : null;
    }
    /**
     * Set prijsExclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijsExclBtw
     * @return \StructType\GetRelatieAbosoortPrijsResponse
     */
    public function setPrijsExclBtw($prijsExclBtw = null)
    {
        // validation for constraint: totalDigits
        if (is_float($prijsExclBtw) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $prijsExclBtw)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($prijsExclBtw, strpos($prijsExclBtw, '.')))), __LINE__);
        }
        if (is_null($prijsExclBtw) || (is_array($prijsExclBtw) && empty($prijsExclBtw))) {
            unset($this->prijsExclBtw);
        } else {
            $this->prijsExclBtw = $prijsExclBtw;
        }
        return $this;
    }
    /**
     * Get prijsExclBtwPerStuk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijsExclBtwPerStuk()
    {
        return isset($this->prijsExclBtwPerStuk) ? $this->prijsExclBtwPerStuk : null;
    }
    /**
     * Set prijsExclBtwPerStuk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijsExclBtwPerStuk
     * @return \StructType\GetRelatieAbosoortPrijsResponse
     */
    public function setPrijsExclBtwPerStuk($prijsExclBtwPerStuk = null)
    {
        // validation for constraint: totalDigits
        if (is_float($prijsExclBtwPerStuk) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $prijsExclBtwPerStuk)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($prijsExclBtwPerStuk, strpos($prijsExclBtwPerStuk, '.')))), __LINE__);
        }
        if (is_null($prijsExclBtwPerStuk) || (is_array($prijsExclBtwPerStuk) && empty($prijsExclBtwPerStuk))) {
            unset($this->prijsExclBtwPerStuk);
        } else {
            $this->prijsExclBtwPerStuk = $prijsExclBtwPerStuk;
        }
        return $this;
    }
    /**
     * Get kortingStaffelBedr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingStaffelBedr()
    {
        return isset($this->kortingStaffelBedr) ? $this->kortingStaffelBedr : null;
    }
    /**
     * Set kortingStaffelBedr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingStaffelBedr
     * @return \StructType\GetRelatieAbosoortPrijsResponse
     */
    public function setKortingStaffelBedr($kortingStaffelBedr = null)
    {
        // validation for constraint: totalDigits
        if (is_float($kortingStaffelBedr) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $kortingStaffelBedr)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($kortingStaffelBedr, strpos($kortingStaffelBedr, '.')))), __LINE__);
        }
        if (is_null($kortingStaffelBedr) || (is_array($kortingStaffelBedr) && empty($kortingStaffelBedr))) {
            unset($this->kortingStaffelBedr);
        } else {
            $this->kortingStaffelBedr = $kortingStaffelBedr;
        }
        return $this;
    }
    /**
     * Get kortingStaffelPerc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingStaffelPerc()
    {
        return isset($this->kortingStaffelPerc) ? $this->kortingStaffelPerc : null;
    }
    /**
     * Set kortingStaffelPerc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingStaffelPerc
     * @return \StructType\GetRelatieAbosoortPrijsResponse
     */
    public function setKortingStaffelPerc($kortingStaffelPerc = null)
    {
        // validation for constraint: totalDigits
        if (is_float($kortingStaffelPerc) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $kortingStaffelPerc)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($kortingStaffelPerc, strpos($kortingStaffelPerc, '.')))), __LINE__);
        }
        if (is_null($kortingStaffelPerc) || (is_array($kortingStaffelPerc) && empty($kortingStaffelPerc))) {
            unset($this->kortingStaffelPerc);
        } else {
            $this->kortingStaffelPerc = $kortingStaffelPerc;
        }
        return $this;
    }
    /**
     * Get kortingPrijsmatrixBedr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingPrijsmatrixBedr()
    {
        return isset($this->kortingPrijsmatrixBedr) ? $this->kortingPrijsmatrixBedr : null;
    }
    /**
     * Set kortingPrijsmatrixBedr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingPrijsmatrixBedr
     * @return \StructType\GetRelatieAbosoortPrijsResponse
     */
    public function setKortingPrijsmatrixBedr($kortingPrijsmatrixBedr = null)
    {
        // validation for constraint: totalDigits
        if (is_float($kortingPrijsmatrixBedr) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $kortingPrijsmatrixBedr)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($kortingPrijsmatrixBedr, strpos($kortingPrijsmatrixBedr, '.')))), __LINE__);
        }
        if (is_null($kortingPrijsmatrixBedr) || (is_array($kortingPrijsmatrixBedr) && empty($kortingPrijsmatrixBedr))) {
            unset($this->kortingPrijsmatrixBedr);
        } else {
            $this->kortingPrijsmatrixBedr = $kortingPrijsmatrixBedr;
        }
        return $this;
    }
    /**
     * Get kortingPrijsmatrixPerc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingPrijsmatrixPerc()
    {
        return isset($this->kortingPrijsmatrixPerc) ? $this->kortingPrijsmatrixPerc : null;
    }
    /**
     * Set kortingPrijsmatrixPerc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingPrijsmatrixPerc
     * @return \StructType\GetRelatieAbosoortPrijsResponse
     */
    public function setKortingPrijsmatrixPerc($kortingPrijsmatrixPerc = null)
    {
        // validation for constraint: totalDigits
        if (is_float($kortingPrijsmatrixPerc) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $kortingPrijsmatrixPerc)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($kortingPrijsmatrixPerc, strpos($kortingPrijsmatrixPerc, '.')))), __LINE__);
        }
        if (is_null($kortingPrijsmatrixPerc) || (is_array($kortingPrijsmatrixPerc) && empty($kortingPrijsmatrixPerc))) {
            unset($this->kortingPrijsmatrixPerc);
        } else {
            $this->kortingPrijsmatrixPerc = $kortingPrijsmatrixPerc;
        }
        return $this;
    }
    /**
     * Get kortingPrijsmatrixOmschr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKortingPrijsmatrixOmschr()
    {
        return isset($this->kortingPrijsmatrixOmschr) ? $this->kortingPrijsmatrixOmschr : null;
    }
    /**
     * Set kortingPrijsmatrixOmschr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kortingPrijsmatrixOmschr
     * @return \StructType\GetRelatieAbosoortPrijsResponse
     */
    public function setKortingPrijsmatrixOmschr($kortingPrijsmatrixOmschr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($kortingPrijsmatrixOmschr) && strlen($kortingPrijsmatrixOmschr) > 4000) || (is_array($kortingPrijsmatrixOmschr) && count($kortingPrijsmatrixOmschr) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($kortingPrijsmatrixOmschr) ? strlen($kortingPrijsmatrixOmschr) : count($kortingPrijsmatrixOmschr)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kortingPrijsmatrixOmschr) && !is_string($kortingPrijsmatrixOmschr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kortingPrijsmatrixOmschr)), __LINE__);
        }
        if (is_null($kortingPrijsmatrixOmschr) || (is_array($kortingPrijsmatrixOmschr) && empty($kortingPrijsmatrixOmschr))) {
            unset($this->kortingPrijsmatrixOmschr);
        } else {
            $this->kortingPrijsmatrixOmschr = $kortingPrijsmatrixOmschr;
        }
        return $this;
    }
    /**
     * Get btwPerc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBtwPerc()
    {
        return isset($this->btwPerc) ? $this->btwPerc : null;
    }
    /**
     * Set btwPerc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $btwPerc
     * @return \StructType\GetRelatieAbosoortPrijsResponse
     */
    public function setBtwPerc($btwPerc = null)
    {
        // validation for constraint: totalDigits
        if (is_float($btwPerc) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $btwPerc)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($btwPerc, strpos($btwPerc, '.')))), __LINE__);
        }
        if (is_null($btwPerc) || (is_array($btwPerc) && empty($btwPerc))) {
            unset($this->btwPerc);
        } else {
            $this->btwPerc = $btwPerc;
        }
        return $this;
    }
    /**
     * Get btwBedr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBtwBedr()
    {
        return isset($this->btwBedr) ? $this->btwBedr : null;
    }
    /**
     * Set btwBedr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $btwBedr
     * @return \StructType\GetRelatieAbosoortPrijsResponse
     */
    public function setBtwBedr($btwBedr = null)
    {
        // validation for constraint: totalDigits
        if (is_float($btwBedr) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $btwBedr)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($btwBedr, strpos($btwBedr, '.')))), __LINE__);
        }
        if (is_null($btwBedr) || (is_array($btwBedr) && empty($btwBedr))) {
            unset($this->btwBedr);
        } else {
            $this->btwBedr = $btwBedr;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetRelatieAbosoortPrijsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
