<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getRelatieAbosoortPrijsRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Geeft de prijs terug van een abonnementsoort die voor een relatie geldt
 * @subpackage Structs
 */
class GetRelatieAbosoortPrijsRequest extends AbstractStructBase
{
    /**
     * The abonnementsoortCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van het abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $abonnementsoortCode;
    /**
     * The relatienummerAbonnee
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van de abonnee. Wordt gebruikt om te bepalen wat de prijs van de abonnementsoort is in het land van de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatienummerAbonnee;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The relatienummerDebiteur
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van de debiteur. Wordt gebruikt om te bepalen welk BTW percentage er van toepassing is (indien gebruik wordt gemaakt van geopteerde BTW). Indien leeg, wordt de abonneerelatie gebruikt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relatienummerDebiteur;
    /**
     * The aantal
     * Meta informations extracted from the WSDL
     * - documentation: Het aantal exemplaren dat af wordt genomen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $aantal;
    /**
     * Constructor method for getRelatieAbosoortPrijsRequest
     * @uses GetRelatieAbosoortPrijsRequest::setAbonnementsoortCode()
     * @uses GetRelatieAbosoortPrijsRequest::setRelatienummerAbonnee()
     * @uses GetRelatieAbosoortPrijsRequest::setRequestTag()
     * @uses GetRelatieAbosoortPrijsRequest::setRelatienummerDebiteur()
     * @uses GetRelatieAbosoortPrijsRequest::setAantal()
     * @param string $abonnementsoortCode
     * @param int $relatienummerAbonnee
     * @param string $requestTag
     * @param int $relatienummerDebiteur
     * @param float $aantal
     */
    public function __construct($abonnementsoortCode = null, $relatienummerAbonnee = null, $requestTag = null, $relatienummerDebiteur = null, $aantal = null)
    {
        $this
            ->setAbonnementsoortCode($abonnementsoortCode)
            ->setRelatienummerAbonnee($relatienummerAbonnee)
            ->setRequestTag($requestTag)
            ->setRelatienummerDebiteur($relatienummerDebiteur)
            ->setAantal($aantal);
    }
    /**
     * Get abonnementsoortCode value
     * @return string
     */
    public function getAbonnementsoortCode()
    {
        return $this->abonnementsoortCode;
    }
    /**
     * Set abonnementsoortCode value
     * @param string $abonnementsoortCode
     * @return \StructType\GetRelatieAbosoortPrijsRequest
     */
    public function setAbonnementsoortCode($abonnementsoortCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abonnementsoortCode) && strlen($abonnementsoortCode) > 30) || (is_array($abonnementsoortCode) && count($abonnementsoortCode) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($abonnementsoortCode) ? strlen($abonnementsoortCode) : count($abonnementsoortCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($abonnementsoortCode) && strlen($abonnementsoortCode) < 1) || (is_array($abonnementsoortCode) && count($abonnementsoortCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abonnementsoortCode) && !is_string($abonnementsoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abonnementsoortCode)), __LINE__);
        }
        $this->abonnementsoortCode = $abonnementsoortCode;
        return $this;
    }
    /**
     * Get relatienummerAbonnee value
     * @return int
     */
    public function getRelatienummerAbonnee()
    {
        return $this->relatienummerAbonnee;
    }
    /**
     * Set relatienummerAbonnee value
     * @param int $relatienummerAbonnee
     * @return \StructType\GetRelatieAbosoortPrijsRequest
     */
    public function setRelatienummerAbonnee($relatienummerAbonnee = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relatienummerAbonnee) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relatienummerAbonnee)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relatienummerAbonnee, strpos($relatienummerAbonnee, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relatienummerAbonnee) && !is_numeric($relatienummerAbonnee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relatienummerAbonnee)), __LINE__);
        }
        $this->relatienummerAbonnee = $relatienummerAbonnee;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\GetRelatieAbosoortPrijsRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relatienummerDebiteur value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatienummerDebiteur()
    {
        return isset($this->relatienummerDebiteur) ? $this->relatienummerDebiteur : null;
    }
    /**
     * Set relatienummerDebiteur value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatienummerDebiteur
     * @return \StructType\GetRelatieAbosoortPrijsRequest
     */
    public function setRelatienummerDebiteur($relatienummerDebiteur = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relatienummerDebiteur) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relatienummerDebiteur)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relatienummerDebiteur, strpos($relatienummerDebiteur, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relatienummerDebiteur) && !is_numeric($relatienummerDebiteur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relatienummerDebiteur)), __LINE__);
        }
        if (is_null($relatienummerDebiteur) || (is_array($relatienummerDebiteur) && empty($relatienummerDebiteur))) {
            unset($this->relatienummerDebiteur);
        } else {
            $this->relatienummerDebiteur = $relatienummerDebiteur;
        }
        return $this;
    }
    /**
     * Get aantal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAantal()
    {
        return isset($this->aantal) ? $this->aantal : null;
    }
    /**
     * Set aantal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aantal
     * @return \StructType\GetRelatieAbosoortPrijsRequest
     */
    public function setAantal($aantal = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aantal) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aantal)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($aantal, strpos($aantal, '.')))), __LINE__);
        }
        if (is_null($aantal) || (is_array($aantal) && empty($aantal))) {
            unset($this->aantal);
        } else {
            $this->aantal = $aantal;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetRelatieAbosoortPrijsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
