<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getAbonnementsoortInfoRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ophalen van de gegevens van een of meerdere abonnementsoorten. Hierbij kan gezocht worden op basis van de abonnementsoortcode, de uitgavecode en op inactieve abonnementsoorten.
 * @subpackage Structs
 */
class GetAbonnementsoortInfoRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The abonnementsoortCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de abonnementsoort waarvan de informatie wordt opgevraagd. Indien leeg wordt van alle abonnementsoorten de gegevens opgehaald.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 30
     * @var string
     */
    public $abonnementsoortCode;
    /**
     * The uitgaveCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de uitgave. Indien abonnementsoortcode leeg is, worden alleen abonnementsoorten van de opgegeven uitgave opgehaald. Indien leeg, alle abonnementsoorten.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 12
     * @var string
     */
    public $uitgaveCode;
    /**
     * The landCode
     * Meta informations extracted from the WSDL
     * - documentation: Landcode. Wordt gebruikt om landspecifieke prijs van de abonnementsoort te te bepalen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 3
     * @var string
     */
    public $landCode;
    /**
     * The relNo
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer. Wordt gebruikt om relatiespecifieke prijs van de abonnementsoort te bepalen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The aantalExemplaren
     * Meta informations extracted from the WSDL
     * - documentation: Aantal exemplaren. wordt gebruikt om prijs van de abonnementsoort te te bepalen voor het specifieke aantal exemplaren.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aantalExemplaren;
    /**
     * The inclusiefInactieve
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of inactieve abonnementsoorten teruggegeven moet worden. false (Default) = Alleen actieve. true = Inclusief inactieve.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $inclusiefInactieve;
    /**
     * Constructor method for getAbonnementsoortInfoRequest
     * @uses GetAbonnementsoortInfoRequest::setRequestTag()
     * @uses GetAbonnementsoortInfoRequest::setAbonnementsoortCode()
     * @uses GetAbonnementsoortInfoRequest::setUitgaveCode()
     * @uses GetAbonnementsoortInfoRequest::setLandCode()
     * @uses GetAbonnementsoortInfoRequest::setRelNo()
     * @uses GetAbonnementsoortInfoRequest::setAantalExemplaren()
     * @uses GetAbonnementsoortInfoRequest::setInclusiefInactieve()
     * @param string $requestTag
     * @param string $abonnementsoortCode
     * @param string $uitgaveCode
     * @param string $landCode
     * @param int $relNo
     * @param int $aantalExemplaren
     * @param bool $inclusiefInactieve
     */
    public function __construct($requestTag = null, $abonnementsoortCode = null, $uitgaveCode = null, $landCode = null, $relNo = null, $aantalExemplaren = null, $inclusiefInactieve = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setAbonnementsoortCode($abonnementsoortCode)
            ->setUitgaveCode($uitgaveCode)
            ->setLandCode($landCode)
            ->setRelNo($relNo)
            ->setAantalExemplaren($aantalExemplaren)
            ->setInclusiefInactieve($inclusiefInactieve);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\GetAbonnementsoortInfoRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get abonnementsoortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementsoortCode()
    {
        return isset($this->abonnementsoortCode) ? $this->abonnementsoortCode : null;
    }
    /**
     * Set abonnementsoortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementsoortCode
     * @return \StructType\GetAbonnementsoortInfoRequest
     */
    public function setAbonnementsoortCode($abonnementsoortCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abonnementsoortCode) && strlen($abonnementsoortCode) > 30) || (is_array($abonnementsoortCode) && count($abonnementsoortCode) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($abonnementsoortCode) ? strlen($abonnementsoortCode) : count($abonnementsoortCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abonnementsoortCode) && !is_string($abonnementsoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abonnementsoortCode)), __LINE__);
        }
        if (is_null($abonnementsoortCode) || (is_array($abonnementsoortCode) && empty($abonnementsoortCode))) {
            unset($this->abonnementsoortCode);
        } else {
            $this->abonnementsoortCode = $abonnementsoortCode;
        }
        return $this;
    }
    /**
     * Get uitgaveCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveCode()
    {
        return isset($this->uitgaveCode) ? $this->uitgaveCode : null;
    }
    /**
     * Set uitgaveCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveCode
     * @return \StructType\GetAbonnementsoortInfoRequest
     */
    public function setUitgaveCode($uitgaveCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($uitgaveCode) && strlen($uitgaveCode) > 12) || (is_array($uitgaveCode) && count($uitgaveCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($uitgaveCode) ? strlen($uitgaveCode) : count($uitgaveCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uitgaveCode) && !is_string($uitgaveCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uitgaveCode)), __LINE__);
        }
        if (is_null($uitgaveCode) || (is_array($uitgaveCode) && empty($uitgaveCode))) {
            unset($this->uitgaveCode);
        } else {
            $this->uitgaveCode = $uitgaveCode;
        }
        return $this;
    }
    /**
     * Get landCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLandCode()
    {
        return isset($this->landCode) ? $this->landCode : null;
    }
    /**
     * Set landCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $landCode
     * @return \StructType\GetAbonnementsoortInfoRequest
     */
    public function setLandCode($landCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($landCode) && strlen($landCode) > 3) || (is_array($landCode) && count($landCode) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($landCode) ? strlen($landCode) : count($landCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($landCode) && !is_string($landCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($landCode)), __LINE__);
        }
        if (is_null($landCode) || (is_array($landCode) && empty($landCode))) {
            unset($this->landCode);
        } else {
            $this->landCode = $landCode;
        }
        return $this;
    }
    /**
     * Get relNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNo()
    {
        return isset($this->relNo) ? $this->relNo : null;
    }
    /**
     * Set relNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNo
     * @return \StructType\GetAbonnementsoortInfoRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNo, strpos($relNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNo) && !is_numeric($relNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNo)), __LINE__);
        }
        if (is_null($relNo) || (is_array($relNo) && empty($relNo))) {
            unset($this->relNo);
        } else {
            $this->relNo = $relNo;
        }
        return $this;
    }
    /**
     * Get aantalExemplaren value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAantalExemplaren()
    {
        return isset($this->aantalExemplaren) ? $this->aantalExemplaren : null;
    }
    /**
     * Set aantalExemplaren value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aantalExemplaren
     * @return \StructType\GetAbonnementsoortInfoRequest
     */
    public function setAantalExemplaren($aantalExemplaren = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aantalExemplaren) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aantalExemplaren)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($aantalExemplaren, strpos($aantalExemplaren, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($aantalExemplaren) && !is_numeric($aantalExemplaren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aantalExemplaren)), __LINE__);
        }
        if (is_null($aantalExemplaren) || (is_array($aantalExemplaren) && empty($aantalExemplaren))) {
            unset($this->aantalExemplaren);
        } else {
            $this->aantalExemplaren = $aantalExemplaren;
        }
        return $this;
    }
    /**
     * Get inclusiefInactieve value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInclusiefInactieve()
    {
        return isset($this->inclusiefInactieve) ? $this->inclusiefInactieve : null;
    }
    /**
     * Set inclusiefInactieve value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $inclusiefInactieve
     * @return \StructType\GetAbonnementsoortInfoRequest
     */
    public function setInclusiefInactieve($inclusiefInactieve = null)
    {
        if (is_null($inclusiefInactieve) || (is_array($inclusiefInactieve) && empty($inclusiefInactieve))) {
            unset($this->inclusiefInactieve);
        } else {
            $this->inclusiefInactieve = $inclusiefInactieve;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAbonnementsoortInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
