<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FactSamenvatV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Samengevatte gegevens van een factuur.
 * @subpackage Structs
 */
class FactSamenvatV4 extends AbstractStructBase
{
    /**
     * The factuurNo
     * Meta informations extracted from the WSDL
     * - documentation: Factuurnummer.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 17
     * - minLength: 1
     * @var string
     */
    public $factuurNo;
    /**
     * The factuurDatum
     * Meta informations extracted from the WSDL
     * - documentation: Factuurdatum.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $factuurDatum;
    /**
     * The vervalDatum
     * Meta informations extracted from the WSDL
     * - documentation: Vervaldatum.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $vervalDatum;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - documentation: [0,1,2,3,4,5] Status van de factuur: 0 = Voldaan, 1 = Niet voldaan, 2 = Vervallen, 3 = Naar incassobureau, 4 = Automatische incasso, 5 = Creditcard incasso.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $status;
    /**
     * The totaalExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Totaal bedrag exclusief BTW.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $totaalExclBtw;
    /**
     * The totaalInclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Totaal bedrag inclusief BTW.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $totaalInclBtw;
    /**
     * The subtotaalInfo
     * Meta informations extracted from the WSDL
     * - documentation: Samengevatte factuur subtotaal info.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FactSamenvatSubtotInfoV4
     */
    public $subtotaalInfo;
    /**
     * The btwInfo
     * Meta informations extracted from the WSDL
     * - documentation: BTW gegevens van de factuur.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FactSamenvatBtwInfoV4
     */
    public $btwInfo;
    /**
     * Constructor method for FactSamenvatV4
     * @uses FactSamenvatV4::setFactuurNo()
     * @uses FactSamenvatV4::setFactuurDatum()
     * @uses FactSamenvatV4::setVervalDatum()
     * @uses FactSamenvatV4::setStatus()
     * @uses FactSamenvatV4::setTotaalExclBtw()
     * @uses FactSamenvatV4::setTotaalInclBtw()
     * @uses FactSamenvatV4::setSubtotaalInfo()
     * @uses FactSamenvatV4::setBtwInfo()
     * @param string $factuurNo
     * @param string $factuurDatum
     * @param string $vervalDatum
     * @param float $status
     * @param float $totaalExclBtw
     * @param float $totaalInclBtw
     * @param \StructType\FactSamenvatSubtotInfoV4 $subtotaalInfo
     * @param \StructType\FactSamenvatBtwInfoV4 $btwInfo
     */
    public function __construct($factuurNo = null, $factuurDatum = null, $vervalDatum = null, $status = null, $totaalExclBtw = null, $totaalInclBtw = null, \StructType\FactSamenvatSubtotInfoV4 $subtotaalInfo = null, \StructType\FactSamenvatBtwInfoV4 $btwInfo = null)
    {
        $this
            ->setFactuurNo($factuurNo)
            ->setFactuurDatum($factuurDatum)
            ->setVervalDatum($vervalDatum)
            ->setStatus($status)
            ->setTotaalExclBtw($totaalExclBtw)
            ->setTotaalInclBtw($totaalInclBtw)
            ->setSubtotaalInfo($subtotaalInfo)
            ->setBtwInfo($btwInfo);
    }
    /**
     * Get factuurNo value
     * @return string
     */
    public function getFactuurNo()
    {
        return $this->factuurNo;
    }
    /**
     * Set factuurNo value
     * @param string $factuurNo
     * @return \StructType\FactSamenvatV4
     */
    public function setFactuurNo($factuurNo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($factuurNo) && strlen($factuurNo) > 17) || (is_array($factuurNo) && count($factuurNo) > 17)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 17 element(s) or a scalar of 17 character(s) at most, "%d" length given', is_scalar($factuurNo) ? strlen($factuurNo) : count($factuurNo)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($factuurNo) && strlen($factuurNo) < 1) || (is_array($factuurNo) && count($factuurNo) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($factuurNo) && !is_string($factuurNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($factuurNo)), __LINE__);
        }
        $this->factuurNo = $factuurNo;
        return $this;
    }
    /**
     * Get factuurDatum value
     * @return string
     */
    public function getFactuurDatum()
    {
        return $this->factuurDatum;
    }
    /**
     * Set factuurDatum value
     * @param string $factuurDatum
     * @return \StructType\FactSamenvatV4
     */
    public function setFactuurDatum($factuurDatum = null)
    {
        // validation for constraint: string
        if (!is_null($factuurDatum) && !is_string($factuurDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($factuurDatum)), __LINE__);
        }
        $this->factuurDatum = $factuurDatum;
        return $this;
    }
    /**
     * Get vervalDatum value
     * @return string
     */
    public function getVervalDatum()
    {
        return $this->vervalDatum;
    }
    /**
     * Set vervalDatum value
     * @param string $vervalDatum
     * @return \StructType\FactSamenvatV4
     */
    public function setVervalDatum($vervalDatum = null)
    {
        // validation for constraint: string
        if (!is_null($vervalDatum) && !is_string($vervalDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vervalDatum)), __LINE__);
        }
        $this->vervalDatum = $vervalDatum;
        return $this;
    }
    /**
     * Get status value
     * @return float
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param float $status
     * @return \StructType\FactSamenvatV4
     */
    public function setStatus($status = null)
    {
        // validation for constraint: totalDigits
        if (is_float($status) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $status)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($status, strpos($status, '.')))), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get totaalExclBtw value
     * @return float
     */
    public function getTotaalExclBtw()
    {
        return $this->totaalExclBtw;
    }
    /**
     * Set totaalExclBtw value
     * @param float $totaalExclBtw
     * @return \StructType\FactSamenvatV4
     */
    public function setTotaalExclBtw($totaalExclBtw = null)
    {
        // validation for constraint: totalDigits
        if (is_float($totaalExclBtw) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $totaalExclBtw)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($totaalExclBtw, strpos($totaalExclBtw, '.')))), __LINE__);
        }
        $this->totaalExclBtw = $totaalExclBtw;
        return $this;
    }
    /**
     * Get totaalInclBtw value
     * @return float
     */
    public function getTotaalInclBtw()
    {
        return $this->totaalInclBtw;
    }
    /**
     * Set totaalInclBtw value
     * @param float $totaalInclBtw
     * @return \StructType\FactSamenvatV4
     */
    public function setTotaalInclBtw($totaalInclBtw = null)
    {
        // validation for constraint: totalDigits
        if (is_float($totaalInclBtw) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $totaalInclBtw)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($totaalInclBtw, strpos($totaalInclBtw, '.')))), __LINE__);
        }
        $this->totaalInclBtw = $totaalInclBtw;
        return $this;
    }
    /**
     * Get subtotaalInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FactSamenvatSubtotInfoV4|null
     */
    public function getSubtotaalInfo()
    {
        return isset($this->subtotaalInfo) ? $this->subtotaalInfo : null;
    }
    /**
     * Set subtotaalInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FactSamenvatSubtotInfoV4 $subtotaalInfo
     * @return \StructType\FactSamenvatV4
     */
    public function setSubtotaalInfo(\StructType\FactSamenvatSubtotInfoV4 $subtotaalInfo = null)
    {
        if (is_null($subtotaalInfo) || (is_array($subtotaalInfo) && empty($subtotaalInfo))) {
            unset($this->subtotaalInfo);
        } else {
            $this->subtotaalInfo = $subtotaalInfo;
        }
        return $this;
    }
    /**
     * Get btwInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FactSamenvatBtwInfoV4|null
     */
    public function getBtwInfo()
    {
        return isset($this->btwInfo) ? $this->btwInfo : null;
    }
    /**
     * Set btwInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FactSamenvatBtwInfoV4 $btwInfo
     * @return \StructType\FactSamenvatV4
     */
    public function setBtwInfo(\StructType\FactSamenvatBtwInfoV4 $btwInfo = null)
    {
        if (is_null($btwInfo) || (is_array($btwInfo) && empty($btwInfo))) {
            unset($this->btwInfo);
        } else {
            $this->btwInfo = $btwInfo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FactSamenvatV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
