<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FactSamenvatInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met facturen samenvattingen.
 * @subpackage Structs
 */
class FactSamenvatInfoV4 extends AbstractStructBase
{
    /**
     * The factuurSamenvatting
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met factuur samenvattingen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\FactSamenvatV4[]
     */
    public $factuurSamenvatting;
    /**
     * Constructor method for FactSamenvatInfoV4
     * @uses FactSamenvatInfoV4::setFactuurSamenvatting()
     * @param \StructType\FactSamenvatV4[] $factuurSamenvatting
     */
    public function __construct(array $factuurSamenvatting = array())
    {
        $this
            ->setFactuurSamenvatting($factuurSamenvatting);
    }
    /**
     * Get factuurSamenvatting value
     * @return \StructType\FactSamenvatV4[]|null
     */
    public function getFactuurSamenvatting()
    {
        return $this->factuurSamenvatting;
    }
    /**
     * Set factuurSamenvatting value
     * @throws \InvalidArgumentException
     * @param \StructType\FactSamenvatV4[] $factuurSamenvatting
     * @return \StructType\FactSamenvatInfoV4
     */
    public function setFactuurSamenvatting(array $factuurSamenvatting = array())
    {
        foreach ($factuurSamenvatting as $factSamenvatInfoV4FactuurSamenvattingItem) {
            // validation for constraint: itemType
            if (!$factSamenvatInfoV4FactuurSamenvattingItem instanceof \StructType\FactSamenvatV4) {
                throw new \InvalidArgumentException(sprintf('The factuurSamenvatting property can only contain items of \StructType\FactSamenvatV4, "%s" given', is_object($factSamenvatInfoV4FactuurSamenvattingItem) ? get_class($factSamenvatInfoV4FactuurSamenvattingItem) : gettype($factSamenvatInfoV4FactuurSamenvattingItem)), __LINE__);
            }
        }
        $this->factuurSamenvatting = $factuurSamenvatting;
        return $this;
    }
    /**
     * Add item to factuurSamenvatting value
     * @throws \InvalidArgumentException
     * @param \StructType\FactSamenvatV4 $item
     * @return \StructType\FactSamenvatInfoV4
     */
    public function addToFactuurSamenvatting(\StructType\FactSamenvatV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FactSamenvatV4) {
            throw new \InvalidArgumentException(sprintf('The factuurSamenvatting property can only contain items of \StructType\FactSamenvatV4, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->factuurSamenvatting[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FactSamenvatInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
