<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FactSamenvatBtwInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met BTW gegevens van de factuur samenvatting.
 * @subpackage Structs
 */
class FactSamenvatBtwInfoV4 extends AbstractStructBase
{
    /**
     * The btw
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met btw gegevens van de factuur samenvatting.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\FactSamenvatBtwV4[]
     */
    public $btw;
    /**
     * Constructor method for FactSamenvatBtwInfoV4
     * @uses FactSamenvatBtwInfoV4::setBtw()
     * @param \StructType\FactSamenvatBtwV4[] $btw
     */
    public function __construct(array $btw = array())
    {
        $this
            ->setBtw($btw);
    }
    /**
     * Get btw value
     * @return \StructType\FactSamenvatBtwV4[]|null
     */
    public function getBtw()
    {
        return $this->btw;
    }
    /**
     * Set btw value
     * @throws \InvalidArgumentException
     * @param \StructType\FactSamenvatBtwV4[] $btw
     * @return \StructType\FactSamenvatBtwInfoV4
     */
    public function setBtw(array $btw = array())
    {
        foreach ($btw as $factSamenvatBtwInfoV4BtwItem) {
            // validation for constraint: itemType
            if (!$factSamenvatBtwInfoV4BtwItem instanceof \StructType\FactSamenvatBtwV4) {
                throw new \InvalidArgumentException(sprintf('The btw property can only contain items of \StructType\FactSamenvatBtwV4, "%s" given', is_object($factSamenvatBtwInfoV4BtwItem) ? get_class($factSamenvatBtwInfoV4BtwItem) : gettype($factSamenvatBtwInfoV4BtwItem)), __LINE__);
            }
        }
        $this->btw = $btw;
        return $this;
    }
    /**
     * Add item to btw value
     * @throws \InvalidArgumentException
     * @param \StructType\FactSamenvatBtwV4 $item
     * @return \StructType\FactSamenvatBtwInfoV4
     */
    public function addToBtw(\StructType\FactSamenvatBtwV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FactSamenvatBtwV4) {
            throw new \InvalidArgumentException(sprintf('The btw property can only contain items of \StructType\FactSamenvatBtwV4, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->btw[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FactSamenvatBtwInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
